/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.area.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.IAreaVisitor;
import org.eclipse.birt.report.engine.layout.area.IContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public abstract class ContainerArea
extends AbstractArea
implements IContainerArea {
    protected boolean needClip;
    protected int maxChildrenBaseLine = 0;
    protected int maxChildrenBaseLineBelow = 0;
    protected ArrayList<IArea> children = new ArrayList();

    ContainerArea(IContent content) {
        super(content);
    }

    ContainerArea(IReportContent report) {
        super(report);
    }

    public Iterator<IArea> getChildren() {
        return this.children.iterator();
    }

    @Override
    public void addChild(IArea area) {
        this.children.add(area);
    }

    public void addChild(int index, IArea area) {
        this.children.add(index, area);
    }

    public int indexOf(IArea area) {
        return this.children.indexOf(area);
    }

    public void removeAll() {
        this.children.clear();
    }

    public void removeChild(IArea area) {
        this.children.remove(area);
    }

    @Override
    public void accept(IAreaVisitor visitor) {
        visitor.visitContainer(this);
    }

    @Override
    public int getChildrenCount() {
        return this.children.size();
    }

    public int getContentY() {
        return PropertyUtil.getDimensionValue(this.style.getProperty(27), this.width) + PropertyUtil.getDimensionValue(this.style.getProperty(19), this.width);
    }

    public int getContentX() {
        return PropertyUtil.getDimensionValue(this.style.getProperty(50), this.width) + PropertyUtil.getDimensionValue(this.style.getProperty(12), this.width);
    }

    public int getIntrisicHeight() {
        return PropertyUtil.getDimensionValue(this.style.getProperty(6)) + PropertyUtil.getDimensionValue(this.style.getProperty(19)) + PropertyUtil.getDimensionValue(this.style.getProperty(27)) + PropertyUtil.getDimensionValue(this.style.getProperty(2)) + PropertyUtil.getDimensionValue(this.style.getProperty(13)) + PropertyUtil.getDimensionValue(this.style.getProperty(10));
    }

    @Override
    public boolean needClip() {
        return this.needClip;
    }

    @Override
    public void setNeedClip(boolean needClip) {
        this.needClip = needClip;
    }

    public int getMaxChildrenBaseLine() {
        return this.maxChildrenBaseLine;
    }

    public void setMaxChildrenBaseLine(int maxChildrenBaseLine) {
        this.maxChildrenBaseLine = maxChildrenBaseLine;
    }

    public int getMaxChildrenBaseLineBelow() {
        return this.maxChildrenBaseLineBelow;
    }

    public void setMaxChildrenBaseLineBelow(int maxChildrenBaseLineBelow) {
        this.maxChildrenBaseLineBelow = maxChildrenBaseLineBelow;
    }
}

