/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.facttable;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.birt.data.engine.cache.Constants;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionKey;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.DimensionDivision;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.DiskSortedStack;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;

class DimensionDivider {
    DimensionDivider() {
    }

    static int[] divideDimension(int[] dimensionLength, int blockNumber) {
        HashSet indexSet = new HashSet();
        int[] subDimensionCount = new int[dimensionLength.length];
        Arrays.fill(subDimensionCount, 1);
        if (blockNumber > 1) {
            DimensionDivider.calculateSubDimensionCount(dimensionLength, blockNumber, subDimensionCount, indexSet);
        }
        return subDimensionCount;
    }

    private static void calculateSubDimensionCount(int[] dimensionLength, int maxSubDimensionCount, int[] subDimensionCount, Set indexSet) {
        if (indexSet.size() == subDimensionCount.length) {
            return;
        }
        int i = 0;
        while (i < subDimensionCount.length) {
            if (!indexSet.contains(i)) {
                if (subDimensionCount[i] + 1 > dimensionLength[i]) {
                    indexSet.add(i);
                } else {
                    int n = i;
                    subDimensionCount[n] = subDimensionCount[n] + 1;
                    if (DimensionDivider.isOver(subDimensionCount, maxSubDimensionCount)) {
                        int n2 = i;
                        subDimensionCount[n2] = subDimensionCount[n2] - 1;
                        return;
                    }
                }
            }
            ++i;
        }
        DimensionDivider.calculateSubDimensionCount(dimensionLength, maxSubDimensionCount, subDimensionCount, indexSet);
    }

    private static boolean isOver(int[] candidateArray, int target) {
        int candidate = 1;
        int i = 0;
        while (i < candidateArray.length) {
            if ((candidate *= candidateArray[i]) > target) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static class CombinedPositionContructor {
        private DimensionDivision[] subDimensions;
        private int[] dimensionBitLength;
        private int totalBitLength;

        public CombinedPositionContructor(DimensionDivision[] subDimensions) {
            this.subDimensions = subDimensions;
            this.calculateBitLength(subDimensions);
        }

        private void calculateBitLength(DimensionDivision[] dimensionDivision) {
            this.dimensionBitLength = new int[dimensionDivision.length];
            int i = 0;
            while (i < dimensionDivision.length) {
                DimensionDivision.IntRange[] ranges = dimensionDivision[i].getRanges();
                int maxRange = 0;
                int j = 0;
                while (j < ranges.length) {
                    if (ranges[j].end - ranges[j].start > maxRange) {
                        maxRange = ranges[j].end - ranges[j].start + 1;
                    }
                    ++j;
                }
                this.dimensionBitLength[i] = this.getBitLength(maxRange);
                this.totalBitLength += this.dimensionBitLength[i];
                ++i;
            }
        }

        private int getBitLength(int maxInt) {
            int bitLength = 1;
            int powerValue = 2;
            while (powerValue < maxInt) {
                ++bitLength;
                powerValue *= 2;
            }
            return bitLength;
        }

        public BigInteger calculateCombinedPosition(int[] subdimensionIndex, int[] dimensionPosition) {
            long l = dimensionPosition[0] - this.subDimensions[0].getRanges()[subdimensionIndex[0]].start;
            int bitLength = this.dimensionBitLength[0];
            int i = 1;
            while (i < dimensionPosition.length) {
                if (bitLength + this.dimensionBitLength[i] >= 63) break;
                l <<= this.dimensionBitLength[i];
                l |= (long)(dimensionPosition[i] - this.subDimensions[i].getRanges()[subdimensionIndex[i]].start);
                bitLength += this.dimensionBitLength[i];
                ++i;
            }
            BigInteger bigInteger = BigInteger.valueOf(l);
            while (i < dimensionPosition.length) {
                bigInteger = bigInteger.shiftLeft(this.dimensionBitLength[i]);
                bigInteger = bigInteger.or(BigInteger.valueOf(dimensionPosition[i] - this.subDimensions[i].getRanges()[subdimensionIndex[i]].start));
                ++i;
            }
            return bigInteger;
        }

        public int[] calculateDimensionPosition(int[] subdimensionIndex, byte[] combinedPosition) {
            BigInteger bigInteger = new BigInteger(combinedPosition);
            int[] dimensionPosition = new int[this.dimensionBitLength.length];
            if (this.totalBitLength <= 63) {
                long l = bigInteger.longValue();
                int i = this.dimensionBitLength.length - 1;
                while (i >= 0) {
                    dimensionPosition[i] = this.subDimensions[i].getRanges()[subdimensionIndex[i]].start + (int)(l & (long)(Integer.MAX_VALUE >> 31 - this.dimensionBitLength[i]));
                    l >>= this.dimensionBitLength[i];
                    --i;
                }
                return dimensionPosition;
            }
            int i = this.dimensionBitLength.length - 1;
            while (i >= 0) {
                dimensionPosition[i] = this.subDimensions[i].getRanges()[subdimensionIndex[i]].start + (int)bigInteger.and(BigInteger.valueOf(Integer.MAX_VALUE >> 31 - this.dimensionBitLength[i])).longValue();
                bigInteger = bigInteger.shiftRight(this.dimensionBitLength[i]);
                --i;
            }
            return dimensionPosition;
        }
    }

    public static class DimensionPositionSeeker {
        private IDiskArray diskMemberArray;
        private DimensionKey[] memberArray;
        private int diskPostion;
        private int position;

        DimensionPositionSeeker(IDiskArray member) throws IOException {
            IDiskArray members = this.getSortedDimensionKeys(member);
            this.memberArray = Constants.isAggressiveMemoryUsage() ? new DimensionKey[members.size()] : new DimensionKey[members.size()];
            int i = 0;
            while (i < this.memberArray.length) {
                this.memberArray[i] = (DimensionKey)members.get(i);
                ++i;
            }
            if (members.size() > this.memberArray.length) {
                this.diskMemberArray = members;
                this.position = this.diskPostion = this.memberArray.length;
            }
        }

        private IDiskArray getSortedDimensionKeys(IDiskArray members) throws IOException {
            DiskSortedStack sortedStack = new DiskSortedStack(members.size(), true, false, DimensionKey.getCreator());
            int i = 0;
            while (i < members.size()) {
                sortedStack.push(members.get(i));
                ++i;
            }
            BufferedStructureArray resultArray = new BufferedStructureArray(DimensionKey.getCreator(), sortedStack.size());
            Object key = sortedStack.pop();
            while (key != null) {
                resultArray.add(key);
                key = sortedStack.pop();
            }
            return resultArray;
        }

        int find(DimensionKey key) throws IOException {
            int result = this.binarySearch(key);
            if (result >= 0) {
                return result;
            }
            if (this.diskMemberArray != null) {
                return this.traverseFind(key);
            }
            return result;
        }

        private int binarySearch(DimensionKey key) {
            int result = Arrays.binarySearch(this.memberArray, key);
            if (result >= 0) {
                return this.memberArray[result].getDimensionPos();
            }
            return -1;
        }

        private int traverseFind(DimensionKey key) throws IOException {
            int i = this.position;
            while (i < this.diskMemberArray.size()) {
                if (((DimensionKey)this.diskMemberArray.get(i)).compareTo(key) == 0) {
                    this.position = i;
                    return ((DimensionKey)this.diskMemberArray.get(i)).getDimensionPos();
                }
                ++i;
            }
            i = this.diskPostion;
            while (i < this.position) {
                if (((DimensionKey)this.diskMemberArray.get(i)).compareTo(key) == 0) {
                    this.position = i;
                    return ((DimensionKey)this.diskMemberArray.get(i)).getDimensionPos();
                }
                ++i;
            }
            return -1;
        }

        public static class DimensionInfo {
            String dimensionName;
            int dimensionLength;

            public String getDimensionName() {
                return this.dimensionName;
            }

            public int getDimensionLength() {
                return this.dimensionLength;
            }
        }
    }
}

