/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.samplesview.action;

import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.samplesview.util.PlaceResources;
import org.eclipse.birt.report.designer.ui.samplesview.view.ReportExamples;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

public class ExportSampleReportAction
extends Action
implements Listener {
    private static final String DRILL_TO_DETAILS_CATEGORY = "Drill to Details";
    private static final String[] REPORTDESIGN_FILENAME_PATTERN = new String[]{"*.rptdesign"};
    private static final String ACTION_TEXT = Messages.getString((String)"SampleReportsView.Action.exportSampleReport");
    private ReportExamples composite;

    public ExportSampleReportAction(ReportExamples composite) {
        super(ACTION_TEXT);
        this.setToolTipText(Messages.getString((String)"SampleReportsView.Action.exportSampleReport.toolTipText"));
        this.setImageDescriptor(ReportPlatformUIImages.getImageDescriptor((String)"export_enable"));
        this.setDisabledImageDescriptor(ReportPlatformUIImages.getImageDescriptor((String)"export_disable"));
        this.setEnabled(false);
        this.composite = composite;
        composite.addSelectedListener(this);
    }

    public void run() {
        Object selectedElement = ((TreeItem)this.composite.getSelectedElement()).getData();
        if (selectedElement == null || !(selectedElement instanceof ReportDesignHandle)) {
            return;
        }
        String filename = ((ReportDesignHandle)selectedElement).getFileName();
        String reportName = filename.substring(filename.lastIndexOf("/") + 1);
        FileDialog saveDialog = new FileDialog(this.composite.getShell(), 8192);
        saveDialog.setFilterExtensions(REPORTDESIGN_FILENAME_PATTERN);
        saveDialog.setFileName(reportName);
        if (saveDialog.open() == null) {
            return;
        }
        PlaceResources.copy(this.composite.getShell(), saveDialog.getFilterPath(), saveDialog.getFileName(), filename);
        PlaceResources.copyExcludedRptDesignes(this.composite.getShell(), saveDialog.getFilterPath(), filename, true);
        if (((TreeItem)this.composite.getSelectedElement()).getParentItem().getText().equals(DRILL_TO_DETAILS_CATEGORY)) {
            PlaceResources.copyDrillThroughReport(this.composite.getShell(), saveDialog.getFilterPath(), reportName);
        }
    }

    public void handleEvent(Event event) {
        TreeItem item;
        if (event.widget == null || !(event.widget instanceof TreeItem)) {
            this.setEnabled(false);
        }
        if ((item = (TreeItem)event.widget) == null) {
            super.setEnabled(false);
            return;
        }
        Object selectedElement = item.getData();
        if (selectedElement == null) {
            super.setEnabled(false);
        } else {
            super.setEnabled(selectedElement instanceof ReportDesignHandle);
        }
    }
}

