/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.processors.checksum;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.processors.checksum.ChecksumVerifier;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.repository.helpers.ChecksumHelper;
import org.eclipse.equinox.internal.p2.repository.helpers.ChecksumProducer;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ProcessingStepDescriptor;
import org.eclipse.osgi.util.NLS;

public class ChecksumUtilities {
    private static final String ARTIFACT_CHECKSUMS_POINT = "org.eclipse.equinox.p2.artifact.repository.artifactChecksums";

    public static Collection<ChecksumVerifier> getChecksumVerifiers(IArtifactDescriptor descriptor, String property, Set<String> checksumsToSkip) throws IllegalArgumentException {
        ArrayList<ChecksumVerifier> steps = new ArrayList<ChecksumVerifier>();
        Map checksums = ChecksumHelper.getChecksums((IArtifactDescriptor)descriptor, (String)property);
        IConfigurationElement[] checksumVerifierConfigurations = ChecksumUtilities.getChecksumComparatorConfigurations();
        for (Map.Entry checksumEntry : checksums.entrySet()) {
            if (checksumsToSkip.contains(checksumEntry.getKey())) continue;
            IConfigurationElement[] iConfigurationElementArray = checksumVerifierConfigurations;
            int n = checksumVerifierConfigurations.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement checksumVerifierConfiguration = iConfigurationElementArray[n2];
                String checksumId = checksumVerifierConfiguration.getAttribute("id");
                if (((String)checksumEntry.getKey()).equals(checksumId)) {
                    String checksumAlgorithm = checksumVerifierConfiguration.getAttribute("algorithm");
                    String providerName = checksumVerifierConfiguration.getAttribute("providerName");
                    boolean insecure = Boolean.parseBoolean(checksumVerifierConfiguration.getAttribute("warnInsecure"));
                    int priority = ChecksumUtilities.parsePriority(checksumVerifierConfiguration.getAttribute("priority"));
                    ChecksumVerifier checksumVerifier = new ChecksumVerifier(checksumAlgorithm, providerName, checksumId, insecure, priority);
                    checksumVerifier.initialize(null, (IProcessingStepDescriptor)new ProcessingStepDescriptor(null, (String)checksumEntry.getValue(), true), descriptor);
                    if (checksumVerifier.getStatus().isOK()) {
                        steps.add(checksumVerifier);
                    } else {
                        LogHelper.log((IStatus)checksumVerifier.getStatus());
                    }
                }
                ++n2;
            }
        }
        if (!steps.isEmpty() && steps.stream().allMatch(ChecksumVerifier::isInsecureAlgorithm)) {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.repository", NLS.bind((String)Messages.onlyInsecureDigestAlgorithmUsed, (Object)steps.stream().map(ChecksumVerifier::getAlgorithmId).collect(Collectors.joining(",")), (Object)descriptor.getArtifactKey())));
        }
        return steps.stream().max(Comparator.comparing(ChecksumVerifier::getPriority)).stream().collect(Collectors.toList());
    }

    private static int parsePriority(String attribute) {
        if (attribute != null && !attribute.isBlank()) {
            try {
                return Integer.parseInt(attribute);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static IConfigurationElement[] getChecksumComparatorConfigurations() {
        return RegistryFactory.getRegistry().getConfigurationElementsFor(ARTIFACT_CHECKSUMS_POINT);
    }

    /*
     * WARNING - void declaration
     */
    public static IStatus calculateChecksums(File pathOnDisk, Map<String, String> checksums, Collection<String> checksumsToSkip) {
        void var6_10;
        MultiStatus status = new MultiStatus("org.eclipse.equinox.p2.repository", 0, NLS.bind((String)Messages.calculateChecksum_file, (Object)pathOnDisk.getAbsolutePath()), null);
        HashMap<ChecksumProducer, MessageDigest> digestMap = new HashMap<ChecksumProducer, MessageDigest>();
        IConfigurationElement[] iConfigurationElementArray = ChecksumUtilities.getChecksumComparatorConfigurations();
        int n = iConfigurationElementArray.length;
        boolean n2 = false;
        while (var6_10 < n) {
            IConfigurationElement checksumVerifierConfiguration = iConfigurationElementArray[var6_10];
            String id = checksumVerifierConfiguration.getAttribute("id");
            if (!checksumsToSkip.contains(id) && ChecksumUtilities.shouldPublish(checksumVerifierConfiguration)) {
                String algorithm = checksumVerifierConfiguration.getAttribute("algorithm");
                String providerName = checksumVerifierConfiguration.getAttribute("providerName");
                try {
                    ChecksumProducer producer = new ChecksumProducer(id, algorithm, providerName);
                    digestMap.put(producer, producer.getMessageDigest());
                }
                catch (GeneralSecurityException e) {
                    String message = NLS.bind((String)Messages.calculateChecksum_providerError, (Object[])new Object[]{id, algorithm, providerName});
                    status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", message, (Throwable)e));
                }
            }
            ++var6_10;
        }
        if (digestMap.isEmpty()) {
            return status;
        }
        try {
            try (InputStream stream = new FileInputStream(pathOnDisk);){
                for (MessageDigest messageDigest : digestMap.values()) {
                    stream = new DigestInputStream(stream, messageDigest);
                }
                ((InputStream)stream).transferTo(OutputStream.nullOutputStream());
            }
            for (Map.Entry entry : digestMap.entrySet()) {
                ChecksumProducer producer = (ChecksumProducer)entry.getKey();
                String checksum = ChecksumHelper.toHexString((byte[])((MessageDigest)entry.getValue()).digest());
                String id = producer.getId();
                String message = NLS.bind((String)Messages.calculateChecksum_ok, (Object[])new Object[]{id, producer.getAlgorithm(), producer.getProviderName(), checksum});
                status.add((IStatus)new Status(0, "org.eclipse.equinox.p2.repository", message));
                checksums.put(id, checksum);
            }
        }
        catch (IOException e) {
            String string = NLS.bind((String)Messages.calculateChecksum_file, (Object)pathOnDisk.getAbsolutePath());
            status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", string, (Throwable)e));
        }
        return status;
    }

    private static boolean shouldPublish(IConfigurationElement checksumVerifierConfiguration) {
        String attribute = checksumVerifierConfiguration.getAttribute("publish");
        if (attribute == null || attribute.isBlank()) {
            return true;
        }
        return Boolean.parseBoolean(attribute);
    }

    public static Map<String, String> checksumsToProperties(String property, Map<String, String> checksums) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<String, String> checksum : checksums.entrySet()) {
            properties.put(String.join((CharSequence)".", property, checksum.getKey()), checksum.getValue());
        }
        ChecksumUtilities.putLegacyMd5Property(property, checksums, properties);
        return properties;
    }

    private static void putLegacyMd5Property(String propertyNamespace, Map<String, String> checksums, HashMap<String, String> result) {
        String md5 = checksums.get("md5");
        if (md5 != null) {
            if ("artifact.checksum".equals(propertyNamespace)) {
                result.put("artifact.md5", md5);
            }
            if ("download.checksum".equals(propertyNamespace)) {
                result.put("download.md5", md5);
            }
        }
    }
}

