/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.apt.pluggable.core.filer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.internal.util.FileSystemUtil;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.apt.pluggable.core.Apt6Plugin;
import org.eclipse.jdt.internal.apt.pluggable.core.dispatch.IdeProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public class IdeClassOutputStream
extends ByteArrayOutputStream {
    private final IdeProcessingEnvImpl _env;
    private final IFile _file;

    public IdeClassOutputStream(IdeProcessingEnvImpl env, IFile file) {
        this._env = env;
        this._file = file;
    }

    @Override
    public void close() throws IOException {
        super.close();
        byte[] byteArray = this.toByteArray();
        ByteArrayInputStream contents = new ByteArrayInputStream(byteArray);
        Compiler compiler = this._env.getCompiler();
        ClassFileReader binaryType = null;
        try {
            try {
                try {
                    binaryType = ClassFileReader.read((String)this._file.getLocation().toString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (binaryType == null) {
                    this.saveToDisk(contents, true);
                } else {
                    this.saveToDisk(contents, false);
                }
                binaryType = ClassFileReader.read((String)this._file.getLocation().toString());
                char[][] splitOn = CharOperation.splitOn((char)'/', (char[])binaryType.getName());
                ReferenceBinding type = compiler.lookupEnvironment.getType(splitOn);
                if (type != null && type.isValidBinding()) {
                    if (type.isBinaryBinding()) {
                        this._env.addNewClassFile(type);
                    } else {
                        BinaryTypeBinding binaryBinding = new BinaryTypeBinding(type.getPackage(), (IBinaryType)binaryType, compiler.lookupEnvironment, true);
                        if (binaryBinding != null) {
                            this._env.addNewClassFile((ReferenceBinding)binaryBinding);
                        }
                    }
                }
            }
            catch (Exception ex) {
                Apt6Plugin.log(ex, "Could not create generated class file " + this._file.getName());
                this.closeInputStream(contents);
            }
        }
        finally {
            this.closeInputStream(contents);
        }
    }

    private void closeInputStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void saveToDisk(InputStream toSave, boolean create) throws IOException {
        block4: {
            try {
                FileSystemUtil.makeDerivedParentFolders((IContainer)this._file.getParent());
                if (create) {
                    this._file.create(toSave, 1025, null);
                } else {
                    this._file.setContents(toSave, true, false, null);
                }
            }
            catch (CoreException ce) {
                if (this._file.exists()) break block4;
                Apt6Plugin.log(ce, "Could not create generated class file " + this._file.getName());
                throw new IOException(ce);
            }
        }
    }
}

