/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IModulePathEntry;
import org.eclipse.jdt.internal.compiler.env.IMultiModuleEntry;
import org.eclipse.jdt.internal.core.builder.ClasspathDirectory;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;

public class ModulePathEntry
implements IModulePathEntry {
    private final IPath path;
    ClasspathLocation[] locations;
    IModule module;
    boolean isAutomaticModule;

    ModulePathEntry(IPath path, IModule module, ClasspathLocation[] locations) {
        this.path = path;
        this.locations = locations;
        this.module = module;
        this.isAutomaticModule = module.isAutomatic();
        this.initializeModule();
    }

    public ModulePathEntry(IPath path, ClasspathLocation location) {
        this.path = path;
        this.initModule(location);
        this.locations = new ClasspathLocation[]{location};
    }

    public IPath getPath() {
        return this.path;
    }

    public ClasspathLocation[] getClasspathLocations() {
        return this.locations;
    }

    public IModule getModule() {
        return this.module;
    }

    public boolean isAutomaticModule() {
        return this.isAutomaticModule;
    }

    public static IModule getAutomaticModule(ClasspathLocation location) {
        if (location instanceof ClasspathJar) {
            ClasspathJar classpathJar = (ClasspathJar)location;
            return IModule.createAutomatic((String)classpathJar.zipFilename, (boolean)true, (Manifest)classpathJar.getManifest());
        }
        if (location instanceof ClasspathDirectory) {
            return IModule.createAutomatic((String)((ClasspathDirectory)location).binaryFolder.getName(), (boolean)false, null);
        }
        return null;
    }

    private void initModule(ClasspathLocation location) {
        IModule mod = null;
        if (location instanceof ClasspathJar) {
            mod = ((ClasspathJar)location).initializeModule();
        } else if (location instanceof ClasspathDirectory) {
            mod = ((ClasspathDirectory)location).initializeModule();
        }
        if (mod != null) {
            this.module = mod;
            this.isAutomaticModule = false;
        } else {
            this.module = ModulePathEntry.getAutomaticModule(location);
            this.isAutomaticModule = true;
        }
        location.setModule(this.module);
    }

    private void initializeModule() {
        int i = 0;
        while (i < this.locations.length) {
            this.locations[i].setModule(this.module);
            ++i;
        }
    }

    public char[][] getModulesDeclaringPackage(String qualifiedPackageName, String moduleName) {
        if (!(moduleName == null || this.module != null && moduleName.equals(String.valueOf(this.module.name())))) {
            return null;
        }
        char[][] names = CharOperation.NO_CHAR_CHAR;
        ClasspathLocation[] classpathLocationArray = this.locations;
        int n = this.locations.length;
        int n2 = 0;
        while (n2 < n) {
            ClasspathLocation cp = classpathLocationArray[n2];
            char[][] declaringModules = cp.getModulesDeclaringPackage(qualifiedPackageName, moduleName);
            if (declaringModules != null) {
                names = CharOperation.arrayConcat((char[][])names, (char[][])declaringModules);
            }
            ++n2;
        }
        return names == CharOperation.NO_CHAR_CHAR ? null : names;
    }

    public boolean hasCompilationUnit(String qualifiedPackageName, String moduleName) {
        ClasspathLocation[] classpathLocationArray = this.locations;
        int n = this.locations.length;
        int n2 = 0;
        while (n2 < n) {
            ClasspathLocation cp = classpathLocationArray[n2];
            if (cp.hasCompilationUnit(qualifiedPackageName, moduleName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public char[][] listPackages() {
        char[][] packages = CharOperation.NO_CHAR_CHAR;
        if (this.isAutomaticModule) {
            ClasspathLocation[] classpathLocationArray = this.locations;
            int n = this.locations.length;
            int n2 = 0;
            while (n2 < n) {
                ClasspathLocation cp = classpathLocationArray[n2];
                packages = CharOperation.arrayConcat((char[][])packages, (char[][])cp.listPackages());
                ++n2;
            }
            return packages;
        }
        return packages;
    }

    public static class Multi
    extends ModulePathEntry
    implements IMultiModuleEntry {
        Multi(IPath path, IModule module, ClasspathLocation[] locations) {
            super(path, module, locations);
        }

        void addPatchLocation(ClasspathLocation location) {
            this.locations = Arrays.copyOf(this.locations, this.locations.length + 1);
            this.locations[this.locations.length - 1] = location;
            location.setModule(this.module);
        }

        public IModule getModule(char[] name) {
            ClasspathLocation[] classpathLocationArray = this.locations;
            int n = this.locations.length;
            int n2 = 0;
            while (n2 < n) {
                IModule mod;
                ClasspathLocation loc = classpathLocationArray[n2];
                if (loc instanceof IMultiModuleEntry ? (mod = ((IMultiModuleEntry)loc).getModule(name)) != null : CharOperation.equals((char[])(mod = loc.getModule()).name(), (char[])name)) {
                    return mod;
                }
                ++n2;
            }
            return null;
        }

        public Collection<String> getModuleNames(Collection<String> limitModules) {
            HashSet<String> result = new HashSet<String>();
            ClasspathLocation[] classpathLocationArray = this.locations;
            int n = this.locations.length;
            int n2 = 0;
            while (n2 < n) {
                ClasspathLocation loc = classpathLocationArray[n2];
                if (loc instanceof IMultiModuleEntry) {
                    result.addAll(((IMultiModuleEntry)loc).getModuleNames(limitModules));
                } else {
                    result.add(String.valueOf(loc.getModule().name()));
                }
                ++n2;
            }
            return result;
        }
    }
}

