/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.junit.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.junit.BasicElementLabels;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.buildpath.BuildPathSupport;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.CoreTestSearchEngine;
import org.eclipse.jdt.internal.junit.util.JUnitStatus;
import org.eclipse.jdt.internal.junit.util.JUnitStubUtility;
import org.eclipse.jdt.internal.junit.util.LayoutUtil;
import org.eclipse.jdt.internal.junit.wizards.MethodStubsSelectionButtonGroup;
import org.eclipse.jdt.internal.junit.wizards.WizardMessages;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageTwo;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.SelectionDialog;

public class NewTestCaseWizardPageOne
extends NewTypeWizardPage {
    private static final String PAGE_NAME = "NewTestCaseCreationWizardPage";
    public static final String CLASS_UNDER_TEST = "NewTestCaseCreationWizardPage.classundertest";
    public static final String JUNIT4TOGGLE = "NewTestCaseCreationWizardPage.junit4toggle";
    private static final String COMPLIANCE_PAGE_ID = "org.eclipse.jdt.ui.propertyPages.CompliancePreferencePage";
    private static final String BUILD_PATH_PAGE_ID = "org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage";
    private static final String BUILD_PATH_KEY_ADD_ENTRY = "add_classpath_entry";
    private static final String BUILD_PATH_BLOCK = "block_until_buildpath_applied";
    private static final String KEY_NO_LINK = "PropertyAndPreferencePage.nolink";
    private static final String QUESTION_MARK_TAG = "Q";
    private static final String OF_TAG = "Of";
    private static final String TEST_SUFFIX = "Test";
    private static final String PREFIX = "test";
    private static final String STORE_SETUP = "NewTestCaseCreationWizardPage.USE_SETUP";
    private static final String STORE_TEARDOWN = "NewTestCaseCreationWizardPage.USE_TEARDOWN";
    private static final String STORE_SETUP_CLASS = "NewTestCaseCreationWizardPage.USE_SETUPCLASS";
    private static final String STORE_TEARDOWN_CLASS = "NewTestCaseCreationWizardPage.USE_TEARDOWNCLASS";
    private static final String STORE_CONSTRUCTOR = "NewTestCaseCreationWizardPage.USE_CONSTRUCTOR";
    private static final int IDX_SETUP_CLASS = 0;
    private static final int IDX_TEARDOWN_CLASS = 1;
    private static final int IDX_SETUP = 2;
    private static final int IDX_TEARDOWN = 3;
    private static final int IDX_CONSTRUCTOR = 4;
    private NewTestCaseWizardPageTwo fPage2;
    private MethodStubsSelectionButtonGroup fMethodStubsButtons;
    private String fClassUnderTestText;
    private IType fClassUnderTest;
    private Text fClassUnderTestControl;
    private IStatus fClassUnderTestStatus;
    private Button fClassUnderTestButton;
    private JavaTypeCompletionProcessor fClassToTestCompletionProcessor;
    private Button fJUnit3Button;
    private Button fJUnit4Button;
    private Button fJUnit5Button;
    private IStatus fJUnitStatus;
    private boolean fIsJUnitEnabled;
    private Link fLink;
    private Label fImage;
    private JUnitVersion fJUnitVersion = JUnitVersion.VERSION_3;

    public NewTestCaseWizardPageOne(NewTestCaseWizardPageTwo page2) {
        super(true, PAGE_NAME);
        this.fPage2 = page2;
        this.setTitle(WizardMessages.NewTestCaseWizardPageOne_title);
        this.setDescription(WizardMessages.NewTestCaseWizardPageOne_description);
        this.enableCommentControl(true);
        this.fMethodStubsButtons = new MethodStubsSelectionButtonGroup(32, this.fJUnitVersion, 2){

            @Override
            protected void doWidgetSelected(SelectionEvent e) {
                super.doWidgetSelected(e);
                NewTestCaseWizardPageOne.this.saveWidgetValues();
            }
        };
        this.fMethodStubsButtons.setLabelText(WizardMessages.NewTestCaseWizardPageOne_method_Stub_label);
        this.fClassToTestCompletionProcessor = new JavaTypeCompletionProcessor(false, false, true);
        this.fClassUnderTestStatus = new JUnitStatus();
        this.fClassUnderTestText = "";
        this.fJUnitStatus = new JUnitStatus();
        this.setJUnitVersion(this.fJUnitVersion);
    }

    public void init(IStructuredSelection selection) {
        IJavaProject project;
        IJavaElement element = this.getInitialJavaElement(selection);
        this.initContainerPage(element, true);
        this.initTypePage(element);
        if (element != null) {
            IType classToTest = null;
            IType typeInCompUnit = (IType)element.getAncestor(7);
            if (typeInCompUnit != null) {
                if (typeInCompUnit.getCompilationUnit() != null) {
                    classToTest = typeInCompUnit;
                }
            } else {
                ICompilationUnit cu = (ICompilationUnit)element.getAncestor(5);
                if (cu != null) {
                    classToTest = cu.findPrimaryType();
                } else if (element instanceof IClassFile) {
                    try {
                        IClassFile cf = (IClassFile)element;
                        if (cf instanceof IOrdinaryClassFile && cf.isStructureKnown()) {
                            classToTest = ((IOrdinaryClassFile)cf).getType();
                        }
                    }
                    catch (JavaModelException e) {
                        JUnitPlugin.log(e);
                    }
                }
            }
            if (classToTest != null) {
                try {
                    if (!CoreTestSearchEngine.isTestImplementor((IType)classToTest)) {
                        this.setClassUnderTest(classToTest.getFullyQualifiedName('.'));
                    }
                }
                catch (JavaModelException e) {
                    JUnitPlugin.log(e);
                }
            }
        }
        this.restoreWidgetValues();
        boolean isJunit5 = false;
        boolean isJunit4 = false;
        if (!(element == null || element.getElementType() == 1 || (isJunit5 = CoreTestSearchEngine.hasJUnit5TestAnnotation((IJavaProject)(project = element.getJavaProject()))) || (isJunit4 = CoreTestSearchEngine.hasJUnit4TestAnnotation((IJavaProject)project)) || CoreTestSearchEngine.hasTestCaseType((IJavaProject)project))) {
            if (JUnitStubUtility.is18OrHigher(project)) {
                isJunit5 = true;
            } else if (JUnitStubUtility.is50OrHigher(project)) {
                isJunit4 = true;
            }
        }
        if (isJunit5) {
            this.setJUnitVersion(JUnitVersion.VERSION_5);
        } else if (isJunit4) {
            this.setJUnitVersion(JUnitVersion.VERSION_4);
        } else {
            this.setJUnitVersion(JUnitVersion.VERSION_3);
        }
        this.setEnabled(true);
        this.updateStatus(this.getStatusList());
    }

    private IStatus junitStatusChanged() {
        JUnitStatus status = new JUnitStatus();
        return status;
    }

    @Deprecated
    public void setJUnit4(boolean isJUnit4, boolean isEnabled) {
        this.setEnabled(isEnabled);
        if (isJUnit4) {
            this.setJUnitVersion(JUnitVersion.VERSION_4);
        } else {
            this.setJUnitVersion(JUnitVersion.VERSION_3);
        }
    }

    public void setJUnitVersion(JUnitVersion version) {
        this.internalSetJUnit(version);
        switch (this.fJUnitVersion) {
            case VERSION_5: {
                if (this.fJUnit5Button == null || this.fJUnit5Button.isDisposed()) break;
                this.fJUnit5Button.setSelection(true);
                break;
            }
            case VERSION_4: {
                if (this.fJUnit4Button == null || this.fJUnit4Button.isDisposed()) break;
                this.fJUnit4Button.setSelection(true);
                break;
            }
            case VERSION_3: {
                if (this.fJUnit3Button == null || this.fJUnit3Button.isDisposed()) break;
                this.fJUnit3Button.setSelection(true);
                break;
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.fIsJUnitEnabled = enabled;
        if (this.fJUnit5Button != null && !this.fJUnit5Button.isDisposed()) {
            this.fJUnit5Button.setEnabled(this.fIsJUnitEnabled);
        }
        if (this.fJUnit4Button != null && !this.fJUnit4Button.isDisposed()) {
            this.fJUnit4Button.setEnabled(this.fIsJUnitEnabled);
        }
        if (this.fJUnit3Button != null && !this.fJUnit3Button.isDisposed()) {
            this.fJUnit3Button.setEnabled(this.fIsJUnitEnabled);
        }
    }

    @Deprecated
    public boolean isJUnit4() {
        return this.getJUnitVersion() == JUnitVersion.VERSION_4;
    }

    public JUnitVersion getJUnitVersion() {
        return this.fJUnitVersion;
    }

    private void internalSetJUnit(JUnitVersion version) {
        this.fJUnitVersion = version;
        this.fMethodStubsButtons.updateButtons(version);
        this.fJUnitStatus = this.junitStatusChanged();
        if (this.isDefaultSuperClass() || "".equals(this.getSuperClass().trim())) {
            this.setSuperClass(this.getDefaultSuperClassName(), true);
        }
        this.fSuperClassStatus = this.superClassChanged();
        this.handleFieldChanged(JUNIT4TOGGLE);
    }

    private boolean isDefaultSuperClass() {
        String superClass = this.getSuperClass();
        return superClass.equals(this.getJUnit3TestSuperclassName()) || "java.lang.Object".equals(superClass);
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if ("NewContainerWizardPage.container".equals(fieldName)) {
            this.fClassUnderTestStatus = this.classUnderTestChanged();
            if (this.fClassUnderTestButton != null && !this.fClassUnderTestButton.isDisposed()) {
                this.fClassUnderTestButton.setEnabled(this.getPackageFragmentRoot() != null);
            }
            this.fJUnitStatus = this.junitStatusChanged();
            this.updateBuildPathMessage();
        } else if (JUNIT4TOGGLE.equals(fieldName)) {
            this.updateBuildPathMessage();
            boolean isJUnit3 = this.getJUnitVersion() == JUnitVersion.VERSION_3;
            this.fMethodStubsButtons.setEnabled(0, !isJUnit3);
            this.fMethodStubsButtons.setEnabled(1, !isJUnit3);
            this.fMethodStubsButtons.setEnabled(4, isJUnit3);
        }
        this.updateStatus(this.getStatusList());
    }

    protected IStatus[] getStatusList() {
        return new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fClassUnderTestStatus, this.fModifierStatus, this.fSuperClassStatus, this.fJUnitStatus};
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createJUnit4Controls(composite, nColumns);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.createCommentControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createClassUnderTestControls(composite, nColumns);
        this.createBuildPathConfigureControls(composite, nColumns);
        this.setControl((Control)composite);
        String classUnderTest = this.getClassUnderTestText();
        if (classUnderTest.length() > 0) {
            String typeName = this.getUniqueJavaTypeName(this.getPackageFragment(), Signature.getSimpleName((String)classUnderTest) + TEST_SUFFIX);
            this.setTypeName(typeName, true);
        }
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.junit.new_testcase_wizard_page_context");
        this.setFocus();
    }

    protected void createMethodStubSelectionControls(Composite composite, int nColumns) {
        LayoutUtil.setHorizontalSpan((Control)this.fMethodStubsButtons.getLabelControl(composite), nColumns);
        LayoutUtil.createEmptySpace(composite, 1);
        LayoutUtil.setHorizontalSpan((Control)this.fMethodStubsButtons.getSelectionButtonsGroup(composite), nColumns - 1);
    }

    protected void createClassUnderTestControls(Composite composite, int nColumns) {
        Label classUnderTestLabel = new Label(composite, 16448);
        classUnderTestLabel.setFont(composite.getFont());
        classUnderTestLabel.setText(WizardMessages.NewTestCaseWizardPageOne_class_to_test_label);
        classUnderTestLabel.setLayoutData((Object)new GridData());
        this.fClassUnderTestControl = new Text(composite, 2052);
        this.fClassUnderTestControl.setEnabled(true);
        this.fClassUnderTestControl.setFont(composite.getFont());
        this.fClassUnderTestControl.setText(this.fClassUnderTestText);
        this.fClassUnderTestControl.addModifyListener(modifyEvent -> this.internalSetClassUnderText(((Text)modifyEvent.widget).getText()));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = nColumns - 2;
        this.fClassUnderTestControl.setLayoutData((Object)gd);
        this.fClassUnderTestButton = new Button(composite, 8);
        this.fClassUnderTestButton.setText(WizardMessages.NewTestCaseWizardPageOne_class_to_test_browse);
        this.fClassUnderTestButton.setEnabled(this.getPackageFragmentRoot() != null);
        this.fClassUnderTestButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                NewTestCaseWizardPageOne.this.classToTestButtonPressed();
            }

            public void widgetSelected(SelectionEvent e) {
                NewTestCaseWizardPageOne.this.classToTestButtonPressed();
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = 1;
        gd.widthHint = LayoutUtil.getButtonWidthHint(this.fClassUnderTestButton);
        this.fClassUnderTestButton.setLayoutData((Object)gd);
        ControlContentAssistHelper.createTextContentAssistant((Text)this.fClassUnderTestControl, (IContentAssistProcessor)this.fClassToTestCompletionProcessor);
    }

    protected void createJUnit4Controls(Composite composite, int nColumns) {
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(4, 0x1000000, false, false, nColumns, 1));
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        JUnitVersion version = this.getJUnitVersion();
        this.fJUnit3Button = new Button(inner, 16);
        this.fJUnit3Button.setText(WizardMessages.NewTestCaseWizardPageOne_junit3_radio_label);
        this.fJUnit3Button.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.fJUnit3Button.setSelection(version == JUnitVersion.VERSION_3);
        this.fJUnit3Button.setEnabled(this.fIsJUnitEnabled);
        this.fJUnit3Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    NewTestCaseWizardPageOne.this.internalSetJUnit(JUnitVersion.VERSION_3);
                }
            }
        });
        this.fJUnit4Button = new Button(inner, 16);
        this.fJUnit4Button.setText(WizardMessages.NewTestCaseWizardPageOne_junit4_radio_label);
        this.fJUnit4Button.setSelection(version == JUnitVersion.VERSION_4);
        this.fJUnit4Button.setEnabled(this.fIsJUnitEnabled);
        this.fJUnit4Button.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.fJUnit4Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    NewTestCaseWizardPageOne.this.internalSetJUnit(JUnitVersion.VERSION_4);
                }
            }
        });
        this.fJUnit5Button = new Button(inner, 16);
        this.fJUnit5Button.setText(WizardMessages.NewTestCaseWizardPageOne_junit5_radio_label);
        this.fJUnit5Button.setSelection(version == JUnitVersion.VERSION_5);
        this.fJUnit5Button.setEnabled(this.fIsJUnitEnabled);
        this.fJUnit5Button.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.fJUnit5Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    NewTestCaseWizardPageOne.this.internalSetJUnit(JUnitVersion.VERSION_5);
                }
            }
        });
    }

    protected void createBuildPathConfigureControls(Composite composite, int nColumns) {
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(4, 4, false, false, nColumns, 1));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        inner.setLayout((Layout)layout);
        this.fImage = new Label(inner, 0);
        this.fImage.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        this.fImage.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        this.fLink = new Link(inner, 64);
        this.fLink.setText("\n\n");
        this.fLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewTestCaseWizardPageOne.this.performBuildpathConfiguration(e.text);
            }
        });
        GridData gd = new GridData(4, 1, true, false, 1, 1);
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        this.fLink.setLayoutData((Object)gd);
        this.updateBuildPathMessage();
    }

    private void performBuildpathConfiguration(Object data) {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return;
        }
        IJavaProject javaProject = root.getJavaProject();
        if ("a3".equals(data)) {
            String id = BUILD_PATH_PAGE_ID;
            HashMap<String, Object> input = new HashMap<String, Object>();
            IClasspathEntry newEntry = BuildPathSupport.getJUnit3ClasspathEntry();
            input.put(BUILD_PATH_KEY_ADD_ENTRY, newEntry);
            input.put(BUILD_PATH_BLOCK, Boolean.TRUE);
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)javaProject, (String)id, (String[])new String[]{id}, input).open();
        } else if ("a4".equals(data)) {
            String id = BUILD_PATH_PAGE_ID;
            HashMap<String, Object> input = new HashMap<String, Object>();
            IClasspathEntry newEntry = BuildPathSupport.getJUnit4ClasspathEntry();
            input.put(BUILD_PATH_KEY_ADD_ENTRY, newEntry);
            input.put(BUILD_PATH_BLOCK, Boolean.TRUE);
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)javaProject, (String)id, (String[])new String[]{id}, input).open();
        } else if ("b".equals(data)) {
            String id = BUILD_PATH_PAGE_ID;
            HashMap<String, Boolean> input = new HashMap<String, Boolean>();
            input.put(BUILD_PATH_BLOCK, Boolean.TRUE);
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)javaProject, (String)id, (String[])new String[]{id}, input).open();
        } else if ("c".equals(data)) {
            String buildPath = BUILD_PATH_PAGE_ID;
            String complianceId = COMPLIANCE_PAGE_ID;
            HashMap<String, Boolean> input = new HashMap<String, Boolean>();
            input.put(BUILD_PATH_BLOCK, Boolean.TRUE);
            input.put(KEY_NO_LINK, Boolean.TRUE);
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)javaProject, (String)complianceId, (String[])new String[]{buildPath, complianceId}, (Object)data).open();
        }
        this.updateBuildPathMessage();
    }

    private void updateBuildPathMessage() {
        IJavaProject project;
        if (this.fLink == null || this.fLink.isDisposed()) {
            return;
        }
        String message = null;
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root != null && (project = root.getJavaProject()).exists()) {
            if (this.fJUnitVersion == JUnitVersion.VERSION_4) {
                if (!JUnitStubUtility.is50OrHigher(project)) {
                    message = WizardMessages.NewTestCaseWizardPageOne_linkedtext_java5required;
                }
            } else if (this.fJUnitVersion == JUnitVersion.VERSION_5 && !JUnitStubUtility.is18OrHigher(project)) {
                message = WizardMessages.NewTestCaseWizardPageOne_linkedtext_java8required;
            }
        }
        this.fLink.setVisible(message != null);
        this.fImage.setVisible(message != null);
        if (message != null) {
            this.fLink.setText(message);
        }
    }

    private void classToTestButtonPressed() {
        IType type = this.chooseClassToTestType();
        if (type != null) {
            this.setClassUnderTest(type.getFullyQualifiedName('.'));
        }
    }

    private IType chooseClassToTestType() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{root.getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        try {
            Object[] resultArray;
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)this.getWizard().getContainer(), (IJavaSearchScope)scope, (int)1024, (boolean)false, (String)this.getClassUnderTestText());
            dialog.setTitle(WizardMessages.NewTestCaseWizardPageOne_class_to_test_dialog_title);
            dialog.setMessage(WizardMessages.NewTestCaseWizardPageOne_class_to_test_dialog_message);
            if (dialog.open() == 0 && (resultArray = dialog.getResult()) != null && resultArray.length > 0) {
                return (IType)resultArray[0];
            }
        }
        catch (JavaModelException e) {
            JUnitPlugin.log(e);
        }
        return null;
    }

    protected IStatus packageChanged() {
        IStatus status = super.packageChanged();
        this.fClassToTestCompletionProcessor.setPackageFragment(this.getPackageFragment());
        return status;
    }

    protected IStatus classUnderTestChanged() {
        JUnitStatus status = new JUnitStatus();
        this.fClassUnderTest = null;
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return status;
        }
        String classToTestName = this.getClassUnderTestText();
        if (classToTestName.length() == 0) {
            return status;
        }
        IStatus val = JavaConventionsUtil.validateJavaTypeName((String)classToTestName, (IJavaElement)root);
        if (val.getSeverity() == 4) {
            status.setError(WizardMessages.NewTestCaseWizardPageOne_error_class_to_test_not_valid);
            return status;
        }
        IPackageFragment pack = this.getPackageFragment();
        try {
            IType type = this.resolveClassNameToType(root.getJavaProject(), pack, classToTestName);
            if (type == null) {
                status.setError(WizardMessages.NewTestCaseWizardPageOne_error_class_to_test_not_exist);
                return status;
            }
            if (type.isInterface()) {
                status.setWarning(Messages.format((String)WizardMessages.NewTestCaseWizardPageOne_warning_class_to_test_is_interface, (Object)BasicElementLabels.getJavaElementName((String)classToTestName)));
            }
            if (pack != null && !JUnitStubUtility.isVisible((IMember)type, pack)) {
                status.setWarning(Messages.format((String)WizardMessages.NewTestCaseWizardPageOne_warning_class_to_test_not_visible, (Object)BasicElementLabels.getJavaElementName((String)classToTestName)));
            }
            this.fClassUnderTest = type;
            this.fPage2.setClassUnderTest(this.fClassUnderTest);
        }
        catch (JavaModelException e) {
            status.setError(WizardMessages.NewTestCaseWizardPageOne_error_class_to_test_not_valid);
        }
        return status;
    }

    public String getClassUnderTestText() {
        return this.fClassUnderTestText;
    }

    public IType getClassUnderTest() {
        return this.fClassUnderTest;
    }

    public void setClassUnderTest(String name) {
        if (this.fClassUnderTestControl != null && !this.fClassUnderTestControl.isDisposed()) {
            this.fClassUnderTestControl.setText(name);
        }
        this.internalSetClassUnderText(name);
    }

    private void internalSetClassUnderText(String name) {
        this.fClassUnderTestText = name;
        this.fClassUnderTestStatus = this.classUnderTestChanged();
        this.handleFieldChanged(CLASS_UNDER_TEST);
    }

    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        if (this.fMethodStubsButtons.isSelected(4)) {
            this.createConstructor(type, imports);
        }
        if (this.fMethodStubsButtons.isSelected(0)) {
            this.createSetUpClass(type, imports);
        }
        if (this.fMethodStubsButtons.isSelected(1)) {
            this.createTearDownClass(type, imports);
        }
        if (this.fMethodStubsButtons.isSelected(2)) {
            this.createSetUp(type, imports);
        }
        if (this.fMethodStubsButtons.isSelected(3)) {
            this.createTearDown(type, imports);
        }
        if (this.fClassUnderTest != null || this.fJUnitVersion != JUnitVersion.VERSION_3) {
            this.createTestMethodStubs(type, imports);
        }
        if (this.fJUnitVersion == JUnitVersion.VERSION_4) {
            imports.addStaticImport("org.junit.Assert", "*", false);
        } else if (this.fJUnitVersion == JUnitVersion.VERSION_5) {
            imports.addStaticImport("org.junit.jupiter.api.Assertions", "*", false);
        }
    }

    private void createConstructor(IType type, NewTypeWizardPage.ImportsManager imports) throws CoreException {
        String content;
        ITypeHierarchy typeHierarchy = null;
        IType[] superTypes = null;
        IMethod methodTemplate = null;
        if (type.exists()) {
            typeHierarchy = type.newSupertypeHierarchy(null);
            IType[] iTypeArray = superTypes = typeHierarchy.getAllSuperclasses(type);
            int n = superTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod constrMethod;
                IType superType = iTypeArray[n2];
                if (superType.exists() && (constrMethod = superType.getMethod(superType.getElementName(), new String[]{"Ljava.lang.String;"})).exists() && constrMethod.isConstructor()) {
                    methodTemplate = constrMethod;
                    break;
                }
                ++n2;
            }
        }
        JUnitStubUtility.GenStubSettings settings = JUnitStubUtility.getCodeGenerationSettings(type.getJavaProject());
        settings.createComments = this.isAddComments();
        if (methodTemplate != null) {
            settings.callSuper = true;
            settings.methodOverwrites = true;
            content = JUnitStubUtility.genStub(type.getCompilationUnit(), this.getTypeName(), methodTemplate, settings, null, imports);
        } else {
            String delimiter = this.getLineDelimiter();
            StringBuilder buffer = new StringBuilder(32);
            buffer.append("public ");
            buffer.append(this.getTypeName());
            buffer.append('(');
            if (this.fJUnitVersion == JUnitVersion.VERSION_3) {
                buffer.append(imports.addImport("java.lang.String")).append(" name");
            }
            buffer.append(") {");
            buffer.append(delimiter);
            if (this.fJUnitVersion == JUnitVersion.VERSION_3) {
                buffer.append("super(name);").append(delimiter);
            }
            buffer.append('}');
            buffer.append(delimiter);
            content = buffer.toString();
        }
        type.createMethod(content, null, true, null);
    }

    private IMethod findInHierarchy(IType type, String methodName) throws JavaModelException {
        ITypeHierarchy typeHierarchy = null;
        IType[] superTypes = null;
        if (type.exists()) {
            typeHierarchy = type.newSupertypeHierarchy(null);
            IType[] iTypeArray = superTypes = typeHierarchy.getAllSuperclasses(type);
            int n = superTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod testMethod;
                IType superType = iTypeArray[n2];
                if (superType.exists() && (testMethod = superType.getMethod(methodName, new String[0])).exists()) {
                    return testMethod;
                }
                ++n2;
            }
        }
        return null;
    }

    private void createSetupStubs(IType type, String methodName, boolean isStatic, String annotationType, NewTypeWizardPage.ImportsManager imports) throws CoreException {
        String content = null;
        IMethod methodTemplate = this.findInHierarchy(type, methodName);
        String annotation = null;
        if (this.fJUnitVersion != JUnitVersion.VERSION_3) {
            annotation = "@" + imports.addImport(annotationType);
        }
        JUnitStubUtility.GenStubSettings settings = JUnitStubUtility.getCodeGenerationSettings(type.getJavaProject());
        settings.createComments = this.isAddComments();
        if (methodTemplate != null) {
            settings.callSuper = true;
            settings.methodOverwrites = true;
            content = JUnitStubUtility.genStub(type.getCompilationUnit(), this.getTypeName(), methodTemplate, settings, annotation, imports);
        } else {
            String delimiter = this.getLineDelimiter();
            StringBuilder buffer = new StringBuilder();
            if (settings.createComments) {
                String[] excSignature = new String[]{Signature.createTypeSignature((String)"java.lang.Exception", (boolean)true)};
                String comment = CodeGeneration.getMethodComment((ICompilationUnit)type.getCompilationUnit(), (String)type.getElementName(), (String)methodName, (String[])new String[0], (String[])excSignature, (String)"V", null, (String)delimiter);
                if (comment != null) {
                    buffer.append(comment);
                }
            }
            if (annotation != null) {
                buffer.append(annotation).append(delimiter);
            }
            if (this.fJUnitVersion == JUnitVersion.VERSION_4) {
                buffer.append("public ");
            } else if (this.fJUnitVersion == JUnitVersion.VERSION_3) {
                buffer.append("protected ");
            }
            if (isStatic) {
                buffer.append("static ");
            }
            buffer.append("void ");
            buffer.append(methodName);
            buffer.append("() throws ");
            buffer.append(imports.addImport("java.lang.Exception"));
            buffer.append(" {}");
            buffer.append(delimiter);
            content = buffer.toString();
        }
        type.createMethod(content, null, false, null);
    }

    private void createSetUp(IType type, NewTypeWizardPage.ImportsManager imports) throws CoreException {
        String annotationType = this.fJUnitVersion == JUnitVersion.VERSION_4 ? "org.junit.Before" : "org.junit.jupiter.api.BeforeEach";
        this.createSetupStubs(type, "setUp", false, annotationType, imports);
    }

    private void createTearDown(IType type, NewTypeWizardPage.ImportsManager imports) throws CoreException {
        String annotationType = this.fJUnitVersion == JUnitVersion.VERSION_4 ? "org.junit.After" : "org.junit.jupiter.api.AfterEach";
        this.createSetupStubs(type, "tearDown", false, annotationType, imports);
    }

    private void createSetUpClass(IType type, NewTypeWizardPage.ImportsManager imports) throws CoreException {
        String annotationType = this.fJUnitVersion == JUnitVersion.VERSION_4 ? "org.junit.BeforeClass" : "org.junit.jupiter.api.BeforeAll";
        this.createSetupStubs(type, "setUpBeforeClass", true, annotationType, imports);
    }

    private void createTearDownClass(IType type, NewTypeWizardPage.ImportsManager imports) throws CoreException {
        String annotationType = this.fJUnitVersion == JUnitVersion.VERSION_4 ? "org.junit.AfterClass" : "org.junit.jupiter.api.AfterAll";
        this.createSetupStubs(type, "tearDownAfterClass", true, annotationType, imports);
    }

    private void createTestMethodStubs(IType type, NewTypeWizardPage.ImportsManager imports) throws CoreException {
        IMethod[] methods = this.fPage2.getCheckedMethods();
        if (methods.length == 0) {
            if (this.fJUnitVersion != JUnitVersion.VERSION_3) {
                ArrayList<String> names = new ArrayList<String>();
                this.createTestMethod(type, imports, null, null, names);
            }
            return;
        }
        IMethod[] allMethodsArray = this.fPage2.getAllMethods();
        ArrayList<IMethod> allMethods = new ArrayList<IMethod>(Arrays.asList(allMethodsArray));
        List<IMethod> overloadedMethods = this.getOverloadedMethods(allMethods);
        ArrayList<String> names = new ArrayList<String>();
        IMethod[] iMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            this.createTestMethod(type, imports, method, overloadedMethods, names);
            ++n2;
        }
    }

    private void createTestMethod(IType type, NewTypeWizardPage.ImportsManager imports, IMethod method, List<IMethod> overloadedMethods, List<String> names) throws CoreException {
        StringBuffer name;
        StringBuffer buffer = new StringBuffer();
        if (method != null) {
            String elementName = method.getElementName();
            name = new StringBuffer(PREFIX).append(Character.toUpperCase(elementName.charAt(0))).append(elementName.substring(1));
            boolean contains = overloadedMethods.contains(method);
            if (contains) {
                this.appendParameterNamesToMethodName(name, method.getParameterTypes());
            }
        } else {
            name = new StringBuffer(PREFIX);
        }
        this.replaceIllegalCharacters(name);
        String testName = name.toString();
        if (names.contains(testName)) {
            int suffix = 1;
            while (names.contains(testName + Integer.toString(suffix))) {
                ++suffix;
            }
            name.append(Integer.toString(suffix));
        }
        testName = name.toString();
        names.add(testName);
        if (this.isAddComments() && method != null) {
            this.appendMethodComment(buffer, method);
        }
        if (this.fJUnitVersion == JUnitVersion.VERSION_4) {
            ISourceRange typeSourceRange = type.getSourceRange();
            int pos = typeSourceRange.getOffset() + typeSourceRange.getLength() - 1;
            buffer.append('@').append(imports.addImport("org.junit.Test", pos)).append(this.getLineDelimiter());
        } else if (this.fJUnitVersion == JUnitVersion.VERSION_5) {
            ISourceRange typeSourceRange = type.getSourceRange();
            int pos = typeSourceRange.getOffset() + typeSourceRange.getLength() - 1;
            buffer.append('@').append(imports.addImport("org.junit.jupiter.api.Test", pos)).append(this.getLineDelimiter());
        }
        if (this.fJUnitVersion != JUnitVersion.VERSION_5) {
            buffer.append("public ");
        }
        if (this.fPage2.getCreateFinalMethodStubsButtonSelection()) {
            buffer.append("final ");
        }
        buffer.append("void ");
        buffer.append(testName);
        buffer.append("()");
        this.appendTestMethodBody(buffer, type.getCompilationUnit());
        type.createMethod(buffer.toString(), null, false, null);
    }

    private void replaceIllegalCharacters(StringBuffer buffer) {
        char character = '\u0000';
        int index = buffer.length() - 1;
        while (index >= 0) {
            character = buffer.charAt(index);
            if (Character.isWhitespace(character)) {
                buffer.deleteCharAt(index);
            } else if (character == '<') {
                buffer.replace(index, index + 1, OF_TAG);
            } else if (character == '?') {
                buffer.replace(index, index + 1, QUESTION_MARK_TAG);
            } else if (!Character.isJavaIdentifierPart(character) && !Character.isSurrogate(character)) {
                buffer.deleteCharAt(index);
            }
            --index;
        }
    }

    private String getLineDelimiter() throws JavaModelException {
        IType classToTest = this.getClassUnderTest();
        if (classToTest != null && classToTest.exists() && classToTest.getCompilationUnit() != null) {
            return classToTest.getCompilationUnit().findRecommendedLineSeparator();
        }
        return this.getPackageFragment().findRecommendedLineSeparator();
    }

    private void appendTestMethodBody(StringBuffer buffer, ICompilationUnit targetCu) throws CoreException {
        String todoTaskTag;
        String delimiter = this.getLineDelimiter();
        buffer.append('{').append(delimiter);
        Object todoTask = "";
        if (this.fPage2.isCreateTasks() && (todoTaskTag = JUnitStubUtility.getTodoTaskTag(targetCu.getJavaProject())) != null) {
            todoTask = " // " + todoTaskTag;
        }
        String message = WizardMessages.NewTestCaseWizardPageOne_not_yet_implemented_string;
        buffer.append(Messages.format((String)"fail(\"{0}\");", (Object)message)).append((String)todoTask).append(delimiter);
        buffer.append('}').append(delimiter);
    }

    private void appendParameterNamesToMethodName(StringBuffer buffer, String[] parameters) {
        String[] stringArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String parameter = stringArray[n2];
            StringBuilder buf = new StringBuilder(Signature.getSimpleName((String)Signature.toString((String)Signature.getElementType((String)parameter))));
            char character = buf.charAt(0);
            if (buf.length() > 0 && !Character.isUpperCase(character)) {
                buf.setCharAt(0, Character.toUpperCase(character));
            }
            buffer.append(buf.toString());
            int j = 0;
            int arrayCount = Signature.getArrayCount((String)parameter);
            while (j < arrayCount) {
                buffer.append("Array");
                ++j;
            }
            ++n2;
        }
    }

    private void appendMethodComment(StringBuffer buffer, IMethod method) throws JavaModelException {
        String delimiter = this.getLineDelimiter();
        StringBuffer buf = new StringBuffer("{@link ");
        JavaElementLabels.getTypeLabel((IType)method.getDeclaringType(), (long)262144L, (StringBuffer)buf);
        buf.append('#');
        buf.append(method.getElementName());
        buf.append('(');
        String[] paramTypes = JUnitStubUtility.getParameterTypeNamesForSeeTag(method);
        int i = 0;
        while (i < paramTypes.length) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(paramTypes[i]);
            ++i;
        }
        buf.append(')');
        buf.append('}');
        buffer.append("/**");
        buffer.append(delimiter);
        buffer.append(" * ");
        buffer.append(Messages.format((String)WizardMessages.NewTestCaseWizardPageOne_comment_class_to_test, (Object)buf.toString()));
        buffer.append(delimiter);
        buffer.append(" */");
        buffer.append(delimiter);
    }

    private List<IMethod> getOverloadedMethods(List<IMethod> allMethods) {
        ArrayList<IMethod> overloadedMethods = new ArrayList<IMethod>();
        int i = 0;
        while (i < allMethods.size()) {
            IMethod current = allMethods.get(i);
            String currentName = current.getElementName();
            boolean currentAdded = false;
            ListIterator<IMethod> iter = allMethods.listIterator(i + 1);
            while (iter.hasNext()) {
                IMethod iterMethod = iter.next();
                if (!iterMethod.getElementName().equals(currentName)) continue;
                if (!currentAdded) {
                    overloadedMethods.add(current);
                    currentAdded = true;
                }
                overloadedMethods.add(iterMethod);
                iter.remove();
            }
            ++i;
        }
        return overloadedMethods;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.saveWidgetValues();
        }
    }

    protected IStatus validateIfJUnitProject() {
        JUnitStatus status = new JUnitStatus();
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root != null) {
            try {
                IJavaProject project = root.getJavaProject();
                if (project.exists()) {
                    boolean noMatch = false;
                    if (this.fJUnitVersion != null) {
                        switch (this.fJUnitVersion) {
                            case VERSION_5: {
                                if (!JUnitStubUtility.is18OrHigher(project)) {
                                    status.setError(WizardMessages.NewTestCaseWizardPageOne_error_java8required);
                                    return status;
                                }
                                if (project.findType("org.junit.platform.commons.annotation.Testable") != null) break;
                                status.setWarning(WizardMessages.NewTestCaseWizardPageOne__error_junit5NotOnbuildpath);
                                return status;
                            }
                            case VERSION_4: {
                                if (!JUnitStubUtility.is50OrHigher(project)) {
                                    status.setError(WizardMessages.NewTestCaseWizardPageOne_error_java5required);
                                    return status;
                                }
                                if (project.findType("org.junit.Test") != null) break;
                                status.setWarning(WizardMessages.NewTestCaseWizardPageOne__error_junit4NotOnbuildpath);
                                return status;
                            }
                            default: {
                                noMatch = true;
                            }
                        }
                        if (noMatch && project.findType("junit.framework.TestCase") == null) {
                            status.setWarning(WizardMessages.NewTestCaseWizardPageOne_error_junitNotOnbuildpath);
                            return status;
                        }
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return status;
    }

    protected IStatus superClassChanged() {
        boolean isJUnit3;
        IStatus stat = super.superClassChanged();
        if (stat.getSeverity() != 0) {
            return stat;
        }
        String superClassName = this.getSuperClass();
        JUnitStatus status = new JUnitStatus();
        boolean bl = isJUnit3 = this.fJUnitVersion == JUnitVersion.VERSION_3;
        if (superClassName == null || superClassName.trim().isEmpty()) {
            if (isJUnit3) {
                status.setError(WizardMessages.NewTestCaseWizardPageOne_error_superclass_empty);
            }
            return status;
        }
        if (!isJUnit3 && "java.lang.Object".equals(superClassName)) {
            return status;
        }
        if (this.getPackageFragmentRoot() != null) {
            try {
                IType type = this.resolveClassNameToType(this.getPackageFragmentRoot().getJavaProject(), this.getPackageFragment(), superClassName);
                if (type == null) {
                    status.setWarning(WizardMessages.NewTestCaseWizardPageOne_error_superclass_not_exist);
                    return status;
                }
                if (type.isInterface()) {
                    status.setError(WizardMessages.NewTestCaseWizardPageOne_error_superclass_is_interface);
                    return status;
                }
                if (isJUnit3 && !CoreTestSearchEngine.isTestImplementor((IType)type)) {
                    status.setError(Messages.format((String)WizardMessages.NewTestCaseWizardPageOne_error_superclass_not_implementing_test_interface, (Object)BasicElementLabels.getJavaElementName((String)"junit.framework.Test")));
                    return status;
                }
            }
            catch (JavaModelException e) {
                JUnitPlugin.log(e);
            }
        }
        return status;
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && this.getClassUnderTest() != null;
    }

    private IType resolveClassNameToType(IJavaProject jproject, IPackageFragment pack, String classToTestName) throws JavaModelException {
        if (!jproject.exists()) {
            return null;
        }
        IType type = jproject.findType(classToTestName);
        if (type == null && pack != null && !pack.isDefaultPackage()) {
            type = jproject.findType(pack.getElementName(), classToTestName);
        }
        if (type == null) {
            type = jproject.findType("java.lang", classToTestName);
        }
        return type;
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.fMethodStubsButtons.setSelection(2, settings.getBoolean(STORE_SETUP));
            this.fMethodStubsButtons.setSelection(3, settings.getBoolean(STORE_TEARDOWN));
            this.fMethodStubsButtons.setSelection(0, settings.getBoolean(STORE_SETUP_CLASS));
            this.fMethodStubsButtons.setSelection(1, settings.getBoolean(STORE_TEARDOWN_CLASS));
            this.fMethodStubsButtons.setSelection(4, settings.getBoolean(STORE_CONSTRUCTOR));
        } else {
            this.fMethodStubsButtons.setSelection(2, false);
            this.fMethodStubsButtons.setSelection(3, false);
            this.fMethodStubsButtons.setSelection(0, false);
            this.fMethodStubsButtons.setSelection(1, false);
            this.fMethodStubsButtons.setSelection(4, false);
        }
    }

    private void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_SETUP, this.fMethodStubsButtons.isSelected(2));
            settings.put(STORE_TEARDOWN, this.fMethodStubsButtons.isSelected(3));
            settings.put(STORE_SETUP_CLASS, this.fMethodStubsButtons.isSelected(0));
            settings.put(STORE_TEARDOWN_CLASS, this.fMethodStubsButtons.isSelected(1));
            settings.put(STORE_CONSTRUCTOR, this.fMethodStubsButtons.isSelected(4));
        }
    }

    protected String getJUnit3TestSuperclassName() {
        return "junit.framework.TestCase";
    }

    private String getDefaultSuperClassName() {
        return this.fJUnitVersion != JUnitVersion.VERSION_3 ? "java.lang.Object" : this.getJUnit3TestSuperclassName();
    }

    public int getModifiers() {
        int modifiers = super.getModifiers();
        if (this.fJUnitVersion == JUnitVersion.VERSION_5) {
            modifiers &= ~this.F_PUBLIC;
        }
        return modifiers;
    }

    public static enum JUnitVersion {
        VERSION_3(new String[]{WizardMessages.NewTestCaseWizardPageOne_methodStub_setUpBeforeClass, WizardMessages.NewTestCaseWizardPageOne_methodStub_tearDownAfterClass, WizardMessages.NewTestCaseWizardPageOne_methodStub_setUp, WizardMessages.NewTestCaseWizardPageOne_methodStub_tearDown, WizardMessages.NewTestCaseWizardPageOne_methodStub_constructor}),
        VERSION_4(new String[]{WizardMessages.NewJ4TestCaseWizardPageOne_methodStub_setUpBeforeClass, WizardMessages.NewJ4TestCaseWizardPageOne_methodStub_tearDownAfterClass, WizardMessages.NewJ4TestCaseWizardPageOne_methodStub_setUp, WizardMessages.NewJ4TestCaseWizardPageOne_methodStub_tearDown, WizardMessages.NewTestCaseWizardPageOne_methodStub_constructor}),
        VERSION_5(new String[]{WizardMessages.NewJ5TestCaseWizardPageOne_methodStub_setUpBeforeClass, WizardMessages.NewJ5TestCaseWizardPageOne_methodStub_tearDownAfterClass, WizardMessages.NewJ5TestCaseWizardPageOne_methodStub_setUp, WizardMessages.NewJ5TestCaseWizardPageOne_methodStub_tearDown, WizardMessages.NewTestCaseWizardPageOne_methodStub_constructor});

        public final String[] buttonNames;

        private JUnitVersion(String[] buttonNames) {
            this.buttonNames = buttonNames;
        }
    }
}

