/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ejb.ui.internal.quickfixes.ejb;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.ejb.ui.internal.quickfixes.ejb.Messages;
import org.eclipse.jst.ejb.ui.internal.wizard.AddMessageDrivenBeanWizard;
import org.eclipse.jst.ejb.ui.internal.wizard.AddSessionBeanWizard;
import org.eclipse.jst.ejb.ui.internal.wizard.NewEnterpriseBeanWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;

public class CreateBeanQuickFix
implements IMarkerResolution {
    private BEAN_TYPE beanType;
    private IProject project;

    public CreateBeanQuickFix(BEAN_TYPE bType, IProject proj) {
        this.beanType = bType;
        this.project = proj;
    }

    public String getLabel() {
        return this.beanType == BEAN_TYPE.SESSION ? Messages.CREATE_NEW_SESSION_BEAN : Messages.CREATE_NEW_MDB;
    }

    public void run(IMarker marker) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                CreateBeanQuickFix.this.openNewBeanWizard();
            }
        };
        Display.getDefault().asyncExec(r);
    }

    private void openNewBeanWizard() {
        NewEnterpriseBeanWizard wizard = this.beanType == BEAN_TYPE.SESSION ? new AddSessionBeanWizard() : new AddMessageDrivenBeanWizard();
        wizard.getDataModel().setStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME", this.project.getName());
        ((IWorkbenchWizard)wizard).init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)this.project));
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.open();
    }

    public static enum BEAN_TYPE {
        SESSION,
        MESSAGE_DRIVEN;

    }
}

