/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.tools.UpdateBuildpathWizardPage;
import org.eclipse.pde.internal.ui.wizards.tools.UpdateClasspathJob;
import org.eclipse.ui.PlatformUI;

public class UpdateBuildpathWizard
extends Wizard {
    private UpdateBuildpathWizardPage page1;
    private final IPluginModelBase[] fSelected;
    private final IPluginModelBase[] fUnupdated;
    private static final String STORE_SECTION = "UpdateBuildpathWizard";

    public UpdateBuildpathWizard(IPluginModelBase[] models, IPluginModelBase[] selected) {
        IDialogSettings masterSettings = PDEPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_CONVJPPRJ_WIZ);
        this.setWindowTitle(PDEUIMessages.UpdateBuildpathWizard_wtitle);
        this.setNeedsProgressMonitor(true);
        this.fSelected = selected;
        this.fUnupdated = models;
    }

    private IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    public boolean performFinish() {
        if (!PlatformUI.getWorkbench().saveAllEditors(true)) {
            return false;
        }
        Object[] finalSelected = this.page1.getSelected();
        this.page1.storeSettings();
        List<IPluginModelBase> modelArray = Arrays.stream(finalSelected).map(IPluginModelBase.class::cast).toList();
        UpdateClasspathJob.scheduleFor(modelArray, true);
        return true;
    }

    public void addPages() {
        this.page1 = new UpdateBuildpathWizardPage(this.fUnupdated, this.fSelected);
        this.addPage((IWizardPage)this.page1);
    }
}

