/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.PageEventAction;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;

public class CloseAllSavedAction
extends PageEventAction
implements IPropertyListener {
    private List<IWorkbenchPart> partsWithListeners = new ArrayList<IWorkbenchPart>(1);

    public CloseAllSavedAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.CloseAllSavedAction_text, window);
        this.setToolTipText(WorkbenchMessages.CloseAllSavedAction_toolTip);
        this.setId("closeAllSaved");
        this.updateState();
        window.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.close_all_saved_action_context");
        this.setActionDefinitionId("org.eclipse.ui.file.closeAllSaved");
    }

    @Override
    public void pageActivated(IWorkbenchPage page) {
        super.pageActivated(page);
        this.updateState();
    }

    @Override
    public void pageClosed(IWorkbenchPage page) {
        super.pageClosed(page);
        this.updateState();
    }

    @Override
    public void partClosed(IWorkbenchPart part) {
        super.partClosed(part);
        if (part instanceof IEditorPart) {
            part.removePropertyListener(this);
            this.partsWithListeners.remove(part);
            this.updateState();
        }
    }

    @Override
    public void partOpened(IWorkbenchPart part) {
        super.partOpened(part);
        if (part instanceof IEditorPart) {
            part.addPropertyListener(this);
            this.partsWithListeners.add(part);
            this.updateState();
        }
    }

    @Override
    public void propertyChanged(Object source, int propID) {
        if (source instanceof IEditorPart && propID == 257) {
            this.updateState();
        }
    }

    public void run() {
        if (this.getWorkbenchWindow() == null) {
            return;
        }
        IWorkbenchPage page = this.getActivePage();
        if (page != null) {
            ((WorkbenchPage)page).closeAllSavedEditors();
        }
    }

    private void updateState() {
        IEditorReference[] editors;
        IWorkbenchPage page = this.getActivePage();
        if (page == null) {
            this.setEnabled(false);
            return;
        }
        IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editor = iEditorReferenceArray[n2];
            if (!editor.isDirty()) {
                this.setEnabled(true);
                return;
            }
            ++n2;
        }
        this.setEnabled(false);
    }

    @Override
    public void dispose() {
        super.dispose();
        for (IWorkbenchPart part : this.partsWithListeners) {
            part.removePropertyListener(this);
        }
        this.partsWithListeners.clear();
    }
}

