/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.format;

import org.eclipse.wst.html.core.internal.format.HTMLFormatter;
import org.eclipse.wst.html.core.internal.format.SpaceConverter;
import org.eclipse.wst.html.core.internal.provisional.HTMLFormatContraints;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTMLTextFormatter
extends HTMLFormatter {
    public static int FORMAT_ALL = 0;
    public static int FORMAT_HEAD = 1;
    public static int FORMAT_TAIL = 2;
    private IStructuredDocumentRegion textRegion;

    protected HTMLTextFormatter() {
    }

    private boolean canFormatText(IDOMText text) {
        IDOMElement element;
        String type;
        if (text == null) {
            return false;
        }
        IStructuredDocumentRegion flatNode = text.getFirstStructuredDocumentRegion();
        if (flatNode != null && this.isUnparsedRegion(type = flatNode.getType())) {
            return false;
        }
        Node parent = text.getParentNode();
        if (parent != null && parent.getNodeType() == 1 && !(element = (IDOMElement)parent).isGlobalTag() && !text.isElementContentWhitespace()) {
            return false;
        }
        return this.canFormatChild(parent);
    }

    private boolean isUnparsedRegion(String type) {
        boolean result = this.isNestedScannedRegion(type) || this.isBlockScannedRegion(type);
        return result;
    }

    private boolean isBlockScannedRegion(String type) {
        return type == "BLOCK_TEXT";
    }

    private boolean isNestedScannedRegion(String type) {
        return type.equals("JSP_CONTENT");
    }

    private boolean canRemoveHeadingSpaces(IDOMNode node) {
        if (node == null) {
            return false;
        }
        if (node.getPreviousSibling() != null) {
            return false;
        }
        Node parent = node.getParentNode();
        if (parent == null || parent.getNodeType() != 1) {
            return false;
        }
        CMElementDeclaration decl = this.getElementDeclaration((Element)parent);
        if (decl == null || !decl.supports("lineBreakHint")) {
            return false;
        }
        String hint = (String)decl.getProperty("lineBreakHint");
        return hint.equals("breakBeforeStartAndAfterEnd");
    }

    private boolean canRemoveTailingSpaces(IDOMNode node) {
        if (node == null) {
            return false;
        }
        if (node.getNextSibling() != null) {
            return false;
        }
        Node parent = node.getParentNode();
        if (parent == null || parent.getNodeType() != 1) {
            return false;
        }
        CMElementDeclaration decl = this.getElementDeclaration((Element)parent);
        if (decl == null || !decl.supports("lineBreakHint")) {
            return false;
        }
        String hint = (String)decl.getProperty("lineBreakHint");
        return hint.equals("breakBeforeStartAndAfterEnd");
    }

    @Override
    protected void formatNode(IDOMNode node, HTMLFormatContraints contraints) {
        this.formatText(node, contraints, FORMAT_ALL);
    }

    protected void formatText(IDOMNode node, HTMLFormatContraints contraints, int mode) {
        SpaceConverter converter;
        int wordLength;
        if (node == null) {
            return;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return;
        }
        IDOMText text = (IDOMText)node;
        Object source = text.getSource();
        this.textRegion = text.getFirstStructuredDocumentRegion();
        if (!this.canFormatText(text)) {
            this.setWidth(contraints, (String)source);
            return;
        }
        int offset = text.getStartOffset();
        int length = text.getEndOffset() - offset;
        if (mode == FORMAT_HEAD) {
            Node next = node.getNextSibling();
            while (next != null && next.getNodeType() == 3) {
                IDOMText nextText = (IDOMText)next;
                length += nextText.getEndOffset() - nextText.getStartOffset();
                String nextSource = nextText.getSource();
                if (nextSource != null && nextSource.length() > 0) {
                    source = source == null ? nextSource : (String)source + nextSource;
                }
                next = next.getNextSibling();
            }
        } else if (mode == FORMAT_TAIL) {
            Node prev = node.getPreviousSibling();
            while (prev != null && prev.getNodeType() == 3) {
                IDOMText prevText = (IDOMText)prev;
                offset = prevText.getStartOffset();
                length += prevText.getEndOffset() - offset;
                String prevSource = prevText.getSource();
                if (prevSource != null && prevSource.length() > 0) {
                    source = source == null ? prevSource : prevSource + (String)source;
                }
                prev = prev.getPreviousSibling();
            }
        }
        if ((wordLength = this.getNextWord(converter = new SpaceConverter((String)source, this.keepBlankLines(contraints)), contraints, text)) == 0) {
            if (!converter.hasSpaces()) {
                return;
            }
            boolean removeSpaces = false;
            if (parent.getNodeType() == 1) {
                IDOMNode element = (IDOMNode)parent;
                if (node.getPreviousSibling() == null && element.getStartStructuredDocumentRegion() == null) {
                    removeSpaces = true;
                } else if (node.getNextSibling() == null && element.getEndStructuredDocumentRegion() == null) {
                    removeSpaces = true;
                }
            }
            if (removeSpaces) {
                converter.replaceSpaces(null);
            } else if (!this.isWidthAvailable(contraints, 2) || this.canInsertBreakAfter((Node)node) || this.canInsertBreakBefore((Node)node)) {
                String spaces = null;
                spaces = node.getNextSibling() == null ? this.getBreakSpaces(parent) : this.getBreakSpaces((Node)node);
                converter.replaceSpaces(spaces);
                this.setWidth(contraints, spaces);
            } else if (this.canRemoveHeadingSpaces(node) || this.canRemoveTailingSpaces(node)) {
                converter.replaceSpaces(null);
            } else {
                converter.compressSpaces();
                this.addWidth(contraints, 1);
            }
        } else {
            String breakSpaces = null;
            boolean hasSpaces = converter.hasSpaces();
            if (mode == FORMAT_TAIL) {
                this.addWidth(contraints, converter.getSpaceCount());
            } else if (hasSpaces && !this.isWidthAvailable(contraints, wordLength + 1) || this.canInsertBreakBefore((Node)node)) {
                breakSpaces = this.getBreakSpaces((Node)node);
                converter.replaceSpaces(breakSpaces);
                this.setWidth(contraints, breakSpaces);
            } else if (hasSpaces) {
                if (this.canRemoveHeadingSpaces(node)) {
                    converter.replaceSpaces(null);
                } else {
                    converter.compressSpaces();
                    this.addWidth(contraints, 1);
                }
            }
            this.addWidth(contraints, wordLength);
            wordLength = this.getNextWord(converter, contraints, text);
            while (wordLength > 0) {
                if (mode != FORMAT_ALL) {
                    this.addWidth(contraints, converter.getSpaceCount());
                } else if (!this.isWidthAvailable(contraints, wordLength + 1)) {
                    if (breakSpaces == null) {
                        breakSpaces = this.getBreakSpaces((Node)node);
                    }
                    converter.replaceSpaces(breakSpaces);
                    this.setWidth(contraints, breakSpaces);
                } else {
                    converter.compressSpaces();
                    this.addWidth(contraints, 1);
                }
                this.addWidth(contraints, wordLength);
                wordLength = this.getNextWord(converter, contraints, text);
            }
            hasSpaces = converter.hasSpaces();
            if (mode == FORMAT_HEAD) {
                this.addWidth(contraints, converter.getSpaceCount());
            } else if (hasSpaces && !this.isWidthAvailable(contraints, 2) || this.canInsertBreakAfter((Node)node)) {
                if (node.getNextSibling() == null) {
                    breakSpaces = this.getBreakSpaces(parent);
                } else if (breakSpaces == null) {
                    breakSpaces = this.getBreakSpaces((Node)node);
                }
                converter.replaceSpaces(breakSpaces);
                this.setWidth(contraints, breakSpaces);
            } else if (hasSpaces) {
                if (this.canRemoveTailingSpaces(node)) {
                    converter.replaceSpaces(null);
                } else {
                    converter.compressSpaces();
                    this.addWidth(contraints, 1);
                }
            }
        }
        if (converter.isModified()) {
            source = converter.getSource();
            this.replaceSource(text.getModel(), offset, length, (String)source);
        }
    }

    private int getNextWord(SpaceConverter converter, HTMLFormatContraints contraints, IDOMText text) {
        int wordLength = converter.nextWord();
        while (this.isWordInComplexRegion(converter, text)) {
            this.addWidth(contraints, wordLength + converter.getSpaceCount());
            if (!converter.hasMoreWords()) {
                return converter.nextWord();
            }
            wordLength = converter.nextWord();
        }
        return wordLength;
    }

    private boolean isWordInComplexRegion(SpaceConverter converter, IDOMText text) {
        if (this.textRegion == null) {
            return false;
        }
        int offset = text.getFirstStructuredDocumentRegion().getStartOffset();
        while (this.textRegion != null && converter.getWordOffset() + offset >= this.textRegion.getEnd() && this.textRegion != text.getLastStructuredDocumentRegion()) {
            this.textRegion = this.textRegion.getNext();
        }
        return this.textRegion != null && this.textRegion.getFirstRegion() instanceof ITextRegionContainer && ((ITextRegionContainer)this.textRegion.getFirstRegion()).getRegions() != null;
    }
}

