/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.docx.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.docx.writer.BasicComponent;
import org.eclipse.birt.report.engine.emitter.docx.writer.Document;
import org.eclipse.birt.report.engine.emitter.docx.writer.Header;
import org.eclipse.birt.report.engine.emitter.wpml.AbstractEmitterImpl;
import org.eclipse.birt.report.engine.emitter.wpml.DiagonalLineInfo;
import org.eclipse.birt.report.engine.emitter.wpml.HyperlinkInfo;
import org.eclipse.birt.report.engine.emitter.wpml.IWordWriter;
import org.eclipse.birt.report.engine.emitter.wpml.SpanInfo;
import org.eclipse.birt.report.engine.ooxml.IPart;
import org.eclipse.birt.report.engine.ooxml.ImageManager;
import org.eclipse.birt.report.engine.ooxml.Package;
import org.eclipse.birt.report.engine.ooxml.writer.OOXmlWriter;

public class DocxWriter
implements IWordWriter {
    private Package pkg;
    private Document document;
    private BasicComponent currentComponent;
    private boolean rtl = false;
    private boolean showHeaderOnFirst;
    private int wordVersion;
    private String documentLanguage = "en";

    public DocxWriter(OutputStream out, String tempFileDir, int compressionMode, int wordVersion) {
        this.pkg = Package.createInstance((OutputStream)out, (String)tempFileDir, (int)compressionMode);
        this.pkg.setExtensionData((Object)new ImageManager());
        this.wordVersion = wordVersion;
    }

    public void start(boolean rtl, String creator, String title, String description, String subject) throws IOException {
        this.rtl = rtl;
        this.writeCorePart(creator, title, description, subject);
    }

    public void drawDocumentBackground(String backgroundColor, String backgroundImageUrl, String backgroundHeight, String backgroundWidth) throws IOException {
        this.initializeDocumentPart(backgroundColor, backgroundImageUrl, backgroundHeight, backgroundWidth);
    }

    public void end() throws IOException {
        this.document.end();
        this.pkg.close();
    }

    private void writeCorePart(String creator, String title, String description, String subject) throws IOException {
        String uri = "docProps/core.xml";
        String type = "application/vnd.openxmlformats-package.core-properties+xml";
        String relationshipType = "http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties";
        IPart corePart = this.pkg.getPart(uri, type, relationshipType);
        try (OOXmlWriter corePartWriter = null;){
            corePartWriter = corePart.getWriter();
            corePartWriter.startWriter();
            corePartWriter.openTag("cp:coreProperties");
            corePartWriter.nameSpace("cp", "http://schemas.openxmlformats.org/package/2006/metadata/core-properties");
            corePartWriter.nameSpace("dc", "http://purl.org/dc/elements/1.1/");
            corePartWriter.openTag("dc:creator");
            corePartWriter.text(creator);
            corePartWriter.closeTag("dc:creator");
            corePartWriter.openTag("dc:title ");
            corePartWriter.text(title);
            corePartWriter.closeTag("dc:title");
            corePartWriter.openTag("dc:description");
            corePartWriter.text(description);
            corePartWriter.closeTag("dc:description");
            corePartWriter.openTag("dc:subject");
            corePartWriter.text(subject);
            corePartWriter.closeTag("dc:subject");
            corePartWriter.closeTag("cp:coreProperties");
            corePartWriter.endWriter();
        }
    }

    private void initializeDocumentPart(String backgroundColor, String backgroundImageUrl, String backgroundHeight, String backgroundWidth) throws IOException {
        String uri = "word/document.xml";
        String type = "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml";
        String relationshipType = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument";
        IPart documentPart = this.pkg.getPart(uri, type, relationshipType);
        this.document = new Document(documentPart, backgroundColor, backgroundImageUrl, backgroundHeight, backgroundWidth, this.rtl, this.wordVersion, this.getDocumentLanguage());
        this.document.start();
        this.currentComponent = this.document;
    }

    public void startSectionInParagraph() {
        this.document.startSectionInParagraph();
    }

    public void endSectionInParagraph() {
        this.document.endSectionInParagraph();
    }

    public void startSection() {
        this.document.startSection();
    }

    public void endSection() {
        this.document.endSection();
    }

    public void startHeader(boolean showHeaderOnFirst, int headerHeight, int headerWidth) throws IOException {
        this.currentComponent = this.document.createHeader(headerHeight, headerWidth);
        this.currentComponent.start();
        this.showHeaderOnFirst = showHeaderOnFirst;
    }

    public void endHeader() {
        this.currentComponent.end();
        this.document.writeHeaderReference(this.currentComponent, this.showHeaderOnFirst);
        this.currentComponent = this.document;
    }

    public void startFooter(int footerHeight, int footerWidth) throws IOException {
        this.currentComponent = this.document.createFooter(footerHeight, footerWidth);
        this.currentComponent.start();
    }

    public void endFooter() {
        this.currentComponent.end();
        this.document.writeFooterReference(this.currentComponent);
        this.currentComponent = this.document;
    }

    public void drawImage(byte[] data, double height, double width, HyperlinkInfo hyper, IStyle style, AbstractEmitterImpl.InlineFlag inlineFlag, String altText, String uri) {
        this.currentComponent.drawImage(data, height, width, hyper, style, inlineFlag, altText, uri);
    }

    public void writePageProperties(int pageHeight, int pageWidth, int headerHeight, int footerHeight, int topMargin, int bottomMargin, int leftMargin, int rightMargin, String orient) {
        this.document.writePageProperties(pageHeight, pageWidth, headerHeight, footerHeight, topMargin, bottomMargin, leftMargin, rightMargin, orient);
    }

    public void startTable(IStyle style, int tableWidth) {
        this.currentComponent.startTable(style, tableWidth, false);
    }

    public void startTable(IStyle style, int tableWidth, boolean inForeign) {
        this.currentComponent.startTable(style, tableWidth, inForeign);
    }

    public void endTable() {
        this.currentComponent.endTable();
    }

    public void writeColumn(int[] cols) {
        this.currentComponent.writeColumn(cols);
    }

    public void startTableRow(double height, boolean isHeader, boolean repeatHeader, boolean fixedLayout) {
        this.currentComponent.startTableRow(height, isHeader, repeatHeader, fixedLayout);
    }

    public void startTableRow(double height) {
        this.currentComponent.startTableRow(height, false, false, false);
    }

    public void endTableRow() {
        this.currentComponent.endTableRow();
    }

    public void startTableCell(int width, IStyle style, SpanInfo info, DiagonalLineInfo diagonalLineInfo) {
        this.currentComponent.startTableCell(width, style, info, diagonalLineInfo);
    }

    public void endTableCell(boolean needEmptyP) {
        this.currentComponent.endTableCell(needEmptyP);
    }

    public void endTableCell(boolean needEmptyp, boolean inForeign) {
        this.currentComponent.endTableCell(needEmptyp, inForeign);
    }

    public void writeSpanCell(SpanInfo info) {
        this.currentComponent.writeSpanCell(info);
    }

    public void writeEmptyCell() {
        this.currentComponent.writeEmptyCell();
    }

    public void writeContent(int type, String txt, IStyle style, IStyle inlineStyle, String fontFamily, HyperlinkInfo info, AbstractEmitterImpl.InlineFlag inlineFlag, AbstractEmitterImpl.TextFlag textFlag, int pargraphWidth, boolean runIsRtl, String textAlign) {
        if (inlineFlag == AbstractEmitterImpl.InlineFlag.BLOCK) {
            this.currentComponent.writeText(type, txt, style, fontFamily, info, textFlag, pargraphWidth, runIsRtl);
        } else {
            boolean isInline = true;
            if (inlineFlag == AbstractEmitterImpl.InlineFlag.FIRST_INLINE && textFlag == AbstractEmitterImpl.TextFlag.START) {
                this.currentComponent.startParagraph(style, isInline, pargraphWidth, textAlign);
            }
            this.currentComponent.writeTextInRun(type, txt, style, fontFamily, info, isInline, pargraphWidth, runIsRtl, textAlign);
        }
    }

    public void writeTOC(String toc, int tocLevel) {
        this.currentComponent.writeTOC(toc, tocLevel);
    }

    public void writeTOC(String toc, String color, int tocLevel, boolean middleInline) {
        this.currentComponent.writeTOC(toc, color, tocLevel, middleInline);
    }

    public void insertHiddenParagraph() {
        this.currentComponent.insertHiddenParagraph();
    }

    public void insertEmptyParagraph() {
        this.currentComponent.insertEmptyParagraph();
    }

    public void endParagraph() {
        this.currentComponent.endParagraph();
    }

    public void writeCaption(String txt) {
        this.currentComponent.writeCaption(txt);
    }

    public void writeBookmark(String bm) {
        this.currentComponent.writeBookmark(bm);
    }

    public void writeForeign(IForeignContent foreignContent) {
        this.currentComponent.writeForeign(foreignContent);
    }

    public void endPage() {
    }

    public void startPage() {
    }

    public void writePageBorders(IStyle style, int topMargin, int bottomMargin, int leftMargin, int rightMargin) {
        this.document.writePageBorders(style, topMargin, bottomMargin, leftMargin, rightMargin);
    }

    public void drawDiagonalLine(DiagonalLineInfo diagonalLineInfo) {
        this.document.drawDiagonalLine(diagonalLineInfo);
    }

    public void drawDocumentBackgroundImage(String backgroundImageUrl, String backgroundHeight, String backgroundWidth, double topMargin, double leftMargin, double pageHeight, double pageWidth) throws IOException {
        ((Header)this.currentComponent).drawDocumentBackgroundImageWithSize(backgroundImageUrl, backgroundHeight, backgroundWidth, topMargin, leftMargin, pageHeight, pageWidth);
    }

    public void setDocumentLanguage(String language) {
        Locale[] locales;
        Locale[] localeArray = locales = Locale.getAvailableLocales();
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            if (language.equalsIgnoreCase(locale.toLanguageTag())) {
                this.documentLanguage = language;
                break;
            }
            ++n2;
        }
    }

    public String getDocumentLanguage() {
        return this.documentLanguage;
    }
}

