/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.border;

import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class BorderUtil {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int DIAGONAL = 4;
    public static final int ANTIDIAGONAL = 5;
    private static final int[] DEFAULT_LINE_WIDTH = new int[]{1, 1, 1, 1};

    private static int getGap(int x, int y, int i) {
        if (x == 0) {
            return 0;
        }
        if (i < 0) {
            i = 0;
        }
        if (i > x) {
            i = x;
        }
        return y * i / x;
    }

    public static void drawDoubleLine(Graphics g, int side, int[] width, Rectangle r) {
        int blankWidth = width[side] / 3;
        int lineWidth = blankWidth++;
        if (width[side] % 3 != 1 && width[side] % 3 == 2) {
            ++lineWidth;
        }
        if (lineWidth == 0 && width[side] != 0) {
            BorderUtil.drawSingleLine(g, side, 1, width, 1, 0, r);
            return;
        }
        BorderUtil.drawSingleLine(g, side, 1, width, lineWidth, 0, r);
        BorderUtil.drawSingleLine(g, side, 1, width, lineWidth, lineWidth + blankWidth, r);
    }

    public static void drawDefaultLine(Graphics g, int side, Rectangle r) {
        BorderUtil.drawSingleLine(g, side, 1, DEFAULT_LINE_WIDTH, r);
    }

    public static void drawSingleLine(Graphics g, int side, int style, int[] width, Rectangle r) {
        BorderUtil.drawSingleLine(g, side, style, width, -1, 0, r);
    }

    private static void drawSingleLine(Graphics g, int side, int style, int[] width, int actualWidth, int startPos, Rectangle r) {
        if ((side == 4 || side == 5) && style < 0) {
            style = 1;
        }
        g.setLineStyle(style);
        Rectangle oldClip = g.getClip(new Rectangle());
        Rectangle clip = new Rectangle();
        Point p2 = new Point();
        switch (side) {
            case 1: {
                if (actualWidth < 0) {
                    actualWidth = width[side];
                }
                int i = 0;
                while (i < actualWidth) {
                    clip.width = 0;
                    clip.height = 0;
                    clip.x = r.x + BorderUtil.getGap(width[1], width[2], i + startPos);
                    clip.y = r.y + r.height - i - startPos - 1;
                    p2.x = r.x + r.width - BorderUtil.getGap(width[1], width[3], i + startPos) - 1;
                    p2.y = r.y + r.height - i - startPos - 1;
                    clip.union(p2);
                    g.clipRect(clip);
                    g.drawLine(r.x, r.y + r.height - i - startPos - 1, r.x + r.width, r.y + r.height - i - startPos - 1);
                    g.setClip(oldClip);
                    ++i;
                }
                break;
            }
            case 0: {
                if (actualWidth < 0) {
                    actualWidth = width[side];
                }
                int i = 0;
                while (i < actualWidth) {
                    clip.width = 0;
                    clip.height = 0;
                    clip.x = r.x + BorderUtil.getGap(width[0], width[2], i + startPos);
                    clip.y = r.y + i + startPos;
                    p2.x = r.x + r.width - BorderUtil.getGap(width[0], width[3], i + startPos) - 1;
                    p2.y = r.y + i + startPos;
                    clip.union(p2);
                    g.clipRect(clip);
                    g.drawLine(r.x, r.y + i + startPos, r.x + r.width, r.y + i + startPos);
                    g.setClip(oldClip);
                    ++i;
                }
                break;
            }
            case 2: {
                if (actualWidth < 0) {
                    actualWidth = width[side];
                }
                int i = 0;
                while (i < actualWidth) {
                    clip.width = 0;
                    clip.height = 0;
                    clip.x = r.x + i + startPos;
                    clip.y = r.y + BorderUtil.getGap(width[2], width[0], i + startPos);
                    p2.x = r.x + i + startPos;
                    p2.y = r.y + r.height - BorderUtil.getGap(width[2], width[1], i + startPos) - 1;
                    clip.union(p2);
                    g.clipRect(clip);
                    g.drawLine(r.x + i + startPos, r.y, r.x + i + startPos, r.y + r.height);
                    g.setClip(oldClip);
                    ++i;
                }
                break;
            }
            case 3: {
                if (actualWidth < 0) {
                    actualWidth = width[side];
                }
                int i = 0;
                while (i < actualWidth) {
                    clip.width = 0;
                    clip.height = 0;
                    clip.x = r.x + r.width - i - startPos - 1;
                    clip.y = r.y + BorderUtil.getGap(width[3], width[0], i + startPos);
                    p2.x = r.x + r.width - i - startPos - 1;
                    p2.y = r.y + r.height - BorderUtil.getGap(width[3], width[1], i + startPos) - 1;
                    clip.union(p2);
                    g.clipRect(clip);
                    g.drawLine(r.x + r.width - i - startPos - 1, r.y, r.x + r.width - i - startPos - 1, r.y + r.height);
                    g.setClip(oldClip);
                    ++i;
                }
                break;
            }
            case 4: {
                if (actualWidth < 0) {
                    actualWidth = width[0];
                }
                g.setLineWidth(actualWidth);
                clip.width = 0;
                clip.height = 0;
                clip.x = r.x - 10 + 10;
                clip.y = r.y;
                p2.x = r.x + r.width + 20 - 20;
                p2.y = r.y + r.height;
                if (actualWidth >= 6) {
                    p2.x -= 2;
                    p2.y -= 2;
                }
                clip.union(p2);
                g.clipRect(clip);
                int dP1x = clip.x;
                int dP1y = clip.y;
                int dP2x = p2.x;
                int dP2y = p2.y;
                dP2y = actualWidth >= 6 ? ++dP2y : (dP2y -= 2);
                g.drawLine(dP1x += 0, ++dP1y, dP2x -= 2, dP2y);
                g.setClip(oldClip);
                break;
            }
            case 5: {
                if (actualWidth < 0) {
                    actualWidth = width[0];
                }
                g.setLineWidth(actualWidth);
                clip.width = 0;
                clip.height = 0;
                clip.x = r.x;
                clip.y = r.y;
                p2.x = r.x + r.width;
                p2.y = r.y + r.height;
                if (actualWidth >= 6) {
                    p2.x -= 2;
                    p2.y += 2;
                } else {
                    p2.y += 3;
                }
                clip.union(p2);
                g.clipRect(clip);
                int adP1x = r.x;
                int adP1y = r.y + r.height;
                int adP2x = p2.x;
                int adP2y = p2.y - r.height;
                g.drawLine(adP1x += 0, adP1y -= 2, adP2x += 0, adP2y -= 2);
                g.setClip(oldClip);
            }
        }
        g.setClip(oldClip);
    }

    public static void draw3DLine(Graphics g, int side, int style, int[] width, Rectangle r) {
        Color foreColor;
        if (width.length <= side || width[side] <= 0) {
            return;
        }
        Color inSideColor = foreColor = g.getForegroundColor();
        Color outSideColor = foreColor;
        Color darkColor = ColorManager.darker((Color)foreColor);
        Color brightColor = ColorManager.brighter((Color)foreColor, (Color)ColorConstants.white);
        switch (style) {
            case -3: {
                if (side == 0 || side == 2) {
                    inSideColor = darkColor;
                    outSideColor = brightColor;
                    break;
                }
                if (side != 1 && side != 3) break;
                inSideColor = brightColor;
                outSideColor = darkColor;
                break;
            }
            case -4: {
                if (side == 0 || side == 2) {
                    inSideColor = brightColor;
                    outSideColor = darkColor;
                    break;
                }
                if (side != 1 && side != 3) break;
                inSideColor = darkColor;
                outSideColor = brightColor;
                break;
            }
            case -5: {
                if (side == 0 || side == 2) {
                    inSideColor = darkColor;
                    outSideColor = darkColor;
                    break;
                }
                if (side != 1 && side != 3) break;
                inSideColor = brightColor;
                outSideColor = brightColor;
                break;
            }
            case -6: {
                if (side == 0 || side == 2) {
                    inSideColor = brightColor;
                    outSideColor = brightColor;
                    break;
                }
                if (side != 1 && side != 3) break;
                inSideColor = darkColor;
                outSideColor = darkColor;
            }
        }
        int inSideWidth = (width[side] + 1) / 2;
        int outSideWidth = width[side] - inSideWidth;
        g.setForegroundColor(outSideColor);
        BorderUtil.drawSingleLine(g, side, 1, width, outSideWidth, 0, r);
        g.setForegroundColor(inSideColor);
        BorderUtil.drawSingleLine(g, side, 1, width, inSideWidth, outSideWidth, r);
    }

    public static void drawBorderLine(Graphics g, int side, int style, int[] width, Rectangle r) {
        switch (style) {
            case -2: {
                BorderUtil.drawDoubleLine(g, side, width, r);
                break;
            }
            case -6: 
            case -5: 
            case -4: 
            case -3: {
                BorderUtil.draw3DLine(g, side, style, width, r);
                break;
            }
            default: {
                BorderUtil.drawSingleLine(g, side, style, width, r);
            }
        }
    }
}

