/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;

public abstract class LogMergePolicy
extends MergePolicy {
    public static final double LEVEL_LOG_SPAN = 0.75;
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.MAX_VALUE;
    public static final double DEFAULT_NO_CFS_RATIO = 0.1;
    protected int mergeFactor = 10;
    protected long minMergeSize;
    protected long maxMergeSize;
    protected long maxMergeSizeForForcedMerge = Long.MAX_VALUE;
    protected int maxMergeDocs = Integer.MAX_VALUE;
    protected boolean calibrateSizeByDeletes = true;

    public LogMergePolicy() {
        super(0.1, Long.MAX_VALUE);
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setMergeFactor(int mergeFactor) {
        if (mergeFactor < 2) {
            throw new IllegalArgumentException("mergeFactor cannot be less than 2");
        }
        this.mergeFactor = mergeFactor;
    }

    public void setCalibrateSizeByDeletes(boolean calibrateSizeByDeletes) {
        this.calibrateSizeByDeletes = calibrateSizeByDeletes;
    }

    public boolean getCalibrateSizeByDeletes() {
        return this.calibrateSizeByDeletes;
    }

    protected long sizeDocs(SegmentCommitInfo info, MergePolicy.MergeContext mergeContext) throws IOException {
        if (this.calibrateSizeByDeletes) {
            int delCount = mergeContext.numDeletesToMerge(info);
            assert (this.assertDelCount(delCount, info));
            return (long)info.info.maxDoc() - (long)delCount;
        }
        return info.info.maxDoc();
    }

    protected long sizeBytes(SegmentCommitInfo info, MergePolicy.MergeContext mergeContext) throws IOException {
        if (this.calibrateSizeByDeletes) {
            return super.size(info, mergeContext);
        }
        return info.sizeInBytes();
    }

    protected boolean isMerged(SegmentInfos infos, int maxNumSegments, Map<SegmentCommitInfo, Boolean> segmentsToMerge, MergePolicy.MergeContext mergeContext) throws IOException {
        int numSegments = infos.size();
        int numToMerge = 0;
        SegmentCommitInfo mergeInfo = null;
        boolean segmentIsOriginal = false;
        for (int i = 0; i < numSegments && numToMerge <= maxNumSegments; ++i) {
            SegmentCommitInfo info = infos.info(i);
            Boolean isOriginal = segmentsToMerge.get(info);
            if (isOriginal == null) continue;
            segmentIsOriginal = isOriginal;
            ++numToMerge;
            mergeInfo = info;
        }
        return numToMerge <= maxNumSegments && (numToMerge != 1 || !segmentIsOriginal || this.isMerged(infos, mergeInfo, mergeContext));
    }

    @Override
    protected long maxFullFlushMergeSize() {
        return this.minMergeSize;
    }

    private MergePolicy.MergeSpecification findForcedMergesSizeLimit(SegmentInfos infos, int last, MergePolicy.MergeContext mergeContext) throws IOException {
        int start;
        MergePolicy.MergeSpecification spec = new MergePolicy.MergeSpecification();
        List<SegmentCommitInfo> segments = infos.asList();
        for (start = last - 1; start >= 0; --start) {
            SegmentCommitInfo info = infos.info(start);
            if (this.size(info, mergeContext) > this.maxMergeSizeForForcedMerge || this.sizeDocs(info, mergeContext) > (long)this.maxMergeDocs) {
                if (this.verbose(mergeContext)) {
                    this.message("findForcedMergesSizeLimit: skip segment=" + info + ": size is > maxMergeSize (" + this.maxMergeSizeForForcedMerge + ") or sizeDocs is > maxMergeDocs (" + this.maxMergeDocs + ")", mergeContext);
                }
                if (last - start - 1 > 1 || start != last - 1 && !this.isMerged(infos, infos.info(start + 1), mergeContext)) {
                    spec.add(new MergePolicy.OneMerge(segments.subList(start + 1, last)));
                }
                last = start;
                continue;
            }
            if (last - start != this.mergeFactor) continue;
            spec.add(new MergePolicy.OneMerge(segments.subList(start, last)));
            last = start;
        }
        if (!(last <= 0 || ++start + 1 >= last && this.isMerged(infos, infos.info(start), mergeContext))) {
            spec.add(new MergePolicy.OneMerge(segments.subList(start, last)));
        }
        return spec.merges.size() == 0 ? null : spec;
    }

    private MergePolicy.MergeSpecification findForcedMergesMaxNumSegments(SegmentInfos infos, int maxNumSegments, int last, MergePolicy.MergeContext mergeContext) throws IOException {
        MergePolicy.MergeSpecification spec = new MergePolicy.MergeSpecification();
        List<SegmentCommitInfo> segments = infos.asList();
        while (last - maxNumSegments + 1 >= this.mergeFactor) {
            spec.add(new MergePolicy.OneMerge(segments.subList(last - this.mergeFactor, last)));
            last -= this.mergeFactor;
        }
        if (0 == spec.merges.size()) {
            if (maxNumSegments == 1) {
                if (last > 1 || !this.isMerged(infos, infos.info(0), mergeContext)) {
                    spec.add(new MergePolicy.OneMerge(segments.subList(0, last)));
                }
            } else if (last > maxNumSegments) {
                int finalMergeSize = last - maxNumSegments + 1;
                long bestSize = 0L;
                int bestStart = 0;
                for (int i = 0; i < last - finalMergeSize + 1; ++i) {
                    long sumSize = 0L;
                    for (int j = 0; j < finalMergeSize; ++j) {
                        sumSize += this.size(infos.info(j + i), mergeContext);
                    }
                    if (i != 0 && (sumSize >= 2L * this.size(infos.info(i - 1), mergeContext) || sumSize >= bestSize)) continue;
                    bestStart = i;
                    bestSize = sumSize;
                }
                spec.add(new MergePolicy.OneMerge(segments.subList(bestStart, bestStart + finalMergeSize)));
            }
        }
        return spec.merges.size() == 0 ? null : spec;
    }

    @Override
    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos infos, int maxNumSegments, Map<SegmentCommitInfo, Boolean> segmentsToMerge, MergePolicy.MergeContext mergeContext) throws IOException {
        assert (maxNumSegments > 0);
        if (this.verbose(mergeContext)) {
            this.message("findForcedMerges: maxNumSegs=" + maxNumSegments + " segsToMerge=" + segmentsToMerge, mergeContext);
        }
        if (this.isMerged(infos, maxNumSegments, segmentsToMerge, mergeContext)) {
            if (this.verbose(mergeContext)) {
                this.message("already merged; skip", mergeContext);
            }
            return null;
        }
        int last = infos.size();
        while (last > 0) {
            SegmentCommitInfo info;
            if (segmentsToMerge.get(info = infos.info(--last)) == null) continue;
            ++last;
            break;
        }
        if (last == 0) {
            if (this.verbose(mergeContext)) {
                this.message("last == 0; skip", mergeContext);
            }
            return null;
        }
        if (maxNumSegments == 1 && last == 1 && this.isMerged(infos, infos.info(0), mergeContext)) {
            if (this.verbose(mergeContext)) {
                this.message("already 1 seg; skip", mergeContext);
            }
            return null;
        }
        boolean anyTooLarge = false;
        for (int i = 0; i < last; ++i) {
            SegmentCommitInfo info = infos.info(i);
            if (this.size(info, mergeContext) <= this.maxMergeSizeForForcedMerge && this.sizeDocs(info, mergeContext) <= (long)this.maxMergeDocs) continue;
            anyTooLarge = true;
            break;
        }
        if (anyTooLarge) {
            return this.findForcedMergesSizeLimit(infos, last, mergeContext);
        }
        return this.findForcedMergesMaxNumSegments(infos, maxNumSegments, last, mergeContext);
    }

    @Override
    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos, MergePolicy.MergeContext mergeContext) throws IOException {
        List<SegmentCommitInfo> segments = segmentInfos.asList();
        int numSegments = segments.size();
        if (this.verbose(mergeContext)) {
            this.message("findForcedDeleteMerges: " + numSegments + " segments", mergeContext);
        }
        MergePolicy.MergeSpecification spec = new MergePolicy.MergeSpecification();
        int firstSegmentWithDeletions = -1;
        assert (mergeContext != null);
        for (int i = 0; i < numSegments; ++i) {
            SegmentCommitInfo info = segmentInfos.info(i);
            int delCount = mergeContext.numDeletesToMerge(info);
            assert (this.assertDelCount(delCount, info));
            if (delCount > 0) {
                if (this.verbose(mergeContext)) {
                    this.message("  segment " + info.info.name + " has deletions", mergeContext);
                }
                if (firstSegmentWithDeletions == -1) {
                    firstSegmentWithDeletions = i;
                    continue;
                }
                if (i - firstSegmentWithDeletions != this.mergeFactor) continue;
                if (this.verbose(mergeContext)) {
                    this.message("  add merge " + firstSegmentWithDeletions + " to " + (i - 1) + " inclusive", mergeContext);
                }
                spec.add(new MergePolicy.OneMerge(segments.subList(firstSegmentWithDeletions, i)));
                firstSegmentWithDeletions = i;
                continue;
            }
            if (firstSegmentWithDeletions == -1) continue;
            if (this.verbose(mergeContext)) {
                this.message("  add merge " + firstSegmentWithDeletions + " to " + (i - 1) + " inclusive", mergeContext);
            }
            spec.add(new MergePolicy.OneMerge(segments.subList(firstSegmentWithDeletions, i)));
            firstSegmentWithDeletions = -1;
        }
        if (firstSegmentWithDeletions != -1) {
            if (this.verbose(mergeContext)) {
                this.message("  add merge " + firstSegmentWithDeletions + " to " + (numSegments - 1) + " inclusive", mergeContext);
            }
            spec.add(new MergePolicy.OneMerge(segments.subList(firstSegmentWithDeletions, numSegments)));
        }
        return spec;
    }

    @Override
    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos infos, MergePolicy.MergeContext mergeContext) throws IOException {
        int numSegments = infos.size();
        if (this.verbose(mergeContext)) {
            this.message("findMerges: " + numSegments + " segments", mergeContext);
        }
        ArrayList<SegmentInfoAndLevel> levels = new ArrayList<SegmentInfoAndLevel>(numSegments);
        float norm = (float)Math.log(this.mergeFactor);
        Set<SegmentCommitInfo> mergingSegments = mergeContext.getMergingSegments();
        for (int i = 0; i < numSegments; ++i) {
            Object extra;
            SegmentCommitInfo info = infos.info(i);
            long size = this.size(info, mergeContext);
            if (size < 1L) {
                size = 1L;
            }
            SegmentInfoAndLevel infoLevel = new SegmentInfoAndLevel(info, (float)Math.log(size) / norm);
            levels.add(infoLevel);
            if (!this.verbose(mergeContext)) continue;
            long segBytes = this.sizeBytes(info, mergeContext);
            Object object = extra = mergingSegments.contains(info) ? " [merging]" : "";
            if (size >= this.maxMergeSize) {
                extra = (String)extra + " [skip: too large]";
            }
            this.message("seg=" + this.segString(mergeContext, Collections.singleton(info)) + " level=" + infoLevel.level + " size=" + String.format(Locale.ROOT, "%.3f MB", (double)segBytes / 1024.0 / 1024.0) + (String)extra, mergeContext);
        }
        float levelFloor = this.minMergeSize <= 0L ? 0.0f : (float)(Math.log(this.minMergeSize) / (double)norm);
        MergePolicy.MergeSpecification spec = null;
        int numMergeableSegments = levels.size();
        float[] maxLevels = new float[numMergeableSegments + 1];
        maxLevels[numMergeableSegments] = -1.0f;
        for (int i = numMergeableSegments - 1; i >= 0; --i) {
            maxLevels[i] = Math.max(((SegmentInfoAndLevel)levels.get((int)i)).level, maxLevels[i + 1]);
        }
        int start = 0;
        while (start < numMergeableSegments) {
            int upto;
            float maxLevel = maxLevels[start];
            float levelBottom = maxLevel > levelFloor ? (float)((double)maxLevel - 0.75) : (float)((double)maxLevel - 1.5);
            for (upto = numMergeableSegments - 1; upto >= start && !(((SegmentInfoAndLevel)levels.get((int)upto)).level >= levelBottom); --upto) {
            }
            if (this.verbose(mergeContext)) {
                this.message("  level " + levelBottom + " to " + maxLevel + ": " + (1 + upto - start) + " segments", mergeContext);
            }
            int end = start + this.mergeFactor;
            while (end <= 1 + upto) {
                boolean anyMerging = false;
                long mergeSize = 0L;
                long mergeDocs = 0L;
                for (int i = start; i < end; ++i) {
                    SegmentInfoAndLevel segLevel = (SegmentInfoAndLevel)levels.get(i);
                    SegmentCommitInfo info = segLevel.info;
                    if (mergingSegments.contains(info)) {
                        anyMerging = true;
                        break;
                    }
                    long segmentSize = this.size(info, mergeContext);
                    long segmentDocs = this.sizeDocs(info, mergeContext);
                    if (mergeSize + segmentSize > this.maxMergeSize || mergeDocs + segmentDocs > (long)this.maxMergeDocs) {
                        if (i == start) {
                            if (this.verbose(mergeContext)) {
                                this.message("    " + i + " is larger than the max merge size/docs; ignoring", mergeContext);
                            }
                            end = i + 1;
                            break;
                        }
                        end = i;
                        break;
                    }
                    mergeSize += segmentSize;
                    mergeDocs += segmentDocs;
                }
                if (!anyMerging && end - start > 1) {
                    if (spec == null) {
                        spec = new MergePolicy.MergeSpecification();
                    }
                    ArrayList<SegmentCommitInfo> mergeInfos = new ArrayList<SegmentCommitInfo>(end - start);
                    for (int i = start; i < end; ++i) {
                        mergeInfos.add(((SegmentInfoAndLevel)levels.get((int)i)).info);
                        assert (infos.contains(((SegmentInfoAndLevel)levels.get((int)i)).info));
                    }
                    if (this.verbose(mergeContext)) {
                        this.message("  add merge=" + this.segString(mergeContext, mergeInfos) + " start=" + start + " end=" + end, mergeContext);
                    }
                    spec.add(new MergePolicy.OneMerge(mergeInfos));
                }
                start = end;
                end = start + this.mergeFactor;
            }
            start = 1 + upto;
        }
        return spec;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    public int getMaxMergeDocs() {
        return this.maxMergeDocs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[" + this.getClass().getSimpleName() + ": ");
        sb.append("minMergeSize=").append(this.minMergeSize).append(", ");
        sb.append("mergeFactor=").append(this.mergeFactor).append(", ");
        sb.append("maxMergeSize=").append(this.maxMergeSize).append(", ");
        sb.append("maxMergeSizeForForcedMerge=").append(this.maxMergeSizeForForcedMerge).append(", ");
        sb.append("calibrateSizeByDeletes=").append(this.calibrateSizeByDeletes).append(", ");
        sb.append("maxMergeDocs=").append(this.maxMergeDocs).append(", ");
        sb.append("maxCFSSegmentSizeMB=").append(this.getMaxCFSSegmentSizeMB()).append(", ");
        sb.append("noCFSRatio=").append(this.noCFSRatio);
        sb.append("]");
        return sb.toString();
    }

    private static class SegmentInfoAndLevel
    implements Comparable<SegmentInfoAndLevel> {
        final SegmentCommitInfo info;
        final float level;

        public SegmentInfoAndLevel(SegmentCommitInfo info, float level) {
            this.info = info;
            this.level = level;
        }

        @Override
        public int compareTo(SegmentInfoAndLevel other) {
            return Float.compare(other.level, this.level);
        }
    }
}

