/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Scriptable;

public final class ColumnReferenceExpression
extends CompiledExpression {
    private String m_columnName;
    private int m_columnIndex;
    private String rowIndicator = "row";
    private int dataType;
    protected static Logger logger = Logger.getLogger(ColumnReferenceExpression.class.getName());

    ColumnReferenceExpression(String rowInd, String columnName) {
        logger.entering(ColumnReferenceExpression.class.getName(), "ColumnReferenceExpression", columnName);
        assert (columnName != null && columnName.length() != 0);
        this.m_columnName = columnName;
        this.m_columnIndex = -1;
        this.rowIndicator = rowInd;
        logger.exiting(ColumnReferenceExpression.class.getName(), "ColumnReferenceExpression");
        this.dataType = -1;
    }

    ColumnReferenceExpression(String rowInd, int columnIndex) {
        logger.entering(ColumnReferenceExpression.class.getName(), "ColumnReferenceExpression", columnIndex);
        assert (columnIndex >= 0);
        this.m_columnIndex = columnIndex;
        this.rowIndicator = rowInd;
        logger.exiting(ColumnReferenceExpression.class.getName(), "ColumnReferenceExpression");
    }

    @Override
    public int getType() {
        return 1;
    }

    public String getColumnName() {
        return this.m_columnName;
    }

    public int getColumnindex() {
        return this.m_columnIndex;
    }

    public boolean isIndexed() {
        return this.m_columnIndex != -1;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ColumnReferenceExpression)) {
            return false;
        }
        ColumnReferenceExpression expr2 = (ColumnReferenceExpression)other;
        if (this.dataType != expr2.dataType) {
            return false;
        }
        if (this.m_columnName != null) {
            return this.m_columnName.equals(expr2.m_columnName);
        }
        return this.m_columnIndex == expr2.m_columnIndex;
    }

    public int hashCode() {
        if (this.m_columnName != null) {
            return this.m_columnName.hashCode();
        }
        return this.m_columnIndex;
    }

    @Override
    public Object evaluate(ScriptContext context, Scriptable scope) throws DataException {
        StringBuilder expr = new StringBuilder(this.rowIndicator + "[");
        if (this.isIndexed()) {
            expr.append(this.m_columnIndex);
        } else {
            expr.append('\"');
            expr.append(JavascriptEvalUtil.transformToJsConstants((String)this.m_columnName));
            expr.append('\"');
        }
        expr.append(']');
        try {
            return DataTypeUtil.convert((Object)ScriptEvalUtil.evaluateJSAsExpr(context, scope, expr.toString(), ScriptExpression.defaultID, 0), (int)this.dataType);
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    public void setDataType(int type) {
        this.dataType = type;
    }

    public int getDataType() {
        return this.dataType;
    }
}

