/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter;

import org.eclipse.birt.data.engine.olap.api.query.ICubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFilterHelper;

class AggrFilterDefinition {
    protected DimLevel[] aggrLevels;
    protected IJSFilterHelper filterHelper;
    protected DimLevel targetLevel;
    protected DimLevel[] axisQualifierLevels;
    protected Object[] axisQualifierValues;

    AggrFilterDefinition(IJSFilterHelper filterEvalHelper) {
        this.filterHelper = filterEvalHelper;
        ICubeFilterDefinition cubeFilter = filterEvalHelper.getCubeFilterDefinition();
        if (cubeFilter.getTargetLevel() != null) {
            this.targetLevel = new DimLevel(cubeFilter.getTargetLevel());
        }
        this.aggrLevels = filterEvalHelper.getAggrLevels();
        ILevelDefinition[] axisLevels = cubeFilter.getAxisQualifierLevels();
        if (axisLevels != null) {
            this.axisQualifierLevels = new DimLevel[axisLevels.length];
            int i = 0;
            while (i < axisLevels.length) {
                this.axisQualifierLevels[i] = new DimLevel(axisLevels[i]);
                ++i;
            }
        }
        this.axisQualifierValues = cubeFilter.getAxisQualifierValues();
    }

    DimLevel[] getAxisQualifierLevels() {
        return this.axisQualifierLevels;
    }

    Object[] getAxisQualifierValues() {
        return this.axisQualifierValues;
    }

    DimLevel[] getAggrLevels() {
        return this.aggrLevels;
    }

    IJSFilterHelper getFilterHelper() {
        return this.filterHelper;
    }

    DimLevel getTargetLevel() {
        return this.targetLevel;
    }
}

