/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.action;

import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.AddComputedSummaryDialog;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AbstractCrosstabAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.util.CrosstabUIHelper;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class AddComputedMeasureAction
extends AbstractCrosstabAction {
    private MeasureViewHandle measureViewHandle;
    private CrosstabReportItemHandle reportHandle;
    public static final String ID = "org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AddComputedMeasureAction";
    private static final String NAME = Messages.getString("AddComputedMesureHandleAction.DisplayName");
    private static final String ACTION_MSG_MERGE = Messages.getString("AddComputedMesureHandleAction.TransName");

    public AddComputedMeasureAction(DesignElementHandle handle) {
        super(handle);
        this.setId(ID);
        this.setText(NAME);
        ExtendedItemHandle extendedHandle = CrosstabAdaptUtil.getExtendedItemHandle(handle);
        this.setHandle((DesignElementHandle)extendedHandle);
        this.measureViewHandle = CrosstabAdaptUtil.getMeasureViewHandle(extendedHandle);
        this.reportHandle = this.measureViewHandle.getCrosstab();
        Image image = CrosstabUIHelper.getImage("icons/pal/derived-measure.gif");
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
    }

    public AddComputedMeasureAction(CrosstabReportItemHandle crosstab) {
        super(crosstab.getModelHandle());
        this.setId(ID);
        this.setText(NAME);
        this.reportHandle = crosstab;
        Image image = CrosstabUIHelper.getImage("icons/pal/derived-measure.gif");
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
    }

    @Override
    public boolean isEnabled() {
        CubeHandle cubeHandle = this.reportHandle.getCube();
        if (cubeHandle == null) {
            return false;
        }
        return !DEUtil.isReferenceElement((DesignElementHandle)this.reportHandle.getCrosstabHandle());
    }

    public void run() {
        this.transStar(NAME);
        AddComputedSummaryDialog computedSummaryDialog = new AddComputedSummaryDialog(UIUtil.getDefaultShell(), this.reportHandle);
        if (computedSummaryDialog.open() == 0) {
            String measureName = computedSummaryDialog.getName();
            Expression expression = computedSummaryDialog.getExpression();
            String dataType = computedSummaryDialog.getDataType();
            int index = this.caleIndex();
            try {
                ComputedMeasureViewHandle computedMeasure = this.reportHandle.insertComputedMeasure(measureName, index);
                computedMeasure.addHeader();
                ExtendedItemHandle crosstabModelHandle = (ExtendedItemHandle)this.reportHandle.getModelHandle();
                ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)crosstabModelHandle, (String)measureName);
                ComputedColumnHandle bindingHandle = crosstabModelHandle.addColumnBinding(bindingColumn, false);
                bindingHandle.setExpressionProperty("expression", expression);
                bindingHandle.setDataType(dataType);
                DataItemHandle dataHandle = DesignElementFactory.getInstance().newDataItem(measureName);
                CrosstabAdaptUtil.formatDataItem(computedMeasure.getCubeMeasure(), dataHandle);
                dataHandle.setResultSetColumn(bindingHandle.getName());
                AggregationCellHandle cell = computedMeasure.getCell();
                if ("horizontal".equals(this.reportHandle.getMeasureDirection())) {
                    CrosstabCellHandle cellHandle = computedMeasure.getHeader();
                    if (cellHandle == null) {
                        cellHandle = cell;
                    }
                    String string = this.reportHandle.getModelHandle().getModuleHandle().getDefaultUnits();
                }
                cell.addContent((DesignElementHandle)dataHandle);
            }
            catch (SemanticException e) {
                e.printStackTrace();
                this.rollBack();
            }
        }
        this.transEnd();
    }

    private int caleIndex() {
        if (this.measureViewHandle != null) {
            return this.reportHandle.getAllMeasures().indexOf(this.measureViewHandle) + 1;
        }
        return this.reportHandle.getAllMeasures().size();
    }
}

