/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;

public class ToolUtilities {
    public static List<? extends EditPart> getSelectionWithoutDependants(EditPartViewer viewer) {
        return ToolUtilities.getSelectionWithoutDependants(viewer.getSelectedEditParts());
    }

    public static List<? extends EditPart> getSelectionWithoutDependants(List<? extends EditPart> selectedParts) {
        return new ArrayList<EditPart>(selectedParts.stream().filter(ep -> !ToolUtilities.isAncestorContainedIn(selectedParts, ep)).toList());
    }

    public static void filterEditPartsUnderstanding(List<? extends EditPart> list, Request request) {
        Iterator<? extends EditPart> iter = list.iterator();
        while (iter.hasNext()) {
            EditPart ep = iter.next();
            if (ep.understandsRequest(request)) continue;
            iter.remove();
        }
    }

    public static boolean isAncestorContainedIn(Collection<? extends EditPart> c, EditPart ep) {
        ep = ep.getParent();
        while (ep != null) {
            if (c.contains(ep)) {
                return true;
            }
            ep = ep.getParent();
        }
        return false;
    }

    public static EditPart findCommonAncestor(EditPart ll, EditPart rr) {
        if (ll == rr) {
            return ll;
        }
        ArrayList<EditPart> leftAncestors = new ArrayList<EditPart>();
        ArrayList<EditPart> rightAncestors = new ArrayList<EditPart>();
        EditPart l = ll;
        EditPart r = rr;
        while (l != null) {
            leftAncestors.add(l);
            l = l.getParent();
        }
        while (r != null) {
            rightAncestors.add(r);
            r = r.getParent();
        }
        int il = leftAncestors.size() - 1;
        int ir = rightAncestors.size() - 1;
        while (leftAncestors.get(il) == rightAncestors.get(ir) && --il >= 0 && --ir >= 0) {
        }
        return (EditPart)leftAncestors.get(il + 1);
    }
}

