/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

class Splitter
extends Composite {
    public static final int DEFAULT_SASH_WIDTH = 5;
    private static final int DRAG_MINIMUM = 62;
    private static final String MAINTAIN_SIZE = "maintain size";
    private int fixedSize = 150;
    private int orientation = 512;
    private Sash[] sashes = new Sash[0];
    private Control[] controls = new Control[0];
    private Control maxControl = null;
    private final Listener sashListener;
    private int sashWidth = 5;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport((Object)this);

    public void addFixedSizeChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    protected void firePropertyChange(int oldValue, int newValue) {
        this.listeners.firePropertyChange(MAINTAIN_SIZE, oldValue, newValue);
    }

    public void removeFixedSizeChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public int getFixedSize() {
        return this.fixedSize;
    }

    public void setFixedSize(int newSize) {
        if (newSize == this.fixedSize) {
            return;
        }
        this.fixedSize = newSize;
        this.firePropertyChange(this.fixedSize, this.fixedSize);
    }

    public Splitter(Composite parent, int style) {
        super(parent, Splitter.checkStyle(style));
        if ((style & 0x100) != 0) {
            this.orientation = 256;
        }
        this.addListener(11, e -> this.layout(true));
        this.sashListener = this::onDragSash;
    }

    private static int checkStyle(int style) {
        int mask = 2048;
        return style & mask;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        boolean vertical;
        Control[] controls = this.getControls(true);
        if (controls.length == 0) {
            return new Point(wHint, hHint);
        }
        int width = 0;
        int height = 0;
        boolean bl = vertical = (this.getStyle() & 0x200) != 0;
        if (vertical) {
            width = wHint;
            height += (controls.length - 1) * this.getSashWidth();
        } else {
            height = hHint;
            width += controls.length * this.getSashWidth();
        }
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (vertical) {
                size = control.computeSize(wHint, -1);
                height += size.y;
            } else {
                size = control.computeSize(-1, hHint);
                if (control.getData(MAINTAIN_SIZE) != null) {
                    size.x = this.fixedSize;
                }
                width += size.x;
            }
            ++n2;
        }
        return new Point(width, height);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getSashWidth() {
        return this.sashWidth;
    }

    public Control getMaximizedControl() {
        return this.maxControl;
    }

    private Control[] getControls(boolean onlyVisible) {
        Control[] children = this.getChildren();
        Control[] controls = new Control[]{};
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (!(child instanceof Sash || onlyVisible && !child.getVisible())) {
                Control[] newControls = new Control[controls.length + 1];
                System.arraycopy(controls, 0, newControls, 0, controls.length);
                newControls[controls.length] = child;
                controls = newControls;
            }
            ++n2;
        }
        return controls;
    }

    public void layout(boolean changed) {
        int i;
        int sashOrientation;
        Sash[] newSashes;
        Rectangle area = this.getClientArea();
        if (area.width == 0 || area.height == 0) {
            return;
        }
        Control[] newControls = this.getControls(true);
        if (this.controls.length == 0 && newControls.length == 0) {
            return;
        }
        this.controls = newControls;
        if (this.maxControl != null && !this.maxControl.isDisposed()) {
            Control[] controlArray = this.controls;
            int n = this.controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control != this.maxControl) {
                    control.setBounds(-200, -200, 0, 0);
                } else {
                    control.setBounds(area);
                }
                ++n2;
            }
            return;
        }
        if (this.sashes.length < this.controls.length - 1) {
            newSashes = new Sash[this.controls.length - 1];
            System.arraycopy(this.sashes, 0, newSashes, 0, this.sashes.length);
            sashOrientation = this.orientation == 256 ? 512 : 256;
            i = this.sashes.length;
            while (i < newSashes.length) {
                newSashes[i] = new Sash((Composite)this, sashOrientation);
                newSashes[i].setBackground(ColorConstants.button);
                newSashes[i].addListener(9, (Listener)new SashPainter());
                newSashes[i].addListener(13, this.sashListener);
                ++i;
            }
            this.sashes = newSashes;
        }
        if (this.sashes.length > this.controls.length - 1) {
            if (this.controls.length == 0) {
                Sash[] sashArray = this.sashes;
                i = this.sashes.length;
                sashOrientation = 0;
                while (sashOrientation < i) {
                    Sash element = sashArray[sashOrientation];
                    element.dispose();
                    ++sashOrientation;
                }
                this.sashes = new Sash[0];
            } else {
                newSashes = new Sash[this.controls.length - 1];
                System.arraycopy(this.sashes, 0, newSashes, 0, newSashes.length);
                int i2 = this.controls.length - 1;
                while (i2 < this.sashes.length) {
                    this.sashes[i2].dispose();
                    ++i2;
                }
                this.sashes = newSashes;
            }
        }
        if (this.controls.length == 0) {
            return;
        }
        int x = area.x;
        Control[] controlArray = this.controls;
        int n = this.controls.length;
        int n3 = 0;
        while (n3 < n) {
            Control control = controlArray[n3];
            if (control.getData(MAINTAIN_SIZE) != null) {
                width = this.fixedSize;
                if (width > area.width) {
                    width = area.width - this.getSashWidth();
                }
                control.setBounds(x, area.y, width, area.height);
                x += width + this.getSashWidth();
            } else {
                width = Math.max(area.width - this.fixedSize - this.getSashWidth(), 0);
                control.setBounds(x, area.y, width, area.height);
                x += width + this.getSashWidth();
            }
            ++n3;
        }
        if (this.sashes.length > 0) {
            this.sashes[0].setBounds(this.controls[0].getBounds().x + this.controls[0].getBounds().width, area.y, this.getSashWidth(), area.height);
        }
    }

    public void maintainSize(Control c) {
        Control[] controls;
        Control[] controlArray = controls = this.getControls(false);
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctrl = controlArray[n2];
            if (ctrl == c) {
                ctrl.setData(MAINTAIN_SIZE, (Object)true);
                break;
            }
            ++n2;
        }
    }

    void paint(Sash sash, GC gc) {
        if (this.getSashWidth() == 0) {
            return;
        }
        Point size = sash.getSize();
        if (this.getOrientation() == 256) {
            gc.setForeground(ColorConstants.buttonDarker);
            gc.drawLine(this.getSashWidth() - 1, 0, this.getSashWidth() - 1, size.y);
            gc.setForeground(ColorConstants.buttonLightest);
            gc.drawLine(0, 0, 0, size.y);
        } else {
            gc.setForeground(ColorConstants.buttonDarker);
            gc.drawLine(0, 0, size.x, 0);
            gc.drawLine(0, this.getSashWidth() - 1, size.x, this.getSashWidth() - 1);
            gc.setForeground(ColorConstants.buttonLightest);
            gc.drawLine(0, 1, size.x, 1);
        }
    }

    private void onDragSash(Event event) {
        if (event.detail == 1) {
            Rectangle area = this.getClientArea();
            if (this.orientation == 256) {
                event.x = this.controls[0].getData(MAINTAIN_SIZE) != null ? Math.max(event.x, 62) : Math.min(event.x, area.width - 62 - this.getSashWidth());
            } else {
                event.y = Math.min(event.y, area.height - 62 - this.getSashWidth());
            }
            return;
        }
        Sash sash = (Sash)event.widget;
        int sashIndex = -1;
        int i = 0;
        while (i < this.sashes.length) {
            if (this.sashes[i] == sash) {
                sashIndex = i;
                break;
            }
            ++i;
        }
        if (sashIndex == -1) {
            return;
        }
        Control c1 = this.controls[sashIndex];
        Control c2 = this.controls[sashIndex + 1];
        Rectangle b1 = c1.getBounds();
        Rectangle b2 = c2.getBounds();
        this.controls = this.getControls(false);
        Rectangle sashBounds = sash.getBounds();
        if (this.orientation == 256) {
            int shift = event.x - sashBounds.x;
            b1.width += shift;
            b2.x += shift;
            b2.width -= shift;
        } else {
            int shift = event.y - sashBounds.y;
            b1.height += shift;
            b2.y += shift;
            b2.height -= shift;
        }
        c1.setBounds(b1);
        sash.setBounds(event.x, event.y, event.width, event.height);
        c2.setBounds(b2);
        if (c1.getData(MAINTAIN_SIZE) != null) {
            this.setFixedSize(c1.getBounds().width);
        } else {
            this.setFixedSize(c2.getBounds().width);
        }
    }

    public void setOrientation(int orientation) {
        if (this.orientation == orientation) {
            return;
        }
        if (orientation != 256 && orientation != 512) {
            SWT.error((int)5);
        }
        this.orientation = orientation;
        int sashOrientation = orientation == 256 ? 512 : 256;
        int i = 0;
        while (i < this.sashes.length) {
            this.sashes[i].dispose();
            this.sashes[i] = new Sash((Composite)this, sashOrientation);
            this.sashes[i].setBackground(ColorConstants.buttonLightest);
            this.sashes[i].addListener(13, this.sashListener);
            ++i;
        }
        this.layout();
    }

    public void setSashWidth(int width) {
        this.sashWidth = width;
    }

    public void setLayout(Layout layout) {
    }

    public void setMaximizedControl(Control control) {
        if (control == null) {
            if (this.maxControl != null) {
                this.maxControl = null;
                this.layout();
                Sash[] sashArray = this.sashes;
                int n = this.sashes.length;
                int n2 = 0;
                while (n2 < n) {
                    Sash element = sashArray[n2];
                    element.setVisible(true);
                    ++n2;
                }
            }
            return;
        }
        Sash[] sashArray = this.sashes;
        int n = this.sashes.length;
        int n3 = 0;
        while (n3 < n) {
            Sash element = sashArray[n3];
            element.setVisible(false);
            ++n3;
        }
        this.maxControl = control;
        this.layout();
    }

    class SashPainter
    implements Listener {
        SashPainter() {
        }

        public void handleEvent(Event e) {
            Splitter.this.paint((Sash)e.widget, e.gc);
        }
    }
}

