/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.libprov.user.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.common.project.facet.core.internal.FacetedProjectFrameworkJavaPlugin;
import org.eclipse.jst.common.project.facet.core.libprov.EnablementExpressionContext;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.user.UserLibraryProviderInstallOperationConfig;
import org.eclipse.jst.common.project.facet.core.libprov.user.internal.DownloadableLibrary;
import org.eclipse.jst.common.project.facet.core.libprov.user.internal.DownloadableLibraryComponentAttributes;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.util.internal.DomUtil;
import org.eclipse.wst.common.project.facet.core.util.internal.PluginUtil;
import org.eclipse.wst.common.project.facet.core.util.internal.XmlParseException;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class DownloadableLibrariesExtensionPoint {
    public static final String EXTENSION_POINT_ID = "downloadableLibraries";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_URL = "url";
    private static final String EL_IMPORT_DEFINITIONS = "import-definitions";
    private static final String EL_ENABLEMENT = "enablement";
    private static final String EL_LIBRARY = "library";
    private static final String EL_NAME = "name";
    private static final String EL_DOWNLOAD_PROVIDER = "download-provider";
    private static final String EL_DOWNLOAD_URL = "download-url";
    private static final String EL_LICENSE_URL = "license-url";
    private static final String EL_INCLUDE = "include";
    private static final String EL_EXCLUDE = "exclude";
    private static final String EL_ATTRIBUTES = "attributes";
    private static final String EL_COMPONENT = "component";
    private static final String EL_SOURCE = "source";
    private static final String EL_JAVADOC = "javadoc";
    private static final String EXPR_VAR_CONTEXT = "context";
    private static final String EXPR_VAR_REQUESTING_PROJECT_FACET = "requestingProjectFacet";
    private static final String EXPR_VAR_PROJECT_FACETS = "projectFacets";
    private static final String EXPR_VAR_TARGETED_RUNTIMES = "targetedRuntimes";
    private static final String EXPR_VAR_PROVIDER = "provider";

    public static List<DownloadableLibrary> list(UserLibraryProviderInstallOperationConfig cfg, IProgressMonitor monitor) {
        IProgressMonitor mon = monitor != null ? monitor : new NullProgressMonitor();
        mon.beginTask(Resources.searchingForLibrariesTaskName, -1);
        try {
            ArrayList<DownloadableLibrary> libraries = new ArrayList<DownloadableLibrary>();
            for (IConfigurationElement element : PluginUtil.getTopLevelElements((Collection)PluginUtil.findExtensions((String)"org.eclipse.jst.common.project.facet.core", (String)EXTENSION_POINT_ID))) {
                URL url;
                String pluginId;
                block16: {
                    if (mon.isCanceled()) {
                        return null;
                    }
                    pluginId = element.getContributor().getName();
                    if (!element.getName().equals(EL_IMPORT_DEFINITIONS)) continue;
                    IConfigurationElement elEnablement = PluginUtil.findOptionalElement((IConfigurationElement)element, (String)EL_ENABLEMENT);
                    if (elEnablement != null) {
                        try {
                            Expression expr = ExpressionConverter.getDefault().perform(elEnablement);
                            EvaluationContext context = DownloadableLibrariesExtensionPoint.createEvaluationContext(cfg.getFacetedProject(), cfg.getProjectFacetVersion(), cfg.getLibraryProvider());
                            if (expr.evaluate((IEvaluationContext)context) != EvaluationResult.TRUE) {
                                continue;
                            }
                        }
                        catch (CoreException e) {
                            FacetedProjectFrameworkJavaPlugin.log((Exception)((Object)e));
                            break;
                        }
                    }
                    url = null;
                    String pathAttr = element.getAttribute(ATTR_PATH);
                    String urlAttr = element.getAttribute(ATTR_URL);
                    if (pathAttr != null) {
                        Bundle plugin = Platform.getBundle((String)pluginId);
                        url = FileLocator.find((Bundle)plugin, (IPath)new Path(pathAttr), null);
                        if (url == null) {
                            msg = NLS.bind((String)Resources.errorPluginResourceNotFound, (Object)pluginId, (Object)pathAttr);
                            FacetedProjectFrameworkJavaPlugin.logError(msg);
                            continue;
                        }
                    } else {
                        if (urlAttr != null) {
                            try {
                                url = new URL(urlAttr);
                                break block16;
                            }
                            catch (MalformedURLException e) {
                                msg = NLS.bind((String)Resources.errorMalformedUrl, (Object)pluginId, (Object)urlAttr);
                                FacetedProjectFrameworkJavaPlugin.log(FacetedProjectFrameworkJavaPlugin.createErrorStatus(msg, e));
                                continue;
                            }
                        }
                        String msg = NLS.bind((String)Resources.errorMissingPathOrUrl, (Object)pluginId);
                        FacetedProjectFrameworkJavaPlugin.logError(msg);
                        continue;
                    }
                }
                DownloadableLibrariesExtensionPoint.readLibraryDefinitions(pluginId, url, libraries);
            }
            ArrayList<DownloadableLibrary> arrayList = libraries;
            return arrayList;
        }
        finally {
            mon.done();
        }
    }

    private static EvaluationContext createEvaluationContext(IFacetedProjectBase fproj, IProjectFacetVersion fv, ILibraryProvider provider) {
        EvaluationContext evalContext = new EvaluationContext(null, (Object)fv);
        EnablementExpressionContext context = new EnablementExpressionContext(fproj, fv, provider);
        evalContext.addVariable(EXPR_VAR_CONTEXT, (Object)context);
        evalContext.addVariable(EXPR_VAR_REQUESTING_PROJECT_FACET, (Object)fv);
        evalContext.addVariable(EXPR_VAR_PROJECT_FACETS, (Object)fproj.getProjectFacets());
        evalContext.addVariable(EXPR_VAR_TARGETED_RUNTIMES, (Object)fproj.getTargetedRuntimes());
        evalContext.addVariable(EXPR_VAR_PROVIDER, (Object)provider);
        evalContext.setAllowPluginActivation(true);
        return evalContext;
    }

    private static void readLibraryDefinitions(String pluginId, URL url, List<DownloadableLibrary> libraries) {
        Element root;
        Document document = null;
        InputStream in = null;
        try {
            in = url.openStream();
        }
        catch (IOException e) {
            String msg = NLS.bind((String)Resources.errorReadingDefFile, (Object)url.toString());
            FacetedProjectFrameworkJavaPlugin.log(FacetedProjectFrameworkJavaPlugin.createErrorStatus(msg, e));
            return;
        }
        try {
            try {
                document = DomUtil.doc((InputStream)in);
            }
            catch (XmlParseException e) {
                String msg = NLS.bind((String)Resources.errorParsingDefFile, (Object)url.toString());
                FacetedProjectFrameworkJavaPlugin.log(FacetedProjectFrameworkJavaPlugin.createErrorStatus(msg, (Exception)((Object)e)));
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        if (document != null && (root = document.getDocumentElement()) != null) {
            for (Element elLibrary : DomUtil.elements((Element)root, (String)EL_LIBRARY)) {
                try {
                    DownloadableLibrary library = new DownloadableLibrary();
                    library.setPluginId(pluginId);
                    String name = DownloadableLibrariesExtensionPoint.getRequiredElementText(url, elLibrary, EL_NAME);
                    library.setName(name);
                    String provider = DownloadableLibrariesExtensionPoint.getRequiredElementText(url, elLibrary, EL_DOWNLOAD_PROVIDER);
                    library.setDownloadProvider(provider);
                    String downloadUrl = DownloadableLibrariesExtensionPoint.getRequiredElementText(url, elLibrary, EL_DOWNLOAD_URL);
                    library.setUrl(downloadUrl);
                    String licenseUrl = DomUtil.text((Element)elLibrary, (String)EL_LICENSE_URL);
                    library.setLicenseUrl(licenseUrl);
                    for (Element elInclude : DomUtil.elements((Element)elLibrary, (String)EL_INCLUDE)) {
                        library.addIncludePattern(DomUtil.text((Element)elInclude));
                    }
                    for (Element elExclude : DomUtil.elements((Element)elLibrary, (String)EL_EXCLUDE)) {
                        library.addExcludePattern(DomUtil.text((Element)elExclude));
                    }
                    for (Element elAttachment : DomUtil.elements((Element)elLibrary, (String)EL_ATTRIBUTES)) {
                        String jarPath = DownloadableLibrariesExtensionPoint.getRequiredElementText(url, elAttachment, EL_COMPONENT);
                        DownloadableLibraryComponentAttributes attachment = library.getComponentAttributes((IPath)new Path(jarPath), true);
                        String sourceArchivePath = DomUtil.text((Element)elAttachment, (String)EL_SOURCE);
                        attachment.setSourceArchivePath(sourceArchivePath);
                        String javadocArchivePath = DomUtil.text((Element)elAttachment, (String)EL_JAVADOC);
                        attachment.setJavadocArchivePath(javadocArchivePath);
                    }
                    libraries.add(library);
                }
                catch (InvalidLibraryDefinitionException invalidLibraryDefinitionException) {}
            }
        }
    }

    private static String getRequiredElementText(URL url, Element parent, String childElementName) throws InvalidLibraryDefinitionException {
        String val = DomUtil.text((Element)parent, (String)childElementName);
        if (val == null) {
            String msg = NLS.bind((String)Resources.errorDefMissingElement, (Object)childElementName, (Object)url.toString());
            FacetedProjectFrameworkJavaPlugin.logError(msg);
            throw new InvalidLibraryDefinitionException();
        }
        return val;
    }

    private static class InvalidLibraryDefinitionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private InvalidLibraryDefinitionException() {
        }
    }

    private static final class Resources
    extends NLS {
        public static String searchingForLibrariesTaskName;
        public static String errorDefMissingElement;
        public static String errorParsingDefFile;
        public static String errorReadingDefFile;
        public static String errorPluginResourceNotFound;
        public static String errorMalformedUrl;
        public static String errorMissingPathOrUrl;

        static {
            Resources.initializeMessages((String)DownloadableLibrariesExtensionPoint.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

