/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.AutoFilter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellRange;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.PageMargin;
import org.apache.poi.ss.usermodel.PaneType;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.PaneInformation;

public class FilteredSheet
implements Sheet {
    private Sheet sheet;
    private int minRow;
    private int maxRow;

    public FilteredSheet(Sheet sheet, int minRow, int maxRow) {
        this.sheet = sheet;
        this.minRow = minRow;
        this.maxRow = maxRow;
    }

    public CellRangeAddress getRepeatingColumns() {
        return this.sheet.getRepeatingColumns();
    }

    public CellRangeAddress getRepeatingRows() {
        return this.sheet.getRepeatingRows();
    }

    public void setRepeatingColumns(CellRangeAddress arg0) {
        this.sheet.setRepeatingColumns(arg0);
    }

    public void setRepeatingRows(CellRangeAddress arg0) {
        this.sheet.setRepeatingRows(arg0);
    }

    public Iterator<Row> iterator() {
        return this.rowIterator();
    }

    public Row createRow(int rownum) {
        return this.sheet.createRow(rownum);
    }

    public void removeRow(Row row) {
        this.sheet.removeRow(row);
    }

    public Row getRow(int rownum) {
        return this.sheet.getRow(rownum);
    }

    public int getPhysicalNumberOfRows() {
        return this.sheet.getPhysicalNumberOfRows();
    }

    public int getFirstRowNum() {
        return Math.max(this.minRow, this.sheet.getFirstRowNum());
    }

    public int getLastRowNum() {
        return Math.min(this.maxRow, this.sheet.getLastRowNum());
    }

    public void setColumnHidden(int columnIndex, boolean hidden) {
        this.sheet.setColumnHidden(columnIndex, hidden);
    }

    public boolean isColumnHidden(int columnIndex) {
        return this.sheet.isColumnHidden(columnIndex);
    }

    public void setRightToLeft(boolean value) {
        this.sheet.setRightToLeft(value);
    }

    public boolean isRightToLeft() {
        return this.sheet.isRightToLeft();
    }

    public void setColumnWidth(int columnIndex, int width) {
        this.sheet.setColumnWidth(columnIndex, width);
    }

    public int getColumnWidth(int columnIndex) {
        return this.sheet.getColumnWidth(columnIndex);
    }

    public void setDefaultColumnWidth(int width) {
        this.sheet.setDefaultColumnWidth(width);
    }

    public int getDefaultColumnWidth() {
        return this.sheet.getDefaultColumnWidth();
    }

    public short getDefaultRowHeight() {
        return this.sheet.getDefaultRowHeight();
    }

    public float getDefaultRowHeightInPoints() {
        return this.sheet.getDefaultRowHeightInPoints();
    }

    public void setDefaultRowHeight(short height) {
        this.sheet.setDefaultRowHeight(height);
    }

    public void setDefaultRowHeightInPoints(float height) {
        this.sheet.setDefaultRowHeightInPoints(height);
    }

    public CellStyle getColumnStyle(int column) {
        return this.sheet.getColumnStyle(column);
    }

    public int addMergedRegion(CellRangeAddress region) {
        return this.sheet.addMergedRegion(region);
    }

    public void setVerticallyCenter(boolean value) {
        this.sheet.setVerticallyCenter(value);
    }

    public void setHorizontallyCenter(boolean value) {
        this.sheet.setHorizontallyCenter(value);
    }

    public boolean getHorizontallyCenter() {
        return this.sheet.getHorizontallyCenter();
    }

    public boolean getVerticallyCenter() {
        return this.sheet.getVerticallyCenter();
    }

    public void removeMergedRegion(int index) {
        this.sheet.removeMergedRegion(index);
    }

    public int getNumMergedRegions() {
        return this.sheet.getNumMergedRegions();
    }

    public CellRangeAddress getMergedRegion(int index) {
        return this.sheet.getMergedRegion(index);
    }

    public Iterator<Row> rowIterator() {
        return new FilteredIterator(this.sheet.rowIterator(), this.minRow, this.maxRow);
    }

    public void setForceFormulaRecalculation(boolean value) {
        this.sheet.setForceFormulaRecalculation(value);
    }

    public boolean getForceFormulaRecalculation() {
        return this.sheet.getForceFormulaRecalculation();
    }

    public void setAutobreaks(boolean value) {
        this.sheet.setAutobreaks(value);
    }

    public void setDisplayGuts(boolean value) {
        this.sheet.setDisplayGuts(value);
    }

    public void setDisplayZeros(boolean value) {
        this.sheet.setDisplayZeros(value);
    }

    public boolean isDisplayZeros() {
        return this.sheet.isDisplayZeros();
    }

    public void setFitToPage(boolean value) {
        this.sheet.setFitToPage(value);
    }

    public void setRowSumsBelow(boolean value) {
        this.sheet.setRowSumsBelow(value);
    }

    public void setRowSumsRight(boolean value) {
        this.sheet.setRowSumsRight(value);
    }

    public boolean getAutobreaks() {
        return this.sheet.getAutobreaks();
    }

    public boolean getDisplayGuts() {
        return this.sheet.getDisplayGuts();
    }

    public boolean getFitToPage() {
        return this.sheet.getFitToPage();
    }

    public boolean getRowSumsBelow() {
        return this.sheet.getRowSumsBelow();
    }

    public boolean getRowSumsRight() {
        return this.sheet.getRowSumsRight();
    }

    public boolean isPrintGridlines() {
        return this.sheet.isPrintGridlines();
    }

    public void setPrintGridlines(boolean show) {
        this.sheet.setPrintGridlines(show);
    }

    public PrintSetup getPrintSetup() {
        return this.sheet.getPrintSetup();
    }

    public Header getHeader() {
        return this.sheet.getHeader();
    }

    public Footer getFooter() {
        return this.sheet.getFooter();
    }

    public void setSelected(boolean value) {
        this.sheet.setSelected(value);
    }

    public double getMargin(short margin) {
        return this.sheet.getMargin(margin);
    }

    public void setMargin(short margin, double size) {
        this.sheet.setMargin(margin, size);
    }

    public boolean getProtect() {
        return this.sheet.getProtect();
    }

    public void protectSheet(String password) {
        this.sheet.protectSheet(password);
    }

    public boolean getScenarioProtect() {
        return this.sheet.getScenarioProtect();
    }

    public void setZoom(int numerator, int denominator) {
        double dnum = Integer.valueOf(numerator).doubleValue();
        double dden = Integer.valueOf(denominator).doubleValue();
        double pct = dnum / dden * 100.0;
        this.sheet.setZoom(Double.valueOf(pct).intValue());
    }

    public short getTopRow() {
        return this.sheet.getTopRow();
    }

    public short getLeftCol() {
        return this.sheet.getLeftCol();
    }

    public void showInPane(short toprow, short leftcol) {
        this.sheet.showInPane((int)toprow, (int)leftcol);
    }

    public void shiftRows(int startRow, int endRow, int n) {
        this.sheet.shiftRows(startRow, endRow, n);
    }

    public void shiftRows(int startRow, int endRow, int n, boolean copyRowHeight, boolean resetOriginalRowHeight) {
        this.sheet.shiftRows(startRow, endRow, n, copyRowHeight, resetOriginalRowHeight);
    }

    public void createFreezePane(int colSplit, int rowSplit, int leftmostColumn, int topRow) {
        this.sheet.createFreezePane(colSplit, rowSplit, leftmostColumn, topRow);
    }

    public void createFreezePane(int colSplit, int rowSplit) {
        this.sheet.createFreezePane(colSplit, rowSplit);
    }

    public void createSplitPane(int xSplitPos, int ySplitPos, int leftmostColumn, int topRow, int activePane) {
        this.sheet.createSplitPane(xSplitPos, ySplitPos, leftmostColumn, topRow, activePane);
    }

    public PaneInformation getPaneInformation() {
        return this.sheet.getPaneInformation();
    }

    public void setDisplayGridlines(boolean show) {
        this.sheet.setDisplayGridlines(show);
    }

    public boolean isDisplayGridlines() {
        return this.sheet.isDisplayGridlines();
    }

    public void setDisplayFormulas(boolean show) {
        this.sheet.setDisplayFormulas(show);
    }

    public boolean isDisplayFormulas() {
        return this.sheet.isDisplayFormulas();
    }

    public void setDisplayRowColHeadings(boolean show) {
        this.sheet.setDisplayRowColHeadings(show);
    }

    public boolean isDisplayRowColHeadings() {
        return this.sheet.isDisplayRowColHeadings();
    }

    public void setRowBreak(int row) {
        this.sheet.setRowBreak(row);
    }

    public boolean isRowBroken(int row) {
        return this.sheet.isRowBroken(row);
    }

    public void removeRowBreak(int row) {
        this.sheet.removeRowBreak(row);
    }

    public int[] getRowBreaks() {
        return this.sheet.getRowBreaks();
    }

    public int[] getColumnBreaks() {
        return this.sheet.getColumnBreaks();
    }

    public void setColumnBreak(int column) {
        this.sheet.setColumnBreak(column);
    }

    public boolean isColumnBroken(int column) {
        return this.sheet.isColumnBroken(column);
    }

    public void removeColumnBreak(int column) {
        this.sheet.removeColumnBreak(column);
    }

    public void setColumnGroupCollapsed(int columnNumber, boolean collapsed) {
        this.sheet.setColumnGroupCollapsed(columnNumber, collapsed);
    }

    public void groupColumn(int fromColumn, int toColumn) {
        this.sheet.groupColumn(fromColumn, toColumn);
    }

    public void ungroupColumn(int fromColumn, int toColumn) {
        this.sheet.ungroupColumn(fromColumn, toColumn);
    }

    public void groupRow(int fromRow, int toRow) {
        this.sheet.groupRow(fromRow, toRow);
    }

    public void ungroupRow(int fromRow, int toRow) {
        this.sheet.ungroupRow(fromRow, toRow);
    }

    public void setRowGroupCollapsed(int row, boolean collapse) {
        this.sheet.setRowGroupCollapsed(row, collapse);
    }

    public void setDefaultColumnStyle(int column, CellStyle style) {
        this.sheet.setDefaultColumnStyle(column, style);
    }

    public void autoSizeColumn(int column) {
        this.sheet.autoSizeColumn(column);
    }

    public void autoSizeColumn(int column, boolean useMergedCells) {
        this.sheet.autoSizeColumn(column, useMergedCells);
    }

    public Comment getCellComment(int row, int column) {
        return this.sheet.getCellComment(new CellAddress(row, column));
    }

    public Drawing<?> createDrawingPatriarch() {
        return this.sheet.createDrawingPatriarch();
    }

    public Workbook getWorkbook() {
        return this.sheet.getWorkbook();
    }

    public String getSheetName() {
        return this.sheet.getSheetName();
    }

    public boolean isSelected() {
        return this.sheet.isSelected();
    }

    public CellRange<? extends Cell> setArrayFormula(String formula, CellRangeAddress range) {
        return this.sheet.setArrayFormula(formula, range);
    }

    public CellRange<? extends Cell> removeArrayFormula(Cell cell) {
        return this.sheet.removeArrayFormula(cell);
    }

    public DataValidationHelper getDataValidationHelper() {
        return this.sheet.getDataValidationHelper();
    }

    public void addValidationData(DataValidation dataValidation) {
        this.sheet.addValidationData(dataValidation);
    }

    public AutoFilter setAutoFilter(CellRangeAddress range) {
        return this.sheet.setAutoFilter(range);
    }

    public SheetConditionalFormatting getSheetConditionalFormatting() {
        return this.sheet.getSheetConditionalFormatting();
    }

    public float getColumnWidthInPixels(int columnIndex) {
        return this.sheet.getColumnWidthInPixels(columnIndex);
    }

    public int addMergedRegionUnsafe(CellRangeAddress region) {
        return this.sheet.addMergedRegionUnsafe(region);
    }

    public void validateMergedRegions() {
        this.sheet.validateMergedRegions();
    }

    public void removeMergedRegions(Collection<Integer> indices) {
        this.sheet.removeMergedRegions(indices);
    }

    public List<CellRangeAddress> getMergedRegions() {
        return this.sheet.getMergedRegions();
    }

    public boolean isPrintRowAndColumnHeadings() {
        return this.sheet.isPrintRowAndColumnHeadings();
    }

    public void setPrintRowAndColumnHeadings(boolean show) {
        this.sheet.setPrintRowAndColumnHeadings(show);
    }

    public void setZoom(int scale) {
        this.sheet.setZoom(scale);
    }

    public void showInPane(int toprow, int leftcol) {
        this.sheet.showInPane(toprow, leftcol);
    }

    public void shiftColumns(int startColumn, int endColumn, int n) {
        this.sheet.shiftColumns(startColumn, endColumn, n);
    }

    public Comment getCellComment(CellAddress ref) {
        return this.sheet.getCellComment(ref);
    }

    public Map<CellAddress, ? extends Comment> getCellComments() {
        return this.sheet.getCellComments();
    }

    public Drawing<?> getDrawingPatriarch() {
        return this.sheet.getDrawingPatriarch();
    }

    public List<? extends DataValidation> getDataValidations() {
        return this.sheet.getDataValidations();
    }

    public int getColumnOutlineLevel(int columnIndex) {
        return this.sheet.getColumnOutlineLevel(columnIndex);
    }

    public Hyperlink getHyperlink(int row, int column) {
        return this.sheet.getHyperlink(row, column);
    }

    public Hyperlink getHyperlink(CellAddress addr) {
        return this.sheet.getHyperlink(addr);
    }

    public List<? extends Hyperlink> getHyperlinkList() {
        return this.sheet.getHyperlinkList();
    }

    public CellAddress getActiveCell() {
        return this.sheet.getActiveCell();
    }

    public void setActiveCell(CellAddress address) {
        this.sheet.setActiveCell(address);
    }

    public double getMargin(PageMargin margin) {
        return this.sheet.getMargin(margin);
    }

    public void setMargin(PageMargin margin, double size) {
        this.sheet.setMargin(margin, size);
    }

    public void createSplitPane(int xSplitPos, int ySplitPos, int leftmostColumn, int topRow, PaneType activePane) {
        this.sheet.createSplitPane(xSplitPos, ySplitPos, leftmostColumn, topRow, activePane);
    }

    private class FilteredIterator
    implements Iterator<Row> {
        private Iterator<Row> iter;
        private int minRow;
        private int maxRow;
        private Row cur;

        public FilteredIterator(Iterator<Row> iter, int minRow, int maxRow) {
            this.iter = iter;
            this.minRow = minRow;
            this.maxRow = maxRow;
        }

        @Override
        public boolean hasNext() {
            if (this.iter.hasNext()) {
                this.cur = this.iter.next();
                while (this.cur.getRowNum() < this.minRow) {
                    if (!this.iter.hasNext()) {
                        return false;
                    }
                    this.cur = this.iter.next();
                }
                return this.cur.getRowNum() <= this.maxRow;
            }
            return false;
        }

        @Override
        public Row next() {
            return this.cur;
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

