/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel.handlers;

import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.util.CellReference;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyledElement;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.w3c.dom.css.CSSValue;
import uk.co.spudsoft.birt.emitters.excel.HandlerState;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;
import uk.co.spudsoft.birt.emitters.excel.handlers.IHandler;

public class AbstractHandler
implements IHandler {
    protected Logger log;
    protected IContent element;
    protected IHandler parent;
    private CSSValue backgroundColour;

    public AbstractHandler(Logger log, IHandler parent, IContent element) {
        this.log = log;
        this.parent = parent;
        this.element = element;
    }

    @Override
    public void notifyHandler(HandlerState state) {
    }

    @Override
    public String getPath() {
        if (this.parent != null) {
            return this.getClass().getSimpleName() + "/" + this.parent.getPath();
        }
        return this.getClass().getSimpleName();
    }

    @Override
    public IHandler getParent() {
        return this.parent;
    }

    @Override
    public <T extends IHandler> T getAncestor(Class<T> clazz) {
        if (this.parent != null) {
            if (clazz.isInstance(this.parent)) {
                return (T)this.parent;
            }
            return this.parent.getAncestor(clazz);
        }
        return null;
    }

    @Override
    public CSSValue getBackgroundColour() {
        CSSValue elemColour;
        if (this.backgroundColour != null) {
            return this.backgroundColour;
        }
        if (this.element != null && (elemColour = this.element.getComputedStyle().getProperty(40)) != null && !"transparent".equals(elemColour.getCssText())) {
            this.backgroundColour = elemColour;
        }
        if (this.parent != null && this.backgroundColour == null) {
            this.backgroundColour = this.parent.getBackgroundColour();
        }
        return this.backgroundColour;
    }

    protected static String getStyleProperty(IStyledElement element, int property, String defaultValue) {
        CSSValue value = element.getComputedStyle().getProperty(property);
        if (value != null) {
            return value.getCssText();
        }
        return defaultValue;
    }

    protected static String prepareName(String name) {
        CellReference.NameType refType;
        boolean requirePreparation;
        char c = ((String)name).charAt(0);
        boolean bl = requirePreparation = c != '_' && !Character.isLetter(c) || ((String)name).indexOf(32) != -1;
        if (!requirePreparation) {
            int i = 1;
            while (i < ((String)name).length()) {
                c = ((String)name).charAt(i);
                if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_') {
                    requirePreparation = true;
                    break;
                }
                ++i;
            }
        }
        if (requirePreparation) {
            name = ((String)name).trim();
            char[] chars = ((String)name).toCharArray();
            int i = 0;
            while (i < ((String)name).length()) {
                c = chars[i];
                if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_') {
                    chars[i] = 95;
                }
                ++i;
            }
            name = new String(chars);
        }
        if (CellReference.NameType.CELL == (refType = CellReference.classifyCellReference((String)name, (SpreadsheetVersion)SpreadsheetVersion.EXCEL2007)) || CellReference.NameType.COLUMN == refType || CellReference.NameType.ROW == refType) {
            name = "_" + (String)name;
        }
        return name;
    }

    protected void createName(HandlerState state, String bookmark, int row1, int col1, int row2, int col2) {
        CellReference crFirst = new CellReference(state.currentSheet.getSheetName(), row1, col1, true, true);
        CellReference crLast = new CellReference(row2, col2, true, true);
        String formula = crFirst.formatAsString() + ":" + crLast.formatAsString();
        Name name = state.currentSheet.getWorkbook().getName(bookmark);
        if (name == null) {
            name = state.currentSheet.getWorkbook().createName();
            name.setNameName(bookmark);
            name.setRefersToFormula(formula);
        } else {
            String existingFormula = name.getRefersToFormula();
            try {
                name.setRefersToFormula(existingFormula + "," + formula);
            }
            catch (FormulaParseException ex) {
                this.log.warn(0, "Unable to add \"" + formula + "\" to name (\"" + bookmark + "\") with existing formula: " + existingFormula, ex);
            }
        }
    }

    @Override
    public void startPage(HandlerState state, IPageContent page) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".startPage");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }

    @Override
    public void endPage(HandlerState state, IPageContent page) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".endPage");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }

    @Override
    public void startTable(HandlerState state, ITableContent table) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".startTable");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }

    @Override
    public void endTable(HandlerState state, ITableContent table) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".endTable");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }

    @Override
    public void startTableBand(HandlerState state, ITableBandContent band) throws BirtException {
    }

    @Override
    public void endTableBand(HandlerState state, ITableBandContent band) throws BirtException {
    }

    @Override
    public void startRow(HandlerState state, IRowContent row) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".startRow");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }

    @Override
    public void endRow(HandlerState state, IRowContent row) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".endRow");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }

    @Override
    public void startCell(HandlerState state, ICellContent cell) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".startCell");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }

    @Override
    public void endCell(HandlerState state, ICellContent cell) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".endCell");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }

    @Override
    public void startList(HandlerState state, IListContent list) throws BirtException {
    }

    @Override
    public void endList(HandlerState state, IListContent list) throws BirtException {
    }

    @Override
    public void startListBand(HandlerState state, IListBandContent listBand) throws BirtException {
    }

    @Override
    public void endListBand(HandlerState state, IListBandContent listBand) throws BirtException {
    }

    @Override
    public void startContainer(HandlerState state, IContainerContent container) throws BirtException {
    }

    @Override
    public void endContainer(HandlerState state, IContainerContent container) throws BirtException {
    }

    @Override
    public void startContent(HandlerState state, IContent content) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".startContent");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }

    @Override
    public void endContent(HandlerState state, IContent content) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".endContent");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }

    @Override
    public void startGroup(HandlerState state, IGroupContent group) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".startGroup");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }

    @Override
    public void endGroup(HandlerState state, IGroupContent group) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".endGroup");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }

    @Override
    public void startTableGroup(HandlerState state, ITableGroupContent group) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".startTableGroup");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }

    @Override
    public void endTableGroup(HandlerState state, ITableGroupContent group) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".endTableGroup");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }

    @Override
    public void startListGroup(HandlerState state, IListGroupContent group) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".startListGroup");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }

    @Override
    public void endListGroup(HandlerState state, IListGroupContent group) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".endListGroup");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }

    @Override
    public void emitText(HandlerState state, ITextContent text) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".emitText");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }

    @Override
    public void emitData(HandlerState state, IDataContent data) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".emitData");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }

    @Override
    public void emitLabel(HandlerState state, ILabelContent label) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".emitLabel");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }

    @Override
    public void emitAutoText(HandlerState state, IAutoTextContent autoText) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".emitAutoText");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }

    @Override
    public void emitForeign(HandlerState state, IForeignContent foreign) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".emitForeign");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }

    @Override
    public void emitImage(HandlerState state, IImageContent image) throws BirtException {
        NoSuchMethodError ex = new NoSuchMethodError("Method not implemented: " + this.getClass().getSimpleName() + ".emitImage");
        this.log.error(0, "Method not implemented", ex);
        throw ex;
    }
}

