/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel.handlers;

import org.apache.poi.ss.usermodel.Cell;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IStyledElement;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.layout.pdf.util.HTML2Content;
import uk.co.spudsoft.birt.emitters.excel.Coordinate;
import uk.co.spudsoft.birt.emitters.excel.HandlerState;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;
import uk.co.spudsoft.birt.emitters.excel.handlers.CellContentHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.IHandler;

public class TopLevelContentHandler
extends CellContentHandler {
    public TopLevelContentHandler(IContentEmitter emitter, Logger log, IHandler parent) {
        super(emitter, log, parent, null);
    }

    @Override
    public void emitText(HandlerState state, ITextContent text) throws BirtException {
        this.log.debug("Creating row ", state.rowNum, " for text");
        state.currentSheet.createRow(state.rowNum);
        this.emitContent(state, (IContent)text, text.getText(), !"inline".equals(TopLevelContentHandler.getStyleProperty((IStyledElement)text, 65, "block")));
        Cell currentCell = state.currentSheet.getRow(state.rowNum).createCell(0);
        currentCell.setBlank();
        this.endCellContent(state, null, (IContent)text, currentCell, null);
        ++state.rowNum;
        state.setHandler(this.parent);
    }

    @Override
    public void emitData(HandlerState state, IDataContent data) throws BirtException {
        this.log.debug("Creating row ", state.rowNum, " for data");
        state.currentSheet.createRow(state.rowNum);
        this.emitContent(state, (IContent)data, data.getValue(), !"inline".equals(TopLevelContentHandler.getStyleProperty((IStyledElement)data, 65, "block")));
        Cell currentCell = state.currentSheet.getRow(state.rowNum).createCell(0);
        currentCell.setBlank();
        this.endCellContent(state, null, (IContent)data, currentCell, null);
        ++state.rowNum;
        state.setHandler(this.parent);
    }

    @Override
    public void emitLabel(HandlerState state, ILabelContent label) throws BirtException {
        this.log.debug("Creating row ", state.rowNum, " for label");
        state.currentSheet.createRow(state.rowNum);
        String labelText = label.getLabelText() != null ? label.getLabelText() : label.getText();
        this.emitContent(state, (IContent)label, labelText, !"inline".equals(TopLevelContentHandler.getStyleProperty((IStyledElement)label, 65, "block")));
        Cell currentCell = state.currentSheet.getRow(state.rowNum).createCell(0);
        currentCell.setBlank();
        this.endCellContent(state, null, (IContent)label, currentCell, null);
        ++state.rowNum;
        state.setHandler(this.parent);
    }

    @Override
    public void emitForeign(HandlerState state, IForeignContent foreign) throws BirtException {
        this.log.debug("Handling foreign content of type ", foreign.getRawType());
        if ("text/html".equalsIgnoreCase(foreign.getRawType())) {
            HTML2Content.html2Content((IForeignContent)foreign);
            this.contentVisitor.visitChildren((IContent)foreign, null);
        }
        state.setHandler(this.parent);
    }

    @Override
    public void emitImage(HandlerState state, IImageContent image) throws BirtException {
        this.log.debug("Creating row ", state.rowNum, " for image");
        state.currentSheet.createRow(state.rowNum);
        this.recordImage(state, new Coordinate(state.rowNum, 0), image, true);
        Cell currentCell = state.currentSheet.getRow(state.rowNum).createCell(0);
        currentCell.setBlank();
        this.endCellContent(state, null, (IContent)image, currentCell, null);
        ++state.rowNum;
        state.setHandler(this.parent);
    }
}

