/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.withaxes.AxisSubUnit;
import org.eclipse.birt.chart.computation.withaxes.StackGroup;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.util.SecurityUtil;
import org.eclipse.emf.common.util.EList;

public final class StackedSeriesLookup {
    private final Hashtable<Axis, List<StackGroup>> htAxisToStackGroups = SecurityUtil.newHashtable();
    private final Hashtable<Series, StackGroup> htSeriesToStackGroup = SecurityUtil.newHashtable();
    private int iCachedUnitCount = 0;

    StackedSeriesLookup(RunTimeContext rtc) {
    }

    public List<StackGroup> getStackGroups(Axis ax) {
        return this.htAxisToStackGroups.get(ax);
    }

    public int getSeriesCount(Axis ax) {
        List<StackGroup> alSG = this.htAxisToStackGroups.get(ax);
        if (alSG == null || alSG.isEmpty()) {
            return 0;
        }
        int iCount = 0;
        int i = 0;
        while (i < alSG.size()) {
            StackGroup sg = alSG.get(i);
            iCount += sg.alSeries.size();
            ++i;
        }
        return iCount;
    }

    public StackGroup getStackGroup(Series se) {
        return this.htSeriesToStackGroup.get(se);
    }

    public AxisSubUnit getSubUnit(StackGroup sg, int iUnitIndex) {
        if (sg == null || !this.htSeriesToStackGroup.contains(sg)) {
            return null;
        }
        if (sg.alUnitPositions == null) {
            sg.alUnitPositions = new ArrayList(8);
        }
        if (sg.alUnitPositions.size() <= iUnitIndex) {
            sg.alUnitPositions.add(new AxisSubUnit(sg.bStackTogether));
        }
        return sg.alUnitPositions.get(iUnitIndex);
    }

    public AxisSubUnit getUnit(Series se, int iUnitIndex) {
        StackGroup sg = this.htSeriesToStackGroup.get(se);
        return this.getSubUnit(sg, iUnitIndex);
    }

    public void resetSubUnits() {
        Enumeration<StackGroup> e = this.htSeriesToStackGroup.elements();
        while (e.hasMoreElements()) {
            StackGroup sg = e.nextElement();
            if (sg.alUnitPositions == null) continue;
            int i = 0;
            while (i < sg.alUnitPositions.size()) {
                AxisSubUnit asu = sg.alUnitPositions.get(i);
                asu.reset();
                ++i;
            }
        }
    }

    public static StackedSeriesLookup create(ChartWithAxes cwa, RunTimeContext rtc) throws ChartException, IllegalArgumentException {
        if (cwa == null) {
            return null;
        }
        StackedSeriesLookup ssl = new StackedSeriesLookup(rtc);
        Axis axBase = cwa.getBaseAxes()[0];
        Axis[] axaOrthogonal = cwa.getOrthogonalAxes(axBase, true);
        DataSetIterator dsi = null;
        int i = 0;
        while (i < axaOrthogonal.length) {
            StackGroup sg;
            int iSharedUnitIndex = 0;
            int iSharedUnitCount = 0;
            StackGroup sgSingle = null;
            EList<SeriesDefinition> sdList = axaOrthogonal[i].getSeriesDefinitions();
            ArrayList<StackGroup> alSGCopies = new ArrayList<StackGroup>(4);
            iSharedUnitCount = 0;
            for (SeriesDefinition sd : sdList) {
                int iDataSetCount;
                Series se;
                int k;
                List<Series> alSeries = sd.getRunTimeSeries();
                int iSeriesCount = alSeries.size();
                if (iSeriesCount > 1) {
                    boolean bStackedSet = false;
                    sg = null;
                    k = 0;
                    while (k < iSeriesCount) {
                        se = alSeries.get(k);
                        dsi = new DataSetIterator(se.getDataSet());
                        iDataSetCount = dsi.size();
                        if (ssl.iCachedUnitCount == 0) {
                            ssl.iCachedUnitCount = iDataSetCount;
                        } else if (ssl.iCachedUnitCount != iDataSetCount) {
                            throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(rtc.getULocale()).getString("exception.runtime.dataset.count.mismatch"), ssl.iCachedUnitCount, iDataSetCount));
                        }
                        if (se.canBeStacked()) {
                            if (se.canShareAxisUnit()) {
                                if (se.isStacked()) {
                                    if (k > 0 && !bStackedSet) {
                                        throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(rtc.getULocale()).getString("exception.stacked.unstacked.mix.series"), sd));
                                    }
                                    if (k == 0) {
                                        sg = new StackGroup(iSharedUnitIndex++);
                                        alSGCopies.add(sg);
                                        ++iSharedUnitCount;
                                    }
                                    bStackedSet = true;
                                    ssl.htSeriesToStackGroup.put(se, sg);
                                    sg.addSeries(se);
                                } else {
                                    if (k > 0 && bStackedSet) {
                                        throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(rtc.getULocale()).getString("exception.stacked.unstacked.mix.series"), sd));
                                    }
                                    if (StackedSeriesLookup.canSideBySide(se)) {
                                        sg = new StackGroup(iSharedUnitIndex++);
                                        alSGCopies.add(sg);
                                        ++iSharedUnitCount;
                                        ssl.htSeriesToStackGroup.put(se, sg);
                                        sg.addSeries(se);
                                    }
                                }
                            } else if (se.isStacked()) {
                                if (k > 0 && !bStackedSet) {
                                    throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(rtc.getULocale()).getString("exception.stacked.unstacked.mix.series"), sd));
                                }
                                if (k == 0) {
                                    sg = new StackGroup(-1);
                                    alSGCopies.add(sg);
                                }
                                bStackedSet = true;
                                ssl.htSeriesToStackGroup.put(se, sg);
                                sg.addSeries(se);
                            } else {
                                if (k > 0 && bStackedSet) {
                                    throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(rtc.getULocale()).getString("exception.stacked.unstacked.mix.series"), sd));
                                }
                                sg = new StackGroup(-1);
                                alSGCopies.add(sg);
                                ssl.htSeriesToStackGroup.put(se, sg);
                                sg.addSeries(se);
                            }
                        } else if (se.canShareAxisUnit()) {
                            sg = new StackGroup(iSharedUnitIndex++);
                            alSGCopies.add(sg);
                            ++iSharedUnitCount;
                            ssl.htSeriesToStackGroup.put(se, sg);
                            sg.addSeries(se);
                        } else {
                            sg = new StackGroup(-1);
                            alSGCopies.add(sg);
                            ssl.htSeriesToStackGroup.put(se, sg);
                            sg.addSeries(se);
                        }
                        ++k;
                    }
                    continue;
                }
                k = 0;
                while (k < iSeriesCount) {
                    se = alSeries.get(k);
                    dsi = new DataSetIterator(se.getDataSet());
                    iDataSetCount = dsi.size();
                    if (ssl.iCachedUnitCount == 0) {
                        ssl.iCachedUnitCount = iDataSetCount;
                    } else if (ssl.iCachedUnitCount != iDataSetCount) {
                        throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(rtc.getULocale()).getString("exception.runtime.dataset.count.mismatch"), ssl.iCachedUnitCount, iDataSetCount));
                    }
                    if (se.canBeStacked()) {
                        if (se.canShareAxisUnit()) {
                            if (se.isStacked()) {
                                if (sgSingle == null) {
                                    sgSingle = new StackGroup(iSharedUnitIndex++);
                                    alSGCopies.add(sgSingle);
                                    ++iSharedUnitCount;
                                }
                                ssl.htSeriesToStackGroup.put(se, sgSingle);
                                sgSingle.addSeries(se);
                            } else if (StackedSeriesLookup.canSideBySide(se)) {
                                sg = new StackGroup(iSharedUnitIndex++);
                                ++iSharedUnitCount;
                                alSGCopies.add(sg);
                                ssl.htSeriesToStackGroup.put(se, sg);
                                sg.addSeries(se);
                            }
                        } else {
                            sg = new StackGroup(-1);
                            alSGCopies.add(sg);
                            ssl.htSeriesToStackGroup.put(se, sg);
                            sg.addSeries(se);
                        }
                    } else {
                        sg = new StackGroup(-1);
                        alSGCopies.add(sg);
                        ssl.htSeriesToStackGroup.put(se, sg);
                        sg.addSeries(se);
                    }
                    ++k;
                }
            }
            if (iSharedUnitCount < 1) {
                iSharedUnitCount = 1;
            }
            int j = 0;
            while (j < alSGCopies.size()) {
                sg = (StackGroup)alSGCopies.get(j);
                sg.updateCount(iSharedUnitCount);
                ++j;
            }
            ssl.htAxisToStackGroups.put(axaOrthogonal[i], alSGCopies);
            ++i;
        }
        return ssl;
    }

    public int getUnitCount() {
        return this.iCachedUnitCount;
    }

    private static boolean canSideBySide(Series se) {
        return se instanceof BarSeries || se instanceof StockSeries;
    }
}

