/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.aggregate;

import java.math.BigDecimal;
import org.eclipse.birt.chart.aggregate.AggregateFunctionAdapter;

public class Range
extends AggregateFunctionAdapter {
    private Object max;
    private Object min;

    @Override
    public void accumulate(Object oValue) throws IllegalArgumentException {
        if (this.max == null) {
            this.max = oValue;
            this.min = oValue;
        } else if (oValue instanceof Comparable) {
            this.max = ((Comparable)oValue).compareTo(this.max) >= 0 ? oValue : this.max;
            this.min = ((Comparable)oValue).compareTo(this.min) <= 0 ? oValue : this.min;
        }
    }

    @Override
    public Object getAggregatedValue() {
        switch (this.getDataType()) {
            case 4: {
                return new Double(((Number)this.max).doubleValue() - ((Number)this.min).doubleValue());
            }
            case 5: {
                return ((BigDecimal)this.max).subtract((BigDecimal)this.min);
            }
        }
        return null;
    }

    @Override
    public void initialize() {
        this.max = null;
        this.min = null;
    }

    @Override
    public int getBIRTDataType() {
        return 3;
    }
}

