/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.group;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.group.DayGroupCalculator;
import org.eclipse.birt.data.engine.impl.group.DecimalGroupCalculator;
import org.eclipse.birt.data.engine.impl.group.HourGroupCalculator;
import org.eclipse.birt.data.engine.impl.group.ICalculator;
import org.eclipse.birt.data.engine.impl.group.MinuteGroupCalculator;
import org.eclipse.birt.data.engine.impl.group.MonthGroupCalculator;
import org.eclipse.birt.data.engine.impl.group.NumericGroupCalculator;
import org.eclipse.birt.data.engine.impl.group.QuarterGroupCalculator;
import org.eclipse.birt.data.engine.impl.group.SecondGroupCalculator;
import org.eclipse.birt.data.engine.impl.group.StringGroupCalculator;
import org.eclipse.birt.data.engine.impl.group.WeekGroupCalculator;
import org.eclipse.birt.data.engine.impl.group.YearGroupCalculator;

public class GroupCalculatorFactory {
    public static ICalculator getGroupCalculator(int interval, Object intervalStart, double intervalRange, int dataType, ULocale locale, TimeZone timeZone) throws DataException {
        GroupCalculatorFactory.validateInterval(interval, dataType);
        GroupCalculatorFactory.validateIntervalRange(intervalRange);
        try {
            switch (interval) {
                case 1: {
                    return new YearGroupCalculator(intervalStart, intervalRange, locale, timeZone);
                }
                case 2: {
                    return new MonthGroupCalculator(intervalStart, intervalRange, locale, timeZone);
                }
                case 3: {
                    return new QuarterGroupCalculator(intervalStart, intervalRange, locale, timeZone);
                }
                case 4: {
                    return new WeekGroupCalculator(intervalStart, intervalRange, locale, timeZone);
                }
                case 5: {
                    return new DayGroupCalculator(intervalStart, intervalRange, locale, timeZone);
                }
                case 6: {
                    return new HourGroupCalculator(intervalStart, intervalRange, locale, timeZone);
                }
                case 7: {
                    return new MinuteGroupCalculator(intervalStart, intervalRange, locale, timeZone);
                }
                case 8: {
                    return new SecondGroupCalculator(intervalStart, intervalRange, locale, timeZone);
                }
                case 99: {
                    if (dataType == 4) {
                        return new DecimalGroupCalculator(intervalStart, intervalRange);
                    }
                    return new NumericGroupCalculator(intervalStart, intervalRange);
                }
                case 100: {
                    return new StringGroupCalculator(intervalStart, intervalRange);
                }
            }
            throw new DataException("data.engine.group.interval.invalid");
        }
        catch (BirtException be) {
            throw DataException.wrap(be);
        }
    }

    private static void validateInterval(int interval, int dataType) throws DataException {
        if (interval != 0 && interval != 99 && interval != 100 && interval != 8 && interval != 7 && interval != 6 && interval != 5 && interval != 4 && interval != 2 && interval != 3 && interval != 1) {
            throw new DataException("data.engine.group.interval.invalid");
        }
        if (dataType == 0 || dataType == -1) {
            return;
        }
        switch (interval) {
            case 0: {
                return;
            }
            case 99: {
                if (GroupCalculatorFactory.isNumber(dataType)) {
                    return;
                }
                throw new DataException("data.engine.group.interval", new Object[]{"numeric", DataType.getName(dataType)});
            }
            case 100: {
                if (GroupCalculatorFactory.isString(dataType)) {
                    return;
                }
                throw new DataException("data.engine.group.interval", new Object[]{"string prefix", DataType.getName(dataType)});
            }
        }
        if (!GroupCalculatorFactory.canBeConvertToDate(dataType)) {
            throw new DataException("data.engine.group.interval", new Object[]{"date", DataType.getName(dataType)});
        }
    }

    private static void validateIntervalRange(double intervalRange) throws DataException {
        if (intervalRange < 0.0) {
            throw new DataException("data.engine.group.intervalRange.invalid", new Double(intervalRange));
        }
    }

    private static boolean isNumber(int dataType) {
        return dataType == 4 || dataType == 3 || dataType == 2;
    }

    private static boolean canBeConvertToDate(int dataType) {
        return dataType == 6 || dataType == 9 || dataType == 10 || dataType == 5;
    }

    private static boolean isString(int dataType) {
        return dataType == 5;
    }
}

