/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util.filter;

import java.util.Set;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.util.CompareUtil;
import org.eclipse.birt.data.engine.olap.util.IJSObjectPopulator;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.filter.BaseDimensionFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IJSTopBottomFilterHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IResultRow;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Scriptable;

public class TopBottomDimensionFilterEvalHelper
extends BaseDimensionFilterEvalHelper
implements IJSTopBottomFilterHelper {
    private double N;
    private int filterType;
    private boolean isTop;
    private boolean isPercent;

    public TopBottomDimensionFilterEvalHelper(IBaseQueryResults outResults, Scriptable parentScope, ICubeQueryDefinition queryDefn, IFilterDefinition cubeFilter, ScriptContext cx) throws DataException {
        assert (cubeFilter != null);
        this.initialize(outResults, parentScope, queryDefn, cubeFilter, cx);
        this.populateN(cx);
        this.popualteFilterType();
        this.argumentCheck();
    }

    private void argumentCheck() throws DataException {
        if (this.isPercent) {
            if (this.N < 0.0 || this.N > 100.0) {
                throw new DataException("data.engine.InvalidTopBottomPercentArgument");
            }
        } else if (this.N < 0.0) {
            throw new DataException("data.engine.InvalidTopBottomNArgument");
        }
    }

    private void populateN(ScriptContext cx) throws DataException {
        Object o = ScriptEvalUtil.evalExpr(((IConditionalExpression)this.expr).getOperand1(), cx.newContext(this.scope), ScriptExpression.defaultID, 0);
        this.N = Double.parseDouble(o.toString());
    }

    private void popualteFilterType() {
        int type = ((IConditionalExpression)this.expr).getOperator();
        switch (type) {
            case 14: {
                this.filterType = 1;
                this.isTop = true;
                this.isPercent = false;
                break;
            }
            case 16: {
                this.filterType = 3;
                this.isTop = true;
                this.isPercent = true;
                break;
            }
            case 15: {
                this.filterType = 2;
                this.isTop = false;
                this.isPercent = false;
                break;
            }
            case 17: {
                this.filterType = 4;
                this.isTop = false;
                this.isPercent = true;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public Object evaluateFilterExpr(IResultRow resultRow) throws DataException {
        super.setData(resultRow);
        try {
            Object result = ScriptEvalUtil.evalExpr(((IConditionalExpression)this.expr).getExpression(), this.cx.newContext(this.scope), ScriptExpression.defaultID, 0);
            return result;
        }
        catch (IJSObjectPopulator.InMatchDimensionIndicator e) {
            throw new DataException(e.getMessage());
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    @Override
    public DimLevel getTargetLevel() throws DataException {
        Set set = OlapExpressionCompiler.getReferencedDimLevel(this.expr, this.queryDefn.getBindings());
        if (set.size() != 1) {
            throw new DataException("data.olap.sort.exprError");
        }
        DimLevel result = (DimLevel)set.iterator().next();
        return result;
    }

    @Override
    public int getFilterType() {
        return this.filterType;
    }

    @Override
    public double getN() {
        return this.N;
    }

    @Override
    public boolean isQualifiedRow(IResultRow resultRow) throws DataException {
        if (this.isAxisFilter) {
            int i = 0;
            while (i < this.axisLevels.length) {
                DimLevel level = new DimLevel(this.axisLevels[i]);
                if (CompareUtil.compare(resultRow.getFieldValue(level.toString()), this.axisValues[i]) != 0) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public boolean isPercent() {
        return this.isPercent;
    }

    @Override
    public boolean isTop() {
        return this.isTop;
    }
}

