/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re;

import org.eclipse.birt.report.engine.extension.ExtendedItemFactoryBase;
import org.eclipse.birt.report.engine.extension.IExtendedItem;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.re.CrosstabCellExtendedItem;
import org.eclipse.birt.report.item.crosstab.core.re.CrosstabExtendedItem;
import org.eclipse.birt.report.item.crosstab.core.script.internal.handler.CrosstabHandlerCache;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;

public class CrosstabExtendedItemFactory
extends ExtendedItemFactoryBase
implements ICrosstabConstants {
    private CrosstabHandlerCache handlerCache;
    private CrosstabExtendedItem crosstabSingleton;
    private CrosstabCellExtendedItem crosstabCellSingleton;

    @Override
    public IExtendedItem createExtendedItem(ExtendedItemHandle handle) {
        String exName = handle.getExtensionName();
        if ("Crosstab".equals(exName)) {
            if (this.crosstabSingleton == null) {
                this.crosstabSingleton = new CrosstabExtendedItem();
            }
            return this.crosstabSingleton;
        }
        if ("CrosstabCell".equals(exName) || "AggregationCell".equals(exName)) {
            if (this.crosstabCellSingleton == null) {
                this.handlerCache = new CrosstabHandlerCache();
                this.crosstabCellSingleton = new CrosstabCellExtendedItem(this.handlerCache);
            }
            return this.crosstabCellSingleton;
        }
        return super.createExtendedItem(handle);
    }

    @Override
    public void release() {
        if (this.crosstabSingleton != null) {
            this.crosstabSingleton.release();
            this.crosstabSingleton = null;
        }
        if (this.crosstabCellSingleton != null) {
            this.handlerCache.dispose();
            this.handlerCache = null;
            this.crosstabCellSingleton.release();
            this.crosstabCellSingleton = null;
        }
        super.release();
    }
}

