/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IOdaDataSetDesign;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.CustomField;
import org.eclipse.birt.data.engine.executor.DataSource;
import org.eclipse.birt.data.engine.executor.ParameterBinding;
import org.eclipse.birt.data.engine.executor.ParameterMetaData;
import org.eclipse.birt.data.engine.executor.QueryExecutionStrategyUtil;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.dscache.DataSetToCache;
import org.eclipse.birt.data.engine.executor.transform.CachedResultSet;
import org.eclipse.birt.data.engine.executor.transform.SimpleResultSet;
import org.eclipse.birt.data.engine.impl.CancelManager;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.ICancellable;
import org.eclipse.birt.data.engine.impl.IQueryContextVisitor;
import org.eclipse.birt.data.engine.impl.QueryContextVisitorUtil;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.odaconsumer.ColumnHint;
import org.eclipse.birt.data.engine.odaconsumer.ParameterHint;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.birt.data.engine.odaconsumer.QuerySpecHelper;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.IDataSourceQuery;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IParameterMetaData;
import org.eclipse.birt.data.engine.odi.IPreparedDSQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.eclipse.datatools.connectivity.oda.spec.basequery.CombinedQuery;

public class DataSourceQuery
extends BaseQuery
implements IDataSourceQuery,
IPreparedDSQuery {
    protected DataSource dataSource;
    protected String queryText;
    protected String queryType;
    protected PreparedStatement odaStatement;
    protected Collection resultHints;
    protected Collection customFields;
    protected IResultClass resultMetadata;
    protected String[] projectedFields;
    private Collection parameterHints;
    private QuerySpecification querySpecificaton;
    private Collection inputParamValues;
    private ArrayList<String> propNames;
    private ArrayList propValues;
    private DataEngineSession session;
    private IQueryContextVisitor qcv;
    private static Logger logger = Logger.getLogger(DataSourceQuery.class.getName());

    DataSourceQuery(DataSource dataSource, String queryType, String queryText, DataEngineSession session, IQueryContextVisitor qcv) {
        this.dataSource = dataSource;
        this.queryText = queryText;
        this.queryType = queryType;
        this.session = session;
        this.qcv = qcv;
    }

    @Override
    public void setResultHints(Collection columnDefns) {
        this.resultHints = columnDefns;
    }

    @Override
    public void setResultProjection(String[] fieldNames) throws DataException {
        if (fieldNames == null || fieldNames.length == 0) {
            return;
        }
        this.projectedFields = fieldNames;
    }

    @Override
    public void setParameterHints(Collection parameterHints) {
        this.parameterHints = parameterHints;
    }

    @Override
    public void addProperty(String name, String value) throws DataException {
        if (name == null) {
            throw new NullPointerException("Property name is null");
        }
        if (this.odaStatement != null) {
            throw new DataException("data.engine.QueryAlreadyPrepared");
        }
        if (this.propNames == null) {
            assert (this.propValues == null);
            this.propNames = new ArrayList();
            this.propValues = new ArrayList();
        }
        assert (this.propValues != null);
        this.propNames.add(name);
        this.propValues.add(value);
    }

    @Override
    public void declareCustomField(String fieldName, int dataType) throws DataException {
        if (fieldName == null || fieldName.length() == 0) {
            throw new DataException("data.engine.EmptyCustomFieldName");
        }
        if (this.customFields == null) {
            this.customFields = new ArrayList();
        } else {
            for (CustomField cf : this.customFields) {
                if (!cf.name.equals(fieldName)) continue;
                throw new DataException("data.engine.DupCustomFieldName", fieldName);
            }
        }
        this.customFields.add(new CustomField(fieldName, dataType));
    }

    @Override
    public IPreparedDSQuery prepare() throws DataException {
        long start = System.currentTimeMillis();
        if (this.odaStatement != null) {
            throw new DataException("data.engine.QueryAlreadyPrepared");
        }
        this.populateQuerySpecification();
        this.odaStatement = this.querySpecificaton != null && this.querySpecificaton.getBaseQuery() instanceof CombinedQuery ? this.dataSource.prepareStatement(null, this.queryType, this.querySpecificaton) : this.dataSource.prepareStatement(this.queryText, this.queryType, this.querySpecificaton);
        this.addPropertiesToPreparedStatement();
        this.addParameterDefns();
        this.odaStatement.setMaxRows(this.getRowFetchLimit());
        IOdaDataSetDesign design = null;
        if (this.session.getDataSetCacheManager().getCurrentDataSetDesign() instanceof IOdaDataSetDesign) {
            design = (IOdaDataSetDesign)this.session.getDataSetCacheManager().getCurrentDataSetDesign();
        }
        OdaQueryCanceller queryCanceller = new OdaQueryCanceller(this.odaStatement, this.dataSource, this.session.getStopSign(), this);
        if (design != null) {
            if (this.canAccessResultSetByName(design)) {
                this.addCustomFields(design.getPrimaryResultSetName(), this.odaStatement);
                this.addColumnHints(design.getPrimaryResultSetName(), this.odaStatement);
                if (this.projectedFields != null) {
                    this.odaStatement.setColumnsProjection(design.getPrimaryResultSetName(), this.projectedFields);
                }
            } else if (this.canAccessResultSetByNumber(design)) {
                this.addCustomFields(design.getPrimaryResultSetNumber(), this.odaStatement);
                this.addColumnHints(design.getPrimaryResultSetNumber(), this.odaStatement);
                if (this.projectedFields != null) {
                    this.odaStatement.setColumnsProjection(design.getPrimaryResultSetNumber(), this.projectedFields);
                }
            } else {
                this.session.getCancelManager().register(queryCanceller);
                if (!this.session.getStopSign().isStopped()) {
                    this.prepareColumns();
                }
                this.session.getCancelManager().deregister(queryCanceller);
            }
        } else {
            this.session.getCancelManager().register(queryCanceller);
            if (!this.session.getStopSign().isStopped()) {
                this.prepareColumns();
            }
            this.session.getCancelManager().deregister(queryCanceller);
        }
        try {
            this.session.getCancelManager().register(queryCanceller);
            if (!this.session.getStopSign().isStopped()) {
                this.resultMetadata = this.getMetaData((IOdaDataSetDesign)this.session.getDataSetCacheManager().getCurrentDataSetDesign(), this.odaStatement);
            }
            if (design != null) {
                List<IColumnDefinition> modelResultHints = design.getResultSetHints();
                this.resultMetadata = this.mergeResultHint(modelResultHints, this.resultMetadata);
            }
            if (queryCanceller.collectException() != null && !(queryCanceller.collectException().getCause() instanceof UnsupportedOperationException)) {
                throw queryCanceller.collectException();
            }
            this.session.getCancelManager().deregister(queryCanceller);
        }
        catch (DataException e) {
            this.resultMetadata = null;
        }
        logger.fine("Prepare ODA Query uses:" + (System.currentTimeMillis() - start) + " ms ");
        return this;
    }

    private boolean canAccessResultSetByName(IOdaDataSetDesign design) throws DataException {
        return design.getPrimaryResultSetName() != null && this.odaStatement.supportsNamedResults();
    }

    private boolean canAccessResultSetByNumber(IOdaDataSetDesign design) throws DataException {
        return design.getPrimaryResultSetNumber() > 0 && this.odaStatement.supportsMultipleResultSets();
    }

    private void prepareColumns() throws DataException {
        this.addCustomFields(this.odaStatement);
        this.addColumnHints(this.odaStatement);
        if (this.projectedFields != null) {
            this.odaStatement.setColumnsProjection(this.projectedFields);
        }
    }

    private IResultClass getMetaData(IOdaDataSetDesign design, PreparedStatement odaStatement) throws DataException {
        IResultClass result = null;
        if (design != null) {
            if (this.canAccessResultSetByName(design)) {
                try {
                    result = odaStatement.getMetaData(design.getPrimaryResultSetName());
                }
                catch (DataException e) {
                    throw new DataException("data.engine.errorHappenWhenRetrieveResultSet", design.getPrimaryResultSetName());
                }
            }
            if (this.canAccessResultSetByNumber(design)) {
                try {
                    result = odaStatement.getMetaData(design.getPrimaryResultSetNumber());
                }
                catch (DataException e) {
                    throw new DataException("data.engine.errorHappenWhenRetrieveResultSet", design.getPrimaryResultSetNumber());
                }
            }
        }
        if (result == null) {
            result = odaStatement.getMetaData();
        }
        if (design != null) {
            List<IColumnDefinition> hintList = design.getResultSetHints();
            int i = 0;
            while (i < hintList.size()) {
                IColumnDefinition columnDefinition = hintList.get(i);
                int j = 1;
                while (j <= result.getFieldCount()) {
                    ResultFieldMetadata resultFieldMetadata = result.getFieldMetaData(j);
                    if (columnDefinition.getColumnName().equals(resultFieldMetadata.getName())) {
                        resultFieldMetadata.setAlias(columnDefinition.getAlias());
                        resultFieldMetadata.setAnalysisType(columnDefinition.getAnalysisType());
                        resultFieldMetadata.setAnalysisColumn(columnDefinition.getAnalysisColumn());
                        resultFieldMetadata.setIndexColumn(columnDefinition.isIndexColumn());
                        resultFieldMetadata.setCompressedColumn(columnDefinition.isCompressedColumn());
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    private QuerySpecification populateQuerySpecification() throws DataException {
        if (this.querySpecificaton == null) {
            QuerySpecHelper querySpecHelper = new QuerySpecHelper(this.dataSource.getDriverName(), this.queryType);
            this.querySpecificaton = querySpecHelper.getFactoryHelper().createQuerySpecification();
        }
        this.addPropertiesToQuerySpec(this.querySpecificaton);
        this.addParametersToQuerySpec(this.querySpecificaton);
        return this.querySpecificaton;
    }

    private void addPropertiesToQuerySpec(QuerySpecification querySpec) {
        if (this.propNames == null) {
            return;
        }
        assert (this.propValues != null);
        Iterator<String> it_name = this.propNames.iterator();
        Iterator it_val = this.propValues.iterator();
        while (it_name.hasNext()) {
            assert (it_val.hasNext());
            String name = it_name.next();
            String val = (String)it_val.next();
            querySpec.setProperty(name, (Object)val);
        }
    }

    private void addPropertiesToPreparedStatement() throws DataException {
        if (this.querySpecificaton == null || this.querySpecificaton.getProperties().isEmpty()) {
            return;
        }
        assert (this.odaStatement != null);
        Map propertyMap = this.querySpecificaton.getProperties();
        for (Map.Entry property : propertyMap.entrySet()) {
            String value = property.getValue() == null ? null : property.getValue().toString();
            this.odaStatement.setProperty((String)property.getKey(), value);
        }
    }

    private void addParametersToQuerySpec(QuerySpecification querySpec) throws DataException {
        if (this.parameterHints == null) {
            return;
        }
        for (ParameterHint parameterHint : this.parameterHints) {
            if (!parameterHint.isInputMode()) continue;
            Object inputValue = this.getParameterInputValue(parameterHint);
            QuerySpecHelper.setParameterValue(querySpec, parameterHint, inputValue);
        }
    }

    private void addParameterDefns() throws DataException {
        assert (this.odaStatement != null);
        if (this.parameterHints == null) {
            return;
        }
        for (ParameterHint parameterHint : this.parameterHints) {
            this.odaStatement.addParameterHint(parameterHint);
            if (!parameterHint.isInputMode()) continue;
            Object inputValue = this.getParameterInputValue(parameterHint);
            if (parameterHint.getPosition() <= 0 || this.odaStatement.supportsNamedParameter()) {
                this.setInputParamValue(parameterHint.getName(), parameterHint.getPosition(), inputValue);
                continue;
            }
            this.setInputParamValue(parameterHint.getPosition(), inputValue);
        }
        this.setInputParameterBinding();
    }

    private Object getParameterInputValue(ParameterHint parameterHint) throws DataException {
        Object inputValue;
        assert (parameterHint.isInputMode());
        Class paramHintDataType = parameterHint.getDataType();
        if (paramHintDataType == Date.class) {
            paramHintDataType = parameterHint.getEffectiveDataType(this.dataSource.getDriverName(), this.queryType);
        }
        if ((inputValue = parameterHint.getDefaultInputValue()) != null && inputValue.getClass().isArray() && !(inputValue instanceof byte[])) {
            inputValue = Array.getLength(inputValue) == 0 ? null : Array.get(inputValue, 0);
        }
        if (paramHintDataType != IBlob.class && paramHintDataType != IClob.class) {
            inputValue = DataSourceQuery.convertToValue(inputValue, paramHintDataType);
        }
        return inputValue;
    }

    private void setInputParamValue(String inputParamName, int position, Object paramValue) throws DataException {
        ParameterBinding pb = new ParameterBinding(inputParamName, position, paramValue);
        this.getInputParamValues().add(pb);
    }

    private void setInputParamValue(int inputParamPos, Object paramValue) throws DataException {
        ParameterBinding pb = new ParameterBinding(inputParamPos, paramValue);
        this.getInputParamValues().add(pb);
    }

    private void addCustomFields(PreparedStatement stmt) throws DataException {
        if (this.customFields != null) {
            for (CustomField customField : this.customFields) {
                stmt.declareCustomColumn(customField.getName(), DataType.getClass(customField.getDataType()));
            }
        }
    }

    private void addCustomFields(String rsetName, PreparedStatement stmt) throws DataException {
        if (this.customFields != null) {
            for (CustomField customField : this.customFields) {
                stmt.declareCustomColumn(rsetName, customField.getName(), DataType.getClass(customField.getDataType()));
            }
        }
    }

    private void addCustomFields(int rsetNumber, PreparedStatement stmt) throws DataException {
        if (this.customFields != null) {
            for (CustomField customField : this.customFields) {
                stmt.declareCustomColumn(rsetNumber, customField.getName(), DataType.getClass(customField.getDataType()));
            }
        }
    }

    private void addColumnHints(PreparedStatement stmt) throws DataException {
        assert (stmt != null);
        if (this.resultHints == null || this.resultHints.size() == 0) {
            return;
        }
        Iterator it = this.resultHints.iterator();
        while (it.hasNext()) {
            ColumnHint colHint = this.prepareOdiHint((IDataSourceQuery.ResultFieldHint)it.next());
            stmt.addColumnHint(colHint);
        }
        stmt.checkColumnsNaming();
    }

    private void addColumnHints(String rsetName, PreparedStatement stmt) throws DataException {
        assert (stmt != null);
        if (this.resultHints == null || this.resultHints.size() == 0) {
            return;
        }
        Iterator it = this.resultHints.iterator();
        while (it.hasNext()) {
            ColumnHint colHint = this.prepareOdiHint((IDataSourceQuery.ResultFieldHint)it.next());
            stmt.addColumnHint(rsetName, colHint);
        }
        stmt.checkColumnsNaming();
    }

    private void addColumnHints(int rsetNumber, PreparedStatement stmt) throws DataException {
        assert (stmt != null);
        if (this.resultHints == null || this.resultHints.size() == 0) {
            return;
        }
        Iterator it = this.resultHints.iterator();
        while (it.hasNext()) {
            ColumnHint colHint = this.prepareOdiHint((IDataSourceQuery.ResultFieldHint)it.next());
            stmt.addColumnHint(rsetNumber, colHint);
        }
        stmt.checkColumnsNaming();
    }

    private ColumnHint prepareOdiHint(IDataSourceQuery.ResultFieldHint odiHint) {
        ColumnHint colHint = new ColumnHint(odiHint.getName());
        colHint.setAlias(odiHint.getAlias());
        if (odiHint.getDataType() == 0) {
            colHint.setDataType(null);
        } else {
            colHint.setDataType(DataType.getClass(odiHint.getDataType()));
        }
        colHint.setNativeDataType(odiHint.getNativeDataType());
        if (odiHint.getPosition() > 0) {
            colHint.setPosition(odiHint.getPosition());
        }
        return colHint;
    }

    @Override
    public IResultClass getResultClass() {
        return this.resultMetadata;
    }

    @Override
    public Collection<ParameterMetaData> getParameterMetaData() throws DataException {
        if (this.odaStatement == null) {
            throw new DataException("data.engine.QueryNotPrepared");
        }
        Collection<org.eclipse.birt.data.engine.odaconsumer.ParameterMetaData> odaParamsInfo = this.odaStatement.getParameterMetaData();
        if (odaParamsInfo == null || odaParamsInfo.isEmpty()) {
            return null;
        }
        ArrayList<ParameterMetaData> paramMetaDataList = new ArrayList<ParameterMetaData>(odaParamsInfo.size());
        for (org.eclipse.birt.data.engine.odaconsumer.ParameterMetaData odaMetaData : odaParamsInfo) {
            paramMetaDataList.add(new ParameterMetaData(odaMetaData));
        }
        return paramMetaDataList;
    }

    private Collection getInputParamValues() {
        if (this.inputParamValues == null) {
            this.inputParamValues = new ArrayList();
        }
        return this.inputParamValues;
    }

    private IResultClass copyResultClass(IResultClass meta) throws DataException {
        ArrayList<ResultFieldMetadata> list = new ArrayList<ResultFieldMetadata>();
        int i = 1;
        while (i <= meta.getFieldCount()) {
            if (!meta.getFieldName(i).equals("_$$_dte_inner_row_id_$$_")) {
                int m_driverPosition = meta.getFieldMetaData(i).getDriverPosition();
                String m_name = meta.getFieldMetaData(i).getName();
                String m_label = meta.getFieldMetaData(i).getLabel();
                Class m_dataType = meta.getFieldMetaData(i).getDataType();
                String m_nativeTypeName = meta.getFieldMetaData(i).getNativeTypeName();
                boolean m_isCustom = meta.getFieldMetaData(i).isCustom();
                Class m_driverProvidedDataType = meta.getFieldMetaData(i).getDriverProvidedDataType();
                int m_analysisType = meta.getFieldMetaData(i).getAnalysisType();
                String m_analysisColumn = meta.getFieldMetaData(i).getAnalysisColumn();
                boolean m_indexColumn = meta.getFieldMetaData(i).isIndexColumn();
                boolean m_compressedColumn = meta.getFieldMetaData(i).isCompressedColumn();
                ResultFieldMetadata metadata = new ResultFieldMetadata(m_driverPosition, m_name, m_label, m_dataType, m_nativeTypeName, m_isCustom, m_analysisType, m_analysisColumn, m_indexColumn, m_compressedColumn);
                metadata.setDriverProvidedDataType(m_driverProvidedDataType);
                metadata.setAlias(meta.getFieldMetaData(i).getAlias());
                if (m_isCustom) {
                    metadata.setCustomPosition(meta.getFieldMetaData(i).getCustomPosition());
                }
                list.add(metadata);
            }
            ++i;
        }
        ResultClass resultClass = new ResultClass(list);
        return resultClass;
    }

    private IResultClass mergeResultHint(List modelResultHints, IResultClass meta) {
        IResultClass newResultClass;
        if (modelResultHints == null || modelResultHints.isEmpty()) {
            return meta;
        }
        try {
            newResultClass = this.copyResultClass(meta);
        }
        catch (Exception ex) {
            return meta;
        }
        boolean changed = false;
        int count = newResultClass.getFieldCount();
        try {
            int i = 1;
            while (i <= count) {
                String fieldName = newResultClass.getFieldName(i);
                Class odaType = newResultClass.getFieldMetaData(i).getDataType();
                int j = 0;
                while (j < modelResultHints.size()) {
                    if (((IColumnDefinition)modelResultHints.get(j)).getColumnName().equals(fieldName)) {
                        int apiType = ((IColumnDefinition)modelResultHints.get(j)).getDataType();
                        if (apiType <= 0 || DataTypeUtil.toApiDataType(odaType) == apiType) break;
                        newResultClass.getFieldMetaData(i).setDataType(DataType.getClass(apiType));
                        changed = true;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (changed) {
            return newResultClass;
        }
        return meta;
    }

    @Override
    public IResultIterator execute(IEventHandler eventHandler) throws DataException {
        assert (this.odaStatement != null);
        CachedResultSet ri = null;
        this.setInputParameterBinding();
        IOdaDataSetDesign design = null;
        if (this.session.getDataSetCacheManager().getCurrentDataSetDesign() instanceof IOdaDataSetDesign) {
            design = (IOdaDataSetDesign)this.session.getDataSetCacheManager().getCurrentDataSetDesign();
        }
        int fetchRowLimit = 0;
        if (design != null) {
            int cacheCountConfig;
            fetchRowLimit = design.getRowFetchLimit();
            if (this.session.getDataSetCacheManager().doesSaveToCache() && design.getFilters().isEmpty() && (cacheCountConfig = this.session.getDataSetCacheManager().getCacheCountConfig()) > 0 && fetchRowLimit == 0 && fetchRowLimit > cacheCountConfig) {
                fetchRowLimit = cacheCountConfig;
            }
        }
        this.odaStatement.setMaxRows(fetchRowLimit);
        OdaQueryCanceller queryCanceller = new OdaQueryCanceller(this.odaStatement, this.dataSource, this.session.getStopSign(), this);
        this.session.getCancelManager().register(queryCanceller);
        try {
            if (!this.session.getStopSign().isStopped()) {
                long startTime = System.currentTimeMillis();
                this.odaStatement.execute();
                long endTime = System.currentTimeMillis();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "ODA query execution time: " + (endTime - startTime) + " ms;\n   Executed query: " + this.odaStatement.getEffectiveQueryText());
                }
            }
            QueryContextVisitorUtil.populateEffectiveQueryText(this.qcv, this.odaStatement.getEffectiveQueryText());
            logger.fine("Effective Query Text:" + this.odaStatement.getEffectiveQueryText());
            if (queryCanceller.collectException() != null && !(queryCanceller.collectException().getCause() instanceof UnsupportedOperationException)) {
                throw queryCanceller.collectException();
            }
            ResultSet rs = null;
            if (design != null) {
                if (this.canAccessResultSetByName(design)) {
                    try {
                        rs = this.odaStatement.getResultSet(design.getPrimaryResultSetName());
                    }
                    catch (DataException e) {
                        throw new DataException("data.engine.errorHappenWhenRetrieveResultSet", design.getPrimaryResultSetName());
                    }
                }
                if (this.canAccessResultSetByNumber(design)) {
                    try {
                        rs = this.odaStatement.getResultSet(design.getPrimaryResultSetNumber());
                    }
                    catch (DataException e) {
                        throw new DataException("data.engine.errorHappenWhenRetrieveResultSet", design.getPrimaryResultSetNumber());
                    }
                }
            }
            if (rs == null && !this.session.getStopSign().isStopped()) {
                rs = this.odaStatement.getResultSet();
            }
            if (this.resultMetadata == null) {
                List<IColumnDefinition> modelResultHints = design.getResultSetHints();
                this.resultMetadata = rs.getMetaData();
                if (this.resultMetadata == null) {
                    throw new DataException("data.engine.NoResultMetadata");
                }
                this.resultMetadata = this.mergeResultHint(modelResultHints, this.resultMetadata);
            }
            if (!this.session.getDataSetCacheManager().doesSaveToCache()) {
                IQueryDefinition queryDefn;
                QueryExecutionStrategyUtil.Strategy strategy;
                if ((this.session.getEngineContext().getMode() == 3 || this.session.getEngineContext().getMode() == 1) && this.getQueryDefinition() instanceof IQueryDefinition && (strategy = QueryExecutionStrategyUtil.getQueryExecutionStrategy(this.session, queryDefn, (queryDefn = (IQueryDefinition)this.getQueryDefinition()).getDataSetName() == null ? null : ((DataEngineImpl)this.session.getEngine()).getDataSetDesign(queryDefn.getDataSetName()))) != QueryExecutionStrategyUtil.Strategy.Complex) {
                    SimpleResultSet simpleResult = new SimpleResultSet((BaseQuery)this, rs, this.resultMetadata, eventHandler, this.getGrouping(), this.session, strategy == QueryExecutionStrategyUtil.Strategy.SimpleLookingFoward);
                    IResultIterator iResultIterator = simpleResult.getResultSetIterator();
                    return iResultIterator;
                }
                ri = new CachedResultSet((BaseQuery)this, this.resultMetadata, rs, eventHandler, this.session);
            } else {
                ri = new CachedResultSet((BaseQuery)this, this.resultMetadata, new DataSetToCache(rs, this.resultMetadata, this.session), eventHandler, this.session);
            }
            if (ri != null) {
                ri.setOdaResultSet(rs);
            }
            CachedResultSet cachedResultSet = ri;
            return cachedResultSet;
        }
        finally {
            this.session.getCancelManager().deregister(queryCanceller);
        }
    }

    private void setInputParameterBinding() throws DataException {
        assert (this.odaStatement != null);
        for (ParameterBinding paramBind : this.getInputParamValues()) {
            if (paramBind.getPosition() <= 0 || this.odaStatement.supportsNamedParameter()) {
                try {
                    this.odaStatement.setParameterValue(paramBind.getName(), paramBind.getValue());
                }
                catch (DataException e) {
                    if (paramBind.getPosition() <= 0) {
                        throw e;
                    }
                    this.odaStatement.setParameterValue(paramBind.getPosition(), paramBind.getValue());
                }
                continue;
            }
            this.odaStatement.setParameterValue(paramBind.getPosition(), paramBind.getValue());
        }
    }

    @Override
    public Object getOutputParameterValue(int index) throws DataException {
        assert (this.odaStatement != null);
        int newIndex = this.getCorrectParamIndex(index);
        return this.odaStatement.getParameterValue(newIndex);
    }

    @Override
    public Object getOutputParameterValue(String name) throws DataException {
        assert (this.odaStatement != null);
        this.checkOutputParamNameValid(name);
        return this.odaStatement.getParameterValue(name);
    }

    private int getCorrectParamIndex(int index) throws DataException {
        if (index <= 0) {
            throw new DataException("data.engine.invalidOutputParameterIndex", index);
        }
        int newIndex = 0;
        int curOutputIndex = 0;
        Collection<ParameterMetaData> collection = this.getParameterMetaData();
        if (collection != null) {
            Iterator<ParameterMetaData> it = collection.iterator();
            while (it.hasNext()) {
                ++newIndex;
                IParameterMetaData metaData = it.next();
                if (metaData.isOutputMode().booleanValue() && ++curOutputIndex == index) break;
            }
        }
        if (curOutputIndex < index) {
            throw new DataException("data.engine.outputParameterOutOfBound", index);
        }
        return newIndex;
    }

    private void checkOutputParamNameValid(String name) throws DataException {
        assert (name != null);
        boolean isValid = false;
        Collection<ParameterMetaData> collection = this.getParameterMetaData();
        if (collection != null) {
            for (IParameterMetaData iParameterMetaData : collection) {
                String paramName = iParameterMetaData.getName();
                if (!paramName.equals(name)) continue;
                isValid = iParameterMetaData.isOutputMode();
                break;
            }
        }
        if (!isValid) {
            throw new DataException("data.engine.invalidOutputParameterName", name);
        }
    }

    @Override
    public void close() {
        if (this.odaStatement != null) {
            this.dataSource.closeStatement(this.odaStatement);
            this.odaStatement = null;
        }
        this.dataSource = null;
    }

    private static Object convertToValue(Object inputValue, Class typeClass) throws DataException {
        try {
            return DataTypeUtil.convert(inputValue, typeClass);
        }
        catch (Exception ex) {
            throw new DataException("data.engine.ConvertDataTypeError", (Throwable)ex, new Object[]{inputValue, typeClass});
        }
    }

    @Override
    public void setQuerySpecification(QuerySpecification spec) {
        this.querySpecificaton = spec;
    }

    public DataEngineSession getSession() {
        return this.session;
    }

    private static class OdaQueryCanceller
    implements ICancellable {
        private PreparedStatement statement;
        private DataSource dataSource;
        private StopSign stop;
        private DataException exception;
        private DataSourceQuery dsQuery;

        OdaQueryCanceller(PreparedStatement statement, DataSource dataSource, StopSign stop, DataSourceQuery dsQuery) {
            this.statement = statement;
            this.stop = stop;
            this.dataSource = dataSource;
            this.dsQuery = dsQuery;
        }

        @Override
        public DataException collectException() {
            return this.exception;
        }

        @Override
        public void cancel() {
            try {
                CancelManager manager = this.dsQuery.session.getCancelManager();
                if (manager != null) {
                    manager.deregister(this);
                }
                this.statement.cancel();
            }
            catch (Exception e) {
                try {
                    this.statement.close();
                }
                catch (Exception e1) {
                    this.exception = new DataException(e.getLocalizedMessage(), e);
                }
            }
            try {
                DataSource.CacheConnection conn = this.dataSource.getAvailableConnection();
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public boolean doCancel() {
            return this.stop.isStopped();
        }
    }
}

