/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.ods.layout;

import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.ods.BlankData;
import org.eclipse.birt.report.engine.emitter.ods.BookmarkDef;
import org.eclipse.birt.report.engine.emitter.ods.Data;
import org.eclipse.birt.report.engine.emitter.ods.DataCache;
import org.eclipse.birt.report.engine.emitter.ods.DateTimeUtil;
import org.eclipse.birt.report.engine.emitter.ods.ImageData;
import org.eclipse.birt.report.engine.emitter.ods.OdsEmitter;
import org.eclipse.birt.report.engine.emitter.ods.OdsUtil;
import org.eclipse.birt.report.engine.emitter.ods.RowData;
import org.eclipse.birt.report.engine.emitter.ods.SheetData;
import org.eclipse.birt.report.engine.emitter.ods.StyleEngine;
import org.eclipse.birt.report.engine.emitter.ods.layout.AxisProcessor;
import org.eclipse.birt.report.engine.emitter.ods.layout.ColumnsInfo;
import org.eclipse.birt.report.engine.emitter.ods.layout.ContainerSizeInfo;
import org.eclipse.birt.report.engine.emitter.ods.layout.LayoutUtil;
import org.eclipse.birt.report.engine.emitter.ods.layout.OdsCell;
import org.eclipse.birt.report.engine.emitter.ods.layout.OdsContainer;
import org.eclipse.birt.report.engine.emitter.ods.layout.OdsContext;
import org.eclipse.birt.report.engine.emitter.ods.layout.OdsTable;
import org.eclipse.birt.report.engine.i18n.EngineResourceHandle;
import org.eclipse.birt.report.engine.layout.emitter.Image;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.odf.pkg.ImageEntry;
import org.eclipse.birt.report.engine.odf.style.HyperlinkInfo;
import org.eclipse.birt.report.engine.odf.style.StyleBuilder;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;
import org.eclipse.birt.report.engine.odf.style.StyleManager;
import org.eclipse.birt.report.engine.util.FlashFile;

public class OdsLayoutEngine {
    protected static Logger logger = Logger.getLogger(OdsLayoutEngine.class.getName());
    public static final String EMPTY = "";
    public static final float DEFAULT_ROW_HEIGHT = 15.0f;
    private int autoBookmarkIndex = 0;
    public static final String AUTO_GENERATED_BOOKMARK = "auto_generated_bookmark_";
    private int maxRow = 65535;
    private int maxCol = 255;
    private HashMap<String, String> cachedBookmarks = new HashMap();
    protected DataCache cache;
    private AxisProcessor axis;
    protected StyleEngine engine;
    private OdsEmitter emitter;
    private Stack<OdsContainer> containers = new Stack();
    private Stack<OdsTable> tables = new Stack();
    private OdsContext context = null;
    private String messageFlashObjectNotSupported;
    private ULocale locale;
    private HashMap<String, BookmarkDef> bookmarkList = new HashMap();
    protected int reportDpi;
    protected Stack<Boolean> rowVisibilities = new Stack();

    public OdsLayoutEngine(OdsContext context, OdsEmitter emitter) {
        this.context = context;
        this.emitter = emitter;
        this.locale = context.getLocale();
        EngineResourceHandle resourceHandle = new EngineResourceHandle(this.locale);
        this.messageFlashObjectNotSupported = resourceHandle.getMessage("Error.FlashObjectNotSupported");
    }

    public void initalize(int contentWidth, IStyle style, int dpi, StyleManager styleManager) {
        this.axis = new AxisProcessor();
        this.axis.addCoordinate(contentWidth);
        ContainerSizeInfo rule = new ContainerSizeInfo(0, contentWidth);
        this.cache = this.createDataCache(this.maxCol, this.maxRow);
        this.engine = new StyleEngine(this, styleManager);
        this.containers.push(this.createContainer(rule, style, null));
        this.reportDpi = dpi;
    }

    protected DataCache createDataCache(int maxColumn, int maxRow) {
        return new DataCache(maxColumn, maxRow);
    }

    public OdsContainer getCurrentContainer() {
        return this.containers.peek();
    }

    public Stack<OdsContainer> getContainers() {
        return this.containers;
    }

    public void addTable(IContainerContent content, ColumnsInfo table, ContainerSizeInfo size) {
        IStyle style = content.getComputedStyle();
        OdsContainer currentContainer = this.getCurrentContainer();
        ContainerSizeInfo parentSizeInfo = currentContainer.getSizeInfo();
        int[] columnStartCoordinates = this.splitColumns(table, parentSizeInfo);
        this.createTable(table, style, currentContainer, columnStartCoordinates);
    }

    protected int[] splitColumns(ColumnsInfo columnsInfo, ContainerSizeInfo parentSizeInfo) {
        int startCoordinate = parentSizeInfo.getStartCoordinate();
        int endCoordinate = parentSizeInfo.getEndCoordinate();
        int[] columnStartCoordinates = this.calculateColumnCoordinates(columnsInfo, startCoordinate, endCoordinate);
        this.splitColumns(startCoordinate, endCoordinate, columnStartCoordinates);
        return columnStartCoordinates;
    }

    private void createTable(ColumnsInfo tableInfo, IStyle style, OdsContainer currentContainer, int[] columnStartCoordinates) {
        int leftCordinate = columnStartCoordinates[0];
        int width = columnStartCoordinates[columnStartCoordinates.length - 1] - leftCordinate;
        ContainerSizeInfo sizeInfo = new ContainerSizeInfo(leftCordinate, width);
        StyleEntry styleEntry = this.engine.createEntry(sizeInfo, style, this.getParentStyle());
        this.context.addStyle(styleEntry);
        OdsTable table = new OdsTable(tableInfo, styleEntry, sizeInfo, currentContainer);
        this.tables.push(table);
        this.addContainer(table);
    }

    protected StyleEntry getParentStyle() {
        return this.getParentStyle(this.getCurrentContainer());
    }

    private void splitColumns(int startCoordinate, int endCoordinate, int[] columnStartCoordinates) {
        int[] scale = this.axis.getColumnCoordinatesInRange(startCoordinate, endCoordinate);
        int i = 0;
        while (i < scale.length - 1) {
            int startPosition = scale[i];
            int endPostion = scale[i + 1];
            int[] range = this.inRange(startPosition, endPostion, columnStartCoordinates);
            if (range.length > 0) {
                int pos = this.axis.getColumnIndexByCoordinate(startPosition);
                this.cache.insertColumns(pos, range.length);
                int j = 0;
                while (j < range.length) {
                    this.axis.addCoordinate(range[j]);
                    ++j;
                }
            }
            ++i;
        }
    }

    private int[] calculateColumnCoordinates(ColumnsInfo table, int startCoordinate, int endCoordinate) {
        if (table == null) {
            return new int[]{startCoordinate};
        }
        int columnCount = table.getColumnCount();
        int[] columnStartCoordinates = new int[columnCount + 1];
        columnStartCoordinates[0] = startCoordinate;
        int i = 1;
        while (i <= columnCount) {
            columnStartCoordinates[i] = columnStartCoordinates[i - 1] + table.getColumnWidth(i - 1) > endCoordinate ? endCoordinate : columnStartCoordinates[i - 1] + table.getColumnWidth(i - 1);
            ++i;
        }
        return columnStartCoordinates;
    }

    private int[] inRange(int start, int end, int[] data) {
        int[] range = new int[data.length];
        int count = 0;
        int i = 0;
        while (i < data.length) {
            if (data[i] > start && data[i] < end) {
                range[++count] = data[i];
            }
            ++i;
        }
        int[] result = new int[count];
        int j = 0;
        int i2 = 0;
        while (i2 < range.length) {
            if (range[i2] != 0) {
                result[j] = range[i2];
                ++j;
            }
            ++i2;
        }
        return result;
    }

    public void addCell(int col, int colSpan, int rowSpan, IStyle style) {
        OdsTable table = this.tables.peek();
        ContainerSizeInfo cellSizeInfo = table.getColumnSizeInfo(col, colSpan);
        StyleEntry aStyle = this.engine.createEntry(cellSizeInfo, style, this.getParentStyle());
        this.context.addStyle(aStyle);
        OdsCell cell = new OdsCell(aStyle, cellSizeInfo, this.getCurrentContainer(), rowSpan);
        this.addContainer(cell);
    }

    private boolean isHidden(IContent content) {
        IStyle style;
        return content != null && IStyle.NONE_VALUE.equals((style = content.getStyle()).getProperty(63));
    }

    public void addCell(ICellContent cellcontent, int col, int colSpan, int rowSpan, IStyle style) {
        if (!this.isHidden(cellcontent)) {
            this.rowVisibilities.pop();
            this.rowVisibilities.push(true);
            OdsTable table = this.tables.peek();
            ContainerSizeInfo cellSizeInfo = table.getColumnSizeInfo(col, colSpan);
            int diagonalNumber = cellcontent.getDiagonalNumber();
            StyleEntry cellStyleEntry = null;
            if (diagonalNumber != 0) {
                String diagonalColor = cellcontent.getDiagonalColor();
                String diagonalStyle = cellcontent.getDiagonalStyle();
                int diagonalWidth = PropertyUtil.getDimensionValue(cellcontent, cellcontent.getDiagonalWidth(), cellSizeInfo.getWidth());
                cellStyleEntry = this.engine.createCellEntry(cellSizeInfo, style, diagonalColor, diagonalStyle, diagonalWidth, this.getParentStyle());
            } else {
                cellStyleEntry = this.engine.createEntry(cellSizeInfo, style, this.getParentStyle());
            }
            this.context.addStyle(cellStyleEntry);
            OdsCell cell = new OdsCell(cellStyleEntry, cellSizeInfo, this.getCurrentContainer(), rowSpan);
            this.addContainer(cell);
        }
    }

    public void endCell(ICellContent cell) {
        if (!this.isHidden(cell)) {
            this.endNormalContainer();
        }
    }

    public void addRow(IStyle style) {
        this.rowVisibilities.push(false);
        OdsContainer parent = this.getCurrentContainer();
        ContainerSizeInfo sizeInfo = parent.getSizeInfo();
        OdsContainer container = this.createContainer(sizeInfo, style, parent);
        container.setEmpty(false);
        this.addContainer(container);
    }

    public void endRow(float rowHeight) {
        if (this.rowVisibilities.pop().booleanValue()) {
            this.synchronize(rowHeight);
        }
        this.endContainer();
    }

    protected void synchronize(float height) {
        OdsContainer rowContainer = this.getCurrentContainer();
        ContainerSizeInfo rowSizeInfo = rowContainer.getSizeInfo();
        int startCoordinate = rowSizeInfo.getStartCoordinate();
        int endCoordinate = rowSizeInfo.getEndCoordinate();
        int startColumnIndex = this.axis.getColumnIndexByCoordinate(startCoordinate);
        int endColumnIndex = this.axis.getColumnIndexByCoordinate(endCoordinate);
        int maxRowIndex = 0;
        int[] rowIndexes = new int[endColumnIndex - startColumnIndex];
        int currentColumnIndex = startColumnIndex;
        while (currentColumnIndex < endColumnIndex) {
            int span;
            int rowIndex = this.cache.getMaxRowIndex(currentColumnIndex);
            SheetData lastData = this.cache.getColumnLastData(currentColumnIndex);
            rowIndexes[currentColumnIndex - startColumnIndex] = rowIndex;
            int n = span = lastData != null ? lastData.getRowSpanInDesign() : 0;
            if (span == 0 || span == 1 && !this.isInContainer(lastData, rowContainer)) {
                maxRowIndex = maxRowIndex > rowIndex ? maxRowIndex : rowIndex;
            }
            ++currentColumnIndex;
        }
        int startRowIndex = rowContainer.getRowIndex();
        if (maxRowIndex <= startRowIndex) {
            maxRowIndex = startRowIndex + 1;
        }
        rowContainer.setRowIndex(maxRowIndex);
        float resize = height / (float)(maxRowIndex - startRowIndex);
        int i = startRowIndex;
        while (i < maxRowIndex) {
            this.cache.setRowHeight(i, resize);
            ++i;
        }
        int currentColumnIndex2 = startColumnIndex;
        while (currentColumnIndex2 < endColumnIndex) {
            int rowspan = maxRowIndex - rowIndexes[currentColumnIndex2 - startColumnIndex];
            SheetData upstair = this.cache.getColumnLastData(currentColumnIndex2);
            if (rowspan > 0) {
                if (upstair != null && this.canSpan(upstair, rowContainer, currentColumnIndex2)) {
                    BlankData.Type blankType = BlankData.Type.VERTICAL;
                    if (upstair.isBlank()) {
                        BlankData blankData = (BlankData)upstair;
                        if (blankData.getType() == BlankData.Type.VERTICAL) {
                            upstair.setRowSpan(upstair.getRowSpan() + rowspan);
                            if (!this.isInContainer(blankData, rowContainer)) {
                                upstair.decreasRowSpanInDesign();
                            }
                        }
                        blankType = blankData.getType();
                    } else {
                        upstair.setRowSpan(upstair.getRowSpan() + rowspan);
                        if (!this.isInContainer(upstair, rowContainer)) {
                            upstair.decreasRowSpanInDesign();
                        }
                    }
                    int rowIndex = upstair.getRowIndex();
                    int p = 1;
                    while (p <= rowspan) {
                        BlankData blank = new BlankData(upstair);
                        blank.setRowIndex(rowIndex + p);
                        blank.setType(blankType);
                        this.cache.addData(currentColumnIndex2, blank);
                        ++p;
                    }
                }
            } else if (upstair != null && upstair.getRowSpanInDesign() > 0 && !this.isInContainer(upstair, rowContainer)) {
                upstair.decreasRowSpanInDesign();
            }
            ++currentColumnIndex2;
        }
    }

    private void calculateRowHeight(SheetData[] rowData, boolean isAuto) {
        float rowHeight = 0.0f;
        int rowIndex = this.getRowIndex(rowData);
        float lastRowHeight = rowIndex > 0 ? this.cache.getRowHeight(rowIndex - 1) : 0.0f;
        boolean hasCurrentRowHeight = this.cache.hasRowHeight(rowIndex);
        if (!hasCurrentRowHeight || isAuto) {
            int i = 0;
            while (i < rowData.length) {
                SheetData data = rowData[i];
                if (data != null) {
                    int realDataRowEnd;
                    SheetData realData;
                    BlankData blankData;
                    if (data.isBlank() && (blankData = (BlankData)data).getType() == BlankData.Type.VERTICAL) {
                        data.setHeight(data.getHeight() - lastRowHeight);
                    }
                    if ((realData = this.getRealData(data)) != null && (realDataRowEnd = realData.getRowIndex() + realData.getRowSpan()) == data.getRowIndex()) {
                        rowHeight = data.getHeight() > rowHeight ? data.getHeight() : rowHeight;
                    }
                }
                ++i;
            }
            this.cache.setRowHeight(rowIndex, rowHeight);
        }
    }

    private int getRowIndex(SheetData[] rowData) {
        int j = 0;
        while (j < rowData.length) {
            SheetData data = rowData[j];
            if (data != null) {
                return data.getRowIndex() - 1;
            }
            ++j;
        }
        return 0;
    }

    private boolean canSpan(SheetData upstair, OdsContainer rowContainer, int currentColumn) {
        SheetData realData = this.getRealData(upstair);
        if (realData == null) {
            return false;
        }
        if (this.isInContainer(realData, rowContainer)) {
            return true;
        }
        if (this.isInLastSpanningRow(upstair, realData, currentColumn)) {
            return realData.getRowSpanInDesign() >= 0;
        }
        return realData.getRowSpanInDesign() > 0;
    }

    private boolean isInLastSpanningRow(SheetData upstair, SheetData realData, int currentColumn) {
        int realColumn = this.axis.getColumnIndexByCoordinate(realData.getStartX());
        int span = this.axis.getColumnIndexByCoordinate(realData.getEndX()) - realColumn;
        return currentColumn > realColumn && currentColumn < realColumn + span && upstair.getRowIndex() == realData.getRowIndex() + realData.getRowSpan() - 1;
    }

    private SheetData getRealData(SheetData data) {
        while (data != null && data.isBlank()) {
            data = ((BlankData)data).getData();
        }
        return data;
    }

    private boolean isInContainer(SheetData data, OdsContainer rowContainer) {
        return data.getRowIndex() > rowContainer.getStartRowId();
    }

    public void endTable(IContent content) {
        if (!this.tables.isEmpty()) {
            this.tables.pop();
            this.endContainer();
        }
    }

    public void addContainer(IStyle style, HyperlinkInfo link) {
        OdsContainer parent = this.getCurrentContainer();
        ContainerSizeInfo sizeInfo = parent.getSizeInfo();
        StyleEntry entry = this.engine.createEntry(sizeInfo, style, this.getParentStyle(parent));
        this.context.addStyle(entry);
        this.addContainer(new OdsContainer(entry, sizeInfo, parent));
    }

    private StyleEntry getParentStyle(OdsContainer parent) {
        return parent == null ? null : parent.getStyle();
    }

    private void addContainer(OdsContainer child) {
        OdsContainer parent = child.getParent();
        if (parent instanceof OdsCell) {
            this.addEmptyDataToContainer(child, parent);
        }
        if (parent != null) {
            parent.setEmpty(false);
        }
        this.containers.push(child);
    }

    private void addEmptyDataToContainer(OdsContainer child, OdsContainer parent) {
        StyleEntry style;
        ContainerSizeInfo childSizeInfo = child.getSizeInfo();
        int childStartCoordinate = childSizeInfo.getStartCoordinate();
        int childEndCoordinate = childSizeInfo.getEndCoordinate();
        ContainerSizeInfo parentSizeInfo = parent.getSizeInfo();
        int parentStartCoordinate = parentSizeInfo.getStartCoordinate();
        int parentEndCoordinate = parent.getSizeInfo().getEndCoordinate();
        if (childEndCoordinate < parentEndCoordinate) {
            style = parent.getStyle();
            this.removeLeftBorder(style);
            this.removeDiagonalLine(style);
            this.addEmptyDataToContainer(style, parent, childEndCoordinate, parentEndCoordinate - childEndCoordinate);
        }
        if (childStartCoordinate > parentStartCoordinate) {
            style = parent.getStyle();
            this.removeRightBorder(style);
            this.removeDiagonalLine(style);
            this.addEmptyDataToContainer(style, parent, childStartCoordinate, parentStartCoordinate - childStartCoordinate);
        }
    }

    private void addEmptyDataToContainer(StyleEntry style, OdsContainer parent, int startCoordinate, int width) {
        Data data = this.createEmptyData(style);
        data.setStartX(startCoordinate);
        data.setEndX(startCoordinate + width);
        this.addData(data);
    }

    public void endContainer() {
        this.setParentContainerIndex();
        this.endNormalContainer();
    }

    private void setParentContainerIndex() {
        OdsContainer container = this.getCurrentContainer();
        OdsContainer parent = container.getParent();
        if (parent != null) {
            parent.setRowIndex(container.getRowIndex());
        }
    }

    public void endNormalContainer() {
        OdsContainer container = this.getCurrentContainer();
        if (container.isEmpty()) {
            Data data = this.createData(EMPTY, container.getStyle());
            ContainerSizeInfo containerSize = container.getSizeInfo();
            data.setStartX(containerSize.getStartCoordinate());
            data.setEndX(containerSize.getEndCoordinate());
            this.addData(data);
        }
        this.engine.applyContainerBottomStyle();
        this.containers.pop();
    }

    public Data addData(Object txt, IStyle style, HyperlinkInfo link, BookmarkDef bookmark, float height) {
        return this.addData(txt, style, link, bookmark, null, height);
    }

    public Data addData(Object value, IStyle style, HyperlinkInfo link, BookmarkDef bookmark, String locale, float height) {
        OdsContainer container = this.getCurrentContainer();
        ContainerSizeInfo containerSize = container.getSizeInfo();
        StyleEntry entry = this.engine.getStyle(style, containerSize, this.getParentStyle(container));
        this.context.addStyle(entry);
        this.setDataType(entry, value, locale);
        Data data = this.createData(value, entry);
        data.setHeight(height);
        data.setHyperlinkDef(link);
        data.setBookmark(bookmark);
        data.setStartX(containerSize.getStartCoordinate());
        data.setEndX(containerSize.getEndCoordinate());
        this.addData(data);
        return data;
    }

    public void addImageData(IImageContent image, IStyle style, HyperlinkInfo link, BookmarkDef bookmark) {
        int imageWidth;
        int imageHeight;
        Object imageSize;
        OdsContainer container = this.getCurrentContainer();
        ContainerSizeInfo parentSizeInfo = container.getSizeInfo();
        int imageWidthDpi = this.reportDpi;
        int imageHeightDpi = this.reportDpi;
        byte[] imageData = null;
        try {
            Image imageInfo = EmitterUtil.parseImage(image, image.getImageSource(), image.getURI(), image.getMIMEType(), image.getExtension());
            imageData = imageInfo.getData();
            imageSize = this.getImageSize(image, imageInfo, parentSizeInfo, imageWidthDpi, imageHeightDpi);
            imageHeight = imageSize[0];
            imageWidth = imageSize[1];
        }
        catch (IOException ex) {
            imageHeight = LayoutUtil.getImageHeight(image.getHeight(), 0, imageHeightDpi);
            imageWidth = LayoutUtil.getImageWidth(image.getWidth(), parentSizeInfo.getWidth(), 0, imageWidthDpi);
        }
        ColumnsInfo imageColumnsInfo = LayoutUtil.createImage(imageWidth);
        this.splitColumns(imageColumnsInfo, parentSizeInfo);
        imageSize = new ContainerSizeInfo(parentSizeInfo.getStartCoordinate(), imageColumnsInfo.getTotalWidth());
        StyleEntry entry = this.engine.getStyle(style, (ContainerSizeInfo)imageSize, parentSizeInfo, this.getParentStyle(container));
        SheetData data = this.createImageData(image, imageData, ((ContainerSizeInfo)imageSize).getWidth(), imageHeight, entry, container);
        data.setHyperlinkDef(link);
        data.setBookmark(bookmark);
        data.setStartX(((ContainerSizeInfo)imageSize).getStartCoordinate());
        data.setEndX(((ContainerSizeInfo)imageSize).getEndCoordinate());
        this.addData(data);
    }

    private int[] getImageSize(IImageContent image, Image imageInfo, ContainerSizeInfo parentSizeInfo, int imageWidthDpi, int imageHeightDpi) {
        int imageWidth;
        float scale;
        int imageHeight;
        if (image.getWidth() == null && image.getHeight() == null) {
            int imageFileWidthDpi = imageInfo.getPhysicalWidthDpi() == -1 ? 0 : imageInfo.getPhysicalWidthDpi();
            int imageFileHeightDpi = imageInfo.getPhysicalHeightDpi() == -1 ? 0 : imageInfo.getPhysicalHeightDpi();
            imageWidthDpi = PropertyUtil.getImageDpi(image, imageFileWidthDpi, 0);
            imageHeightDpi = PropertyUtil.getImageDpi(image, imageFileHeightDpi, 0);
        }
        int imageInfoHeight = (int)((float)(imageInfo.getHeight() * 1000) * 72.0f / (float)imageHeightDpi);
        int imageInfoWidth = (int)((float)(imageInfo.getWidth() * 1000) * 72.0f / (float)imageWidthDpi);
        if (image.getWidth() == null && image.getHeight() != null) {
            imageHeight = LayoutUtil.getImageHeight(image.getHeight(), imageInfoHeight, imageHeightDpi);
            scale = (float)imageInfoHeight / (float)imageInfoWidth;
            imageWidth = (int)((float)imageHeight / scale);
        } else if (image.getHeight() == null && image.getWidth() != null) {
            imageWidth = LayoutUtil.getImageWidth(image.getWidth(), parentSizeInfo.getWidth(), imageInfoWidth, imageWidthDpi);
            scale = (float)imageInfoHeight / (float)imageInfoWidth;
            imageHeight = (int)((float)imageWidth * scale);
        } else {
            imageHeight = LayoutUtil.getImageHeight(image.getHeight(), imageInfoHeight, imageHeightDpi);
            imageWidth = LayoutUtil.getImageWidth(image.getWidth(), parentSizeInfo.getWidth(), imageInfoWidth, imageWidthDpi);
        }
        int[] imageSize = new int[]{imageHeight, imageWidth};
        return imageSize;
    }

    private SheetData createImageData(IImageContent image, byte[] imageData, int imageWidth, int imageHeight, StyleEntry entry, OdsContainer container) {
        int type = 5;
        entry.setProperty(25, type);
        String uri = image.getURI();
        String mimeType = image.getMIMEType();
        String extension = image.getExtension();
        String altText = image.getAltText();
        if (FlashFile.isFlash(mimeType, uri, extension)) {
            if (altText == null) {
                altText = this.messageFlashObjectNotSupported;
            }
            entry.setProperty(25, 2);
            return this.createData(altText, entry);
        }
        if (imageData != null) {
            ImageEntry imageEntry = null;
            try {
                imageEntry = this.context.getImageManager().addImage(image);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            ImageData imageData1 = new ImageData(imageEntry.getUri(), image.getAltText(), imageWidth, imageHeight, entry, type, container);
            return imageData1;
        }
        entry.setProperty(25, 2);
        return this.createData(image.getAltText(), entry);
    }

    public Data addDateTime(Object txt, IStyle style, HyperlinkInfo link, BookmarkDef bookmark, String dateTimeLocale, float height) {
        OdsContainer currentContainer = this.getCurrentContainer();
        ContainerSizeInfo containerSize = currentContainer.getSizeInfo();
        StyleEntry entry = this.engine.getStyle(style, containerSize, this.getParentStyle(currentContainer));
        this.context.addStyle(entry);
        Data data = null;
        IDataContent dataContent = (IDataContent)txt;
        Object value = dataContent.getValue();
        Date date = OdsUtil.getDate(value);
        if (date != null && (date instanceof Time || date.getYear() >= 0)) {
            data = this.createDateData(value, entry, style.getDateTimeFormat(), dateTimeLocale);
            data.setHeight(height);
            data.setBookmark(bookmark);
            data.setHyperlinkDef(link);
            data.setStartX(containerSize.getStartCoordinate());
            data.setEndX(containerSize.getEndCoordinate());
            this.addData(data);
            return data;
        }
        entry.setProperty(25, 2);
        return this.addData(dataContent.getText(), style, link, bookmark, dateTimeLocale, height);
    }

    public void addCaption(String text, IStyle style) {
        ContainerSizeInfo containerSize = this.getCurrentContainer().getSizeInfo();
        StyleEntry entry = StyleBuilder.createEmptyStyleEntry(0);
        entry.setProperty(8, "Center");
        entry.setProperty(1, StyleBuilder.convertFontSize(style.getProperty(54)));
        entry.setProperty(25, 2);
        Data data = this.createData(text, entry);
        data.setStartX(containerSize.getStartCoordinate());
        data.setEndX(containerSize.getEndCoordinate());
        this.addData(data);
    }

    private void setDataType(StyleEntry entry, Object value, String dataLocale) {
        ULocale locale = this.getLocale(dataLocale);
        this.setDataType(entry, value, locale);
    }

    private void setDataType(StyleEntry entry, Object value, ULocale locale) {
        int type = 2;
        if (1 == OdsUtil.getType(value)) {
            String format = OdsUtil.getPattern(value, (String)entry.getProperty(23));
            format = OdsUtil.formatNumberPattern(format, locale);
            entry.setProperty(23, format);
            type = 1;
        } else if (OdsUtil.getType(value) == 0) {
            String format = OdsUtil.getPattern(value, (String)entry.getProperty(22));
            entry.setProperty(22, format);
            type = 0;
        }
        entry.setProperty(25, type);
    }

    private Data createDateData(Object txt, StyleEntry entry, String timeFormat, String dlocale) {
        ULocale dateLocale = this.getLocale(dlocale);
        timeFormat = OdsUtil.parse(txt, timeFormat, dateLocale);
        timeFormat = DateTimeUtil.formatDateTime(timeFormat, dateLocale);
        entry.setProperty(22, timeFormat);
        entry.setProperty(25, 0);
        return this.createData(txt, entry);
    }

    private ULocale getLocale(String dlocale) {
        return dlocale == null ? this.locale : new ULocale(dlocale);
    }

    protected void addData(SheetData data) {
        OdsContainer container = this.getCurrentContainer();
        container.setEmpty(false);
        if (data.getStartX() == data.getEndX()) {
            return;
        }
        int col = this.axis.getColumnIndexByCoordinate(data.getStartX());
        if (col == -1 || col >= this.cache.getColumnCount()) {
            return;
        }
        int span = this.axis.getColumnIndexByCoordinate(data.getEndX()) - col;
        this.outputDataIfBufferIsFull();
        this.updataRowIndex(data, container);
        this.addDatatoCache(col, data);
        int i = col + 1;
        while (i < col + span) {
            BlankData blankData = new BlankData(data);
            blankData.setType(BlankData.Type.HORIZONTAL);
            this.addDatatoCache(i, blankData);
            ++i;
        }
        if (data.getDataType() == 5) {
            this.addEmptyData(data, container);
        }
        while (container != null) {
            if (container instanceof OdsCell) {
                OdsCell cell = (OdsCell)container;
                data.setRowSpanInDesign(cell.getRowSpan() - 1);
                break;
            }
            container = container.getParent();
        }
    }

    protected void addEmptyData(SheetData data, OdsContainer container) {
        Data empty;
        int num;
        int column;
        StyleEntry style;
        int parentStartCoordinate = container.getSizeInfo().getStartCoordinate();
        int parentEndCoordinate = container.getSizeInfo().getEndCoordinate();
        int childStartCoordinate = data.getStartX();
        int childEndCoordinate = data.getEndX();
        if (childEndCoordinate < parentEndCoordinate) {
            style = container.getStyle();
            this.removeLeftBorder(style);
            column = this.axis.getColumnIndexByCoordinate(childEndCoordinate);
            num = this.axis.getColumnIndexByCoordinate(parentEndCoordinate) - column - 1;
            empty = this.createEmptyData(style);
            empty.setStartX(childEndCoordinate);
            empty.setEndX(parentEndCoordinate);
            empty.setRowIndex(data.getRowIndex());
            this.addDatatoCache(column, empty);
            this.addBlankData(column, num, empty);
        }
        if (childStartCoordinate > parentStartCoordinate) {
            style = container.getStyle();
            this.removeRightBorder(style);
            column = this.axis.getColumnIndexByCoordinate(childStartCoordinate);
            num = column - this.axis.getColumnIndexByCoordinate(parentStartCoordinate) - 1;
            empty = this.createEmptyData(style);
            empty.setStartX(childStartCoordinate);
            empty.setEndX(parentEndCoordinate);
            empty.setRowIndex(data.getRowIndex());
            this.addDatatoCache(column, empty);
            this.addBlankData(column - num - 1, num, empty);
        }
    }

    private void addBlankData(int column, int num, Data empty) {
        int i = 1;
        while (i <= num) {
            BlankData blank = new BlankData(empty);
            blank.setRowIndex(empty.getRowIndex());
            this.addDatatoCache(column + i, blank);
            ++i;
        }
    }

    private void removeRightBorder(StyleEntry style) {
        style.setProperty(19, null);
        style.setProperty(20, null);
        style.setProperty(21, null);
    }

    private void removeLeftBorder(StyleEntry style) {
        style.setProperty(16, null);
        style.setProperty(17, null);
        style.setProperty(18, null);
    }

    private void removeDiagonalLine(StyleEntry style) {
        style.setProperty(29, null);
        style.setProperty(30, null);
        style.setProperty(31, null);
        style.setProperty(32, null);
        style.setProperty(33, null);
        style.setProperty(34, null);
    }

    protected Data createEmptyData(StyleEntry style) {
        return this.createData(EMPTY, style);
    }

    protected void updataRowIndex(SheetData data, OdsContainer container) {
        int rowIndex = container.getRowIndex() + 1;
        data.setRowIndex(rowIndex);
        container.setRowIndex(rowIndex);
    }

    private void outputDataIfBufferIsFull() {
        if (this.getCurrentContainer().getRowIndex() >= this.maxRow) {
            this.emitter.outputSheet();
            this.cache.clearCachedSheetData();
            this.resetContainers();
        }
    }

    public OdsContainer createContainer(ContainerSizeInfo sizeInfo, IStyle style, OdsContainer parent) {
        StyleEntry aStyle = this.engine.createEntry(sizeInfo, style, this.getParentStyle(parent));
        this.context.addStyle(aStyle);
        return new OdsContainer(aStyle, sizeInfo, parent);
    }

    public OdsContainer createCellContainer(IStyle style, OdsContainer parent, int rowSpan) {
        ContainerSizeInfo sizeInfo = parent.getSizeInfo();
        StyleEntry aStyle = this.engine.createEntry(sizeInfo, style, this.getParentStyle(parent));
        this.context.addStyle(aStyle);
        return new OdsCell(aStyle, sizeInfo, parent, rowSpan);
    }

    public int[] getCoordinates() {
        int[] coord = this.axis.getColumnWidths();
        if (coord.length <= this.maxCol) {
            return coord;
        }
        int[] ncoord = new int[this.maxCol];
        System.arraycopy(coord, 0, ncoord, 0, this.maxCol);
        return ncoord;
    }

    public int getRowCount() {
        return this.cache.getMaxRow();
    }

    public AxisProcessor getAxis() {
        return this.axis;
    }

    public SheetData getColumnLastData(int column) {
        return this.cache.getColumnLastData(column);
    }

    private void addDatatoCache(int col, SheetData value) {
        this.cache.addData(col, value);
    }

    public void complete(boolean isAuto) {
        this.engine.applyContainerBottomStyle((OdsContainer)this.containers.get(0));
        Iterator<SheetData[]> iterator = this.cache.getRowIterator();
        while (iterator.hasNext()) {
            SheetData[] rowData = iterator.next();
            int j = 0;
            while (j < rowData.length) {
                HyperlinkInfo hyperLink;
                SheetData data = rowData[j];
                if (data != null && !data.isBlank() && (hyperLink = data.getHyperlinkDef()) != null && hyperLink.getType() == 2) {
                    this.setLinkedBookmark(data, hyperLink);
                }
                ++j;
            }
            this.calculateRowHeight(rowData, isAuto);
        }
    }

    public int getStartColumn(SheetData data) {
        int start = this.axis.getColumnIndexByCoordinate(data.getStartX()) + 1;
        return Math.min(start, this.maxCol);
    }

    public int getEndColumn(SheetData data) {
        int end = this.axis.getColumnIndexByCoordinate(data.getEndX()) + 1;
        return Math.min(end, this.maxCol);
    }

    private void setLinkedBookmark(SheetData data, HyperlinkInfo hyperLink) {
        String bookmarkName = hyperLink.getUrl();
        BookmarkDef linkedBookmark = this.bookmarkList.get(bookmarkName);
        if (linkedBookmark != null) {
            data.setLinkedBookmark(linkedBookmark);
        } else {
            BookmarkDef newBookmark;
            if (OdsUtil.isValidBookmarkName(bookmarkName)) {
                newBookmark = new BookmarkDef(bookmarkName);
            } else {
                String generateBookmarkName = this.getGenerateBookmark(bookmarkName);
                newBookmark = new BookmarkDef(generateBookmarkName);
                this.cachedBookmarks.put(bookmarkName, generateBookmarkName);
            }
            data.setLinkedBookmark(newBookmark);
        }
    }

    public Stack<OdsTable> getTable() {
        return this.tables;
    }

    public void addContainerStyle(IStyle computedStyle) {
        this.engine.addContainderStyle(computedStyle, this.getParentStyle());
    }

    public void removeContainerStyle() {
        this.engine.removeForeignContainerStyle();
    }

    public void resetContainers() {
        for (OdsContainer container : this.containers) {
            container.setRowIndex(0);
            container.setStartRowId(0);
        }
        for (OdsTable table : this.tables) {
            table.setRowIndex(0);
        }
    }

    public OdsLayoutEngineIterator getIterator() {
        return new OdsLayoutEngineIterator();
    }

    public void cacheBookmarks(String sheetName) {
        List<BookmarkDef> currentSheetBookmarks = this.cache.getBookmarks();
        for (BookmarkDef book : currentSheetBookmarks) {
            book.setSheetName(sheetName);
            this.bookmarkList.put(book.getName(), book);
        }
    }

    public HashMap<String, BookmarkDef> getAllBookmarks() {
        return this.bookmarkList;
    }

    public String getGenerateBookmark(String bookmarkName) {
        String generatedName = this.cachedBookmarks.get(bookmarkName);
        return generatedName != null ? generatedName : AUTO_GENERATED_BOOKMARK + this.autoBookmarkIndex++;
    }

    protected Data createData() {
        return new Data();
    }

    protected Data createData(Object text, StyleEntry style) {
        return this.createData(text, style, 0);
    }

    protected Data createData(Object text, StyleEntry style, int rowSpanOfDesign) {
        Object property;
        Data data = this.createData();
        int dataType = 2;
        if (style != null && (property = style.getProperty(25)) instanceof Integer) {
            dataType = (Integer)property;
        }
        data.setDataType(dataType);
        data.setValue(text);
        data.setStyleId(style);
        data.setRowSpanInDesign(rowSpanOfDesign);
        return data;
    }

    private class OdsLayoutEngineIterator
    implements Iterator<RowData> {
        Iterator<SheetData[]> rowIterator;

        public OdsLayoutEngineIterator() {
            this.rowIterator = OdsLayoutEngine.this.cache.getRowIterator();
        }

        @Override
        public boolean hasNext() {
            return this.rowIterator.hasNext();
        }

        @Override
        public RowData next() {
            SheetData[] row = this.rowIterator.next();
            ArrayList<SheetData> data = new ArrayList<SheetData>();
            int width = Math.min(row.length, OdsLayoutEngine.this.maxCol - 1);
            int rowIndex = 0;
            int i = 0;
            while (i < width) {
                SheetData d = row[i];
                if (d != null) {
                    rowIndex = d.getRowIndex();
                    data.add(row[i]);
                }
                ++i;
            }
            SheetData[] rowdata = new SheetData[data.size()];
            double rowHeight = Math.max(15.0f, OdsLayoutEngine.this.cache.getRowHeight(rowIndex - 1));
            data.toArray(rowdata);
            return new RowData(rowdata, rowHeight);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

