/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound.v3;

import java.io.IOException;
import org.eclipse.birt.core.archive.compound.v3.Ext2Block;
import org.eclipse.birt.core.archive.compound.v3.Ext2FileSystem;
import org.eclipse.birt.core.i18n.CoreMessages;

public class DataBlock
extends Ext2Block {
    private final byte[] buffer = new byte[4096];
    private int dirtyStart = -1;
    private int dirtyEnd = -1;
    static final DataBlock READ_ONLY_BLOCK = new ReadOnlyBlock();

    DataBlock(Ext2FileSystem fs) {
        this(fs, -1);
    }

    DataBlock(Ext2FileSystem fs, int blockId) {
        super(fs, blockId);
    }

    public synchronized int write(int tgt, byte[] b, int off, int len) throws IOException {
        assert (b != null);
        assert (tgt + len <= this.buffer.length);
        assert (off + len <= b.length);
        if (len > 0) {
            System.arraycopy(b, off, this.buffer, tgt, len);
            if (this.dirtyStart == -1) {
                this.dirtyStart = tgt;
                this.dirtyEnd = tgt + len;
            } else {
                if (this.dirtyStart > tgt) {
                    this.dirtyStart = tgt;
                }
                if (this.dirtyEnd < tgt + len) {
                    this.dirtyEnd = tgt + len;
                }
            }
        }
        return len;
    }

    public synchronized int read(int src, byte[] b, int off, int len) throws IOException {
        assert (b != null);
        assert (off + len <= b.length);
        assert (src + len <= this.buffer.length);
        System.arraycopy(this.buffer, src, b, off, len);
        return len;
    }

    @Override
    public void refresh() throws IOException {
        assert (this.blockId != -1);
        this.fs.readBlock(this.blockId, this.buffer, 0, 4096);
        this.dirtyEnd = -1;
        this.dirtyStart = -1;
    }

    @Override
    public void flush() throws IOException {
        if (this.blockId == -1) {
            throw new IllegalStateException("Must assign the block id before flush");
        }
        if (this.dirtyStart != this.dirtyEnd) {
            this.fs.writeBlock(this.blockId, this.buffer, this.dirtyStart, this.dirtyEnd - this.dirtyStart);
            this.dirtyEnd = -1;
            this.dirtyStart = -1;
        }
    }

    private static class ReadOnlyBlock
    extends DataBlock {
        ReadOnlyBlock() {
            super((Ext2FileSystem)null, -1);
        }

        @Override
        public int write(int tgt, byte[] b, int off, int len) throws IOException {
            throw new IOException(CoreMessages.getString("error.CanotchangeReadOnlyBuffer"));
        }

        @Override
        public int read(int src, byte[] b, int off, int len) throws IOException {
            assert (b != null);
            assert (off + len <= b.length);
            int i = 0;
            while (i < len) {
                b[off + i] = 0;
                ++i;
            }
            return len;
        }

        @Override
        public void refresh() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }
    }
}

