/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views.attributes.providers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;

public class GroupModelProvider {
    private static int[] columnWidth = new int[]{250, 250};
    private static final String[] EMPTY = new String[0];

    public String[] getColumnNames(String[] keys) {
        assert (keys != null);
        String[] columnNames = new String[keys.length];
        int i = 0;
        while (i < keys.length) {
            columnNames[i] = this.getDisplayName("TableGroup", keys[i]);
            ++i;
        }
        return columnNames;
    }

    private String getDisplayName(String elementName, String property) {
        String name = null;
        IElementPropertyDefn propertyDefn = DEUtil.getMetaDataDictionary().getElement(elementName).getProperty(property);
        if (propertyDefn != null) {
            name = Messages.getString((String)propertyDefn.getDisplayNameID());
        }
        if (name == null) {
            return "";
        }
        return name;
    }

    public Object[] getElements(List input) {
        if (input.isEmpty()) {
            return null;
        }
        Object obj = input.get(0);
        if (!(obj instanceof ListingHandle)) {
            return EMPTY;
        }
        ListingHandle element = (ListingHandle)obj;
        SlotHandle slot = element.getGroups();
        Iterator iterator = slot.iterator();
        if (iterator == null) {
            return EMPTY;
        }
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list.toArray();
    }

    public String getText(Object element, String key) {
        GroupHandle handle = (GroupHandle)element;
        if (key.equals("groupName")) {
            if (handle.getName() == null) {
                return "";
            }
            return handle.getName();
        }
        if (handle.getKeyExpr() == null) {
            return "";
        }
        return handle.getKeyExpr();
    }

    public boolean setStringValue(Object item, Object element, String key, String newValue) throws NameException, SemanticException {
        GroupHandle handle = (GroupHandle)element;
        handle.setKeyExpr(newValue);
        return true;
    }

    public String[] getChoiceSet(Object item, String key) {
        if (!(item instanceof ReportItemHandle)) {
            return EMPTY;
        }
        return this.getDataSetColumns((ReportItemHandle)item);
    }

    private String[] getDataSetColumns(ReportItemHandle handle) {
        DataSetHandle dataSet = handle.getDataSet();
        if (dataSet == null) {
            return EMPTY;
        }
        Iterator iterator = dataSet.resultSetHintsIterator();
        if (iterator == null) {
            return EMPTY;
        }
        ArrayList<String> columns = new ArrayList<String>();
        while (iterator.hasNext()) {
            ResultSetColumn resultSetColumn = (ResultSetColumn)iterator.next();
            columns.add(resultSetColumn.getColumnName());
        }
        return columns.toArray(new String[0]);
    }

    public boolean moveItem(Object item, int oldPos, int newPos) throws SemanticException {
        DesignElementHandle element = (DesignElementHandle)item;
        SlotHandle slotHandle = element.getSlot(1);
        DesignElementHandle group = slotHandle.get(oldPos);
        slotHandle.shift(group, newPos);
        return true;
    }

    public boolean deleteItem(Object item, int pos) throws SemanticException {
        DesignElementHandle element = (DesignElementHandle)item;
        element.getSlot(1).drop(pos);
        return true;
    }

    public boolean addItem(Object item, Object newGroup, int pos) throws ContentException, NameException {
        DesignElementHandle element = (DesignElementHandle)item;
        if (newGroup instanceof GroupHandle) {
            element.getSlot(1).add((DesignElementHandle)((GroupHandle)newGroup), pos);
            return true;
        }
        return false;
    }

    public int[] getColumnWidths() {
        return columnWidth;
    }

    public boolean needRefreshed(NotificationEvent event) {
        String propertyName;
        return event instanceof PropertyEvent && "keyExpr".equals(propertyName = ((PropertyEvent)event).getPropertyName());
    }
}

