/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import com.ibm.icu.util.ULocale;
import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.api.ReportParameterConverter;

public class ReportParameterConverterTest
extends TestCase {
    public void testDate() {
        Calendar dateCal = Calendar.getInstance(Locale.US);
        dateCal.clear();
        dateCal.set(1998, 8, 13, 20, 1, 44);
        Date dateTime = dateCal.getTime();
        java.sql.Date date = new java.sql.Date(dateTime.getTime());
        Time time = new Time(dateTime.getTime());
        ReportParameterConverter converter = new ReportParameterConverter("i", ULocale.US);
        String strDateTime = converter.format((Object)dateTime);
        String strTime = converter.format((Object)time);
        String strDate = converter.format((Object)date);
        ReportParameterConverterTest.assertEquals((String)"9/13/1998, 8:01:44 PM", (String)strDateTime.replace("\u202f", " "));
        ReportParameterConverterTest.assertEquals((String)"9/13/1998", (String)strDate);
        ReportParameterConverterTest.assertEquals((String)"8:01:44 PM", (String)strTime.replace("\u202f", " "));
        Date newDateTime = (Date)converter.parse(strDateTime, 4);
        java.sql.Date newDate = (java.sql.Date)converter.parse(strDate, 7);
        Time newTime = (Time)converter.parse(strTime, 8);
        ReportParameterConverterTest.assertEquals((String)strDateTime, (String)converter.format((Object)newDateTime));
        ReportParameterConverterTest.assertEquals((String)strDate, (String)converter.format((Object)newDate));
        ReportParameterConverterTest.assertEquals((String)strTime, (String)converter.format((Object)newTime));
    }
}

