/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class LibraryImportTest
extends BaseTestCase {
    String fileName = "Library_Import_Test.xml";
    private String inputLibraryName = "LibraryCreatLib.xml";
    private String outputFileName = "Library_Import_Dpt.xml";
    private String goldenFileName = "LibraryImportDpt_golden.xml";

    public LibraryImportTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(LibraryImportTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/" + this.fileName);
        this.copyInputToFile("input/" + this.inputLibraryName);
        this.copyGoldenToFile("golden/" + this.goldenFileName);
    }

    @Override
    public void tearDown() {
        this.removeResource();
    }

    public void testImportLibrary() throws Exception {
        this.openDesign(this.fileName);
        this.designHandle.includeLibrary(this.inputLibraryName, "LibA");
        LibraryHandle libHandle = this.designHandle.getLibrary("LibA");
        TextItemHandle textLibHandle = (TextItemHandle)libHandle.findElement("myText");
        LibraryImportTest.assertNotNull((String)"Text should not be null", (Object)textLibHandle);
        TableHandle tableLibHandle = (TableHandle)libHandle.findElement("myTable");
        LibraryImportTest.assertNotNull((String)"Table should not be null", (Object)tableLibHandle);
        SharedStyleHandle styleLibHandle = libHandle.findStyle("myStyle");
        LibraryImportTest.assertNotNull((String)"Style should not be null", (Object)styleLibHandle);
        ParameterHandle parameterLibHandle = libHandle.findParameter("Parameter1");
        LibraryImportTest.assertNotNull((String)"Parameter should not be null", (Object)parameterLibHandle);
        LabelHandle labelLibHandle = (LabelHandle)libHandle.findElement("myLabel");
        LibraryImportTest.assertNotNull((String)"Label should not be null", (Object)labelLibHandle);
        ImageHandle imageLibHandle = (ImageHandle)libHandle.findElement("myImage");
        LibraryImportTest.assertNotNull((String)"Image should not be null", (Object)imageLibHandle);
        DataItemHandle dataLibHandle = (DataItemHandle)libHandle.findElement("myData");
        LibraryImportTest.assertNotNull((String)"Data should not be null", (Object)dataLibHandle);
        DataSourceHandle dataSourceLibHandle = libHandle.findDataSource("db2d");
        LibraryImportTest.assertNotNull((String)"Datasource should not be null", (Object)dataSourceLibHandle);
        DataSetHandle dataSetLibHandle = libHandle.findDataSet("db2ds");
        LibraryImportTest.assertNotNull((String)"Dataset should not be null", (Object)dataSetLibHandle);
        TextItemHandle textHandle = (TextItemHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)textLibHandle, "myText");
        TableHandle tableHandle = (TableHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)tableLibHandle, "myTable");
        SharedStyleHandle styleHandle = this.designHandle.getElementFactory().newStyle("myStyle");
        ParameterHandle parameterHandle = (ParameterHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)parameterLibHandle, "Parameter1");
        LabelHandle labelHandle = (LabelHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)labelLibHandle, "myLabel");
        ImageHandle imageHandle = (ImageHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)imageLibHandle, "myImage");
        DataItemHandle dataHandle = (DataItemHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)dataLibHandle, "myData");
        OdaDataSourceHandle dataSourceHandle = this.designHandle.getElementFactory().newOdaDataSource("db2d");
        OdaDataSetHandle dataSetHandle = this.designHandle.getElementFactory().newOdaDataSet("db2ds");
        this.designHandle.getDataSources().add((DesignElementHandle)dataSourceHandle);
        this.designHandle.getDataSets().add((DesignElementHandle)dataSetHandle);
        this.designHandle.getStyles().add((DesignElementHandle)styleHandle);
        this.designHandle.getBody().add((DesignElementHandle)dataHandle);
        this.designHandle.getParameters().add((DesignElementHandle)parameterHandle);
        this.designHandle.getBody().add((DesignElementHandle)textHandle);
        this.designHandle.getBody().add((DesignElementHandle)labelHandle);
        this.designHandle.getBody().add((DesignElementHandle)tableHandle);
        this.designHandle.getBody().add((DesignElementHandle)imageHandle);
        LibraryImportTest.assertNotNull((Object)this.designHandle);
        String TempFile = this.genOutputFile(this.outputFileName);
        this.designHandle.saveAs(TempFile);
        LibraryImportTest.assertTrue((boolean)this.compareTextFile(this.goldenFileName, this.outputFileName));
    }
}

