/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.testutil;

import junit.framework.TestCase;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.elements.ReportDesign;

public abstract class BaseTestCase
extends TestCase {
    private ReportDesignHandle report;

    public BaseTestCase() {
    }

    public BaseTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.loadFile(this.getLoadFile());
        this.report = (ReportDesignHandle)SessionHandleAdapter.getInstance().getReportDesignHandle();
    }

    protected void tearDown() throws Exception {
        this.report.close();
        this.report = null;
    }

    private void loadFile(String fileName) throws DesignFileException {
        ModuleHandle module = SessionHandleAdapter.getInstance().init(fileName, BaseTestCase.class.getResourceAsStream(fileName));
        SessionHandleAdapter.getInstance().setReportDesignHandle(module);
    }

    protected String getLoadFile() {
        return "test.rptdesign";
    }

    protected ReportDesign getReportDesign() {
        return this.report.getDesign();
    }

    protected ReportDesignHandle getReportDesignHandle() {
        return this.report;
    }
}

