/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.testutil;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.birt.report.designer.testutil.BaseTestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class FileUtil {
    public static IProject createProject(String name) throws CoreException {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = ws.getRoot();
        IProject proj = root.getProject(name);
        if (!proj.exists()) {
            proj.create(null);
        }
        if (!proj.isOpen()) {
            proj.open(null);
        }
        return proj;
    }

    public static void deleteProject(IProject proj) throws CoreException {
        proj.delete(true, null);
    }

    public static IFile createFile(String name, IProject proj) throws CoreException {
        IFile file = proj.getFile(name);
        if (!file.exists()) {
            InputStream in = FileUtil.getNewStream();
            file.create(in, true, null);
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static InputStream getNewStream() {
        return BaseTestCase.class.getResourceAsStream("test.rptdesign");
    }
}

