/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.dnd;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dnd.DesignElementDragAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.ReportResourceEntry;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DragSourceEvent;

public class LibraryDragListener
extends DesignElementDragAdapter {
    public LibraryDragListener(StructuredViewer viewer) {
        super(viewer);
    }

    protected boolean validateTransfer(Object transfer) {
        if (transfer instanceof ReportElementHandle || transfer instanceof EmbeddedImageHandle) {
            if (transfer instanceof ScalarParameterHandle && ((ScalarParameterHandle)transfer).getContainer() instanceof CascadingParameterGroupHandle) {
                return false;
            }
            if (transfer instanceof StyleHandle && ((StyleHandle)transfer).getContainer() instanceof ThemeHandle) {
                return false;
            }
            return !(transfer instanceof DimensionHandle) && !(transfer instanceof LevelHandle) && !(transfer instanceof MeasureHandle) && !(transfer instanceof MeasureGroupHandle);
        }
        return false;
    }

    public void dragStart(DragSourceEvent event) {
        boolean doit;
        boolean bl = doit = !this.getViewer().getSelection().isEmpty();
        if (doit) {
            IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
            List objectList = selection.toList();
            this.selectionList.clear();
            int i = 0;
            while (i < objectList.size()) {
                if (objectList.get(i) instanceof ReportResourceEntry) {
                    this.selectionList.add(((ReportResourceEntry)objectList.get(i)).getReportElement());
                } else {
                    this.selectionList.add(objectList.get(i));
                }
                ++i;
            }
            Object[] objects = this.selectionList.toArray();
            if (this.validateType(objects)) {
                int i2 = 0;
                while (i2 < objects.length) {
                    if (!this.validateTransfer(objects[i2])) {
                        doit = false;
                        break;
                    }
                    ++i2;
                }
            } else {
                doit = false;
            }
            if (doit) {
                TemplateTransfer.getInstance().setTemplate((Object)objects);
            }
        }
        event.doit = doit;
        if (Policy.TRACING_DND_DRAG && doit) {
            System.out.println("DND >> Drag starts.");
        }
    }
}

