/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import org.eclipse.birt.report.designer.core.model.views.property.GroupPropertyHandleWrapper;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.GroupPropertyHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.GroupPropertyHandle;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;

class AdvancedPropertyValueLabelProvider
extends ColumnLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final String PASSWORD_REPLACEMENT = "********";

    AdvancedPropertyValueLabelProvider() {
    }

    public String getText(Object element) {
        String text = this.getStyledText(element).toString();
        return text;
    }

    public StyledString getStyledText(Object element) {
        String value = null;
        GroupPropertyHandle propertyHandle = null;
        if (element instanceof GroupPropertyHandleWrapper && (propertyHandle = ((GroupPropertyHandleWrapper)element).getModel()) != null && propertyHandle.getStringValue() != null) {
            value = propertyHandle.getPropertyDefn().isEncryptable() ? PASSWORD_REPLACEMENT : propertyHandle.getDisplayValue();
        }
        if (value == null) {
            value = this.showAuto(propertyHandle) ? Messages.getString((String)"PropertyEditorFactory.Value.Auto") : "";
        }
        StyledString styledString = new StyledString();
        styledString.append(value);
        if (propertyHandle != null && propertyHandle.getDisplayValue() != null && propertyHandle.getLocalStringValue() == null) {
            styledString.append(" : " + Messages.getString((String)"ReportPropertySheetPage.Value.Inherited"), StyledString.DECORATIONS_STYLER);
        }
        return styledString;
    }

    private boolean showAuto(Object element) {
        if (element == null) {
            return false;
        }
        GroupPropertyHandleProvider handle = GroupPropertyHandleProvider.getInstance();
        if (handle.isReadOnly(element)) {
            return false;
        }
        String[] values = this.getChoiceNames(element);
        if (handle.isBooleanProperty(element) || handle.isColorProperty(element) || handle.isDateTimeProperty(element) || handle.isFontSizeProperty(element) || handle.isDimensionProperty(element) || handle.isElementRefValue(element) || handle.isExpressionProperty(element) || handle.isPassProperty(element) || handle.isBackgroundImageProperty(element) || handle.isBackgroundImageProperty(element)) {
            return false;
        }
        if (values != null && values.length > 0) {
            return !handle.isEditable(element);
        }
        return false;
    }

    private String[] getChoiceNames(Object o) {
        IChoice[] choices;
        String[] values = null;
        if (o instanceof GroupPropertyHandle && ((GroupPropertyHandle)o).getPropertyDefn().getAllowedChoices() != null && (choices = ((GroupPropertyHandle)o).getPropertyDefn().getAllowedChoices().getChoices()).length > 0) {
            values = new String[choices.length];
            int i = 0;
            while (i < choices.length) {
                values[i] = choices[i].getName();
                ++i;
            }
        }
        if (values == null) {
            return new String[0];
        }
        return values;
    }
}

