/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.HTMLActionHandler;
import org.eclipse.birt.report.engine.api.HTMLActionHandlerUtil;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.impl.ActionContent;

public class HTMLActionHandlerTest
extends EngineCase {
    public void testGetURL() {
        HTMLRenderContext context = new HTMLRenderContext();
        context.setBaseURL("http://localhost/birt/servlet");
        context.setImageDirectory("image");
        context.setBaseImageURL("http://localhost/birt/image");
        HTMLActionHandler handler = null;
        ActionContent action = null;
        Action act = null;
        String url = null;
        String[] stringArray = new String[4];
        stringArray[0] = "bookmark";
        stringArray[1] = "";
        stringArray[2] = "/()=?`!\"?$?:;_?????";
        String[] bookmarks = stringArray;
        int size = bookmarks.length;
        int index = 0;
        while (index < size) {
            handler = new HTMLActionHandler();
            action = new ActionContent();
            action.setBookmark(bookmarks[index]);
            act = new Action((IHyperlinkAction)action);
            url = handler.getURL((IAction)act, (Object)context);
            if (bookmarks[index] != null) {
                HTMLActionHandlerTest.assertEquals((String)("#" + bookmarks[index]), (String)url);
            } else {
                HTMLActionHandlerTest.assertNull((Object)url);
            }
            ++index;
        }
    }

    public void testGetURLHyperlink() {
        HTMLRenderContext context = new HTMLRenderContext();
        context.setBaseURL("http://localhost/birt/servlet");
        context.setImageDirectory("image");
        context.setBaseImageURL("http://localhost/birt/image");
        HTMLActionHandler handler = null;
        String target = "_blank";
        ActionContent action = null;
        Action act = null;
        String url = null;
        String[] stringArray = new String[4];
        stringArray[0] = "hyperlink";
        stringArray[1] = "";
        stringArray[2] = "/()=?`!\"?$?:;_?????";
        String[] hyperlinks = stringArray;
        int size = hyperlinks.length;
        int index = 0;
        while (index < size) {
            handler = new HTMLActionHandler();
            action = new ActionContent();
            action.setHyperlink(hyperlinks[index], target);
            act = new Action((IHyperlinkAction)action);
            url = handler.getURL((IAction)act, (Object)context);
            if (hyperlinks[index] != null) {
                HTMLActionHandlerTest.assertEquals((String)hyperlinks[index], (String)url);
            } else {
                HTMLActionHandlerTest.assertNull((Object)url);
            }
            ++index;
        }
    }

    public void testAppendReportDesignName() {
        HTMLActionHandler handler = new HTMLActionHandler();
        StringBuffer buffer = new StringBuffer();
        String reportName = "testReportName";
        String goldenDesignName = "?__report=testReportName";
        HTMLActionHandlerUtil.appendReportDesignName((HTMLActionHandler)handler, (StringBuffer)buffer, (String)reportName);
        HTMLActionHandlerTest.assertTrue((boolean)goldenDesignName.equals(buffer.toString()));
    }

    public void testAppendFormat() {
        HTMLActionHandler handler = new HTMLActionHandler();
        StringBuffer buffer = null;
        String[] formats = new String[]{"html", "pdf"};
        String[] goldenFormats = new String[]{"&__format=html", "&__format=pdf"};
        HTMLActionHandlerTest.assertTrue((formats.length == goldenFormats.length ? 1 : 0) != 0);
        int length = formats.length;
        int index = 0;
        while (index < length) {
            buffer = new StringBuffer();
            HTMLActionHandlerUtil.appendFormat((HTMLActionHandler)handler, (StringBuffer)buffer, (String)formats[index]);
            HTMLActionHandlerTest.assertTrue((boolean)goldenFormats[index].equals(buffer.toString()));
            ++index;
        }
    }
}

