/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;

public class LoggerSettingTest
extends TestCase {
    private ReportEngine createReportEngine(Level logLevel, String fileName) {
        EngineConfig engineConfig = new EngineConfig();
        engineConfig.setLogConfig(null, logLevel);
        engineConfig.setLogFile(fileName);
        return new ReportEngine(engineConfig);
    }

    private void verifyResult(Level level, int handlerNum) {
        Logger bl = Logger.getLogger("org.eclipse.birt.report.engine.api.impl");
        while (bl != null && bl.getLevel() == null) {
            bl = bl.getParent();
        }
        LoggerSettingTest.assertNotNull((Object)bl);
        if (level == null) {
            if (bl.getLevel() != null) {
                LoggerSettingTest.assertEquals((Object)Level.INFO, (Object)bl.getLevel());
            }
            LoggerSettingTest.assertTrue((bl.getHandlers().length <= 1 ? 1 : 0) != 0);
        } else {
            LoggerSettingTest.assertEquals((Object)level, (Object)bl.getLevel());
            LoggerSettingTest.assertEquals((int)handlerNum, (int)bl.getHandlers().length);
        }
    }

    public void test1() {
        this.verifyResult(null, 0);
        ReportEngine r1 = this.createReportEngine(Level.WARNING, null);
        this.verifyResult(Level.WARNING, 1);
        ReportEngine r2 = this.createReportEngine(Level.INFO, null);
        this.verifyResult(Level.INFO, 1);
        ReportEngine r3 = this.createReportEngine(Level.SEVERE, null);
        this.verifyResult(Level.SEVERE, 1);
        ReportEngine r4 = this.createReportEngine(null, null);
        this.verifyResult(Level.SEVERE, 1);
        r4.destroy();
        this.verifyResult(Level.SEVERE, 1);
        r2.destroy();
        this.verifyResult(Level.SEVERE, 1);
        r3.destroy();
        this.verifyResult(Level.WARNING, 1);
        r1.destroy();
        this.verifyResult(Level.WARNING, 0);
    }

    public void test2() {
        ReportEngine r1 = this.createReportEngine(Level.WARNING, null);
        this.verifyResult(Level.WARNING, 1);
        r1.changeLogLevel(Level.INFO);
        this.verifyResult(Level.INFO, 1);
    }
}

