/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.ActionContent;
import org.eclipse.birt.report.engine.content.impl.CellContent;
import org.eclipse.birt.report.engine.content.impl.Column;
import org.eclipse.birt.report.engine.content.impl.ContainerContent;
import org.eclipse.birt.report.engine.content.impl.DataContent;
import org.eclipse.birt.report.engine.content.impl.ForeignContent;
import org.eclipse.birt.report.engine.content.impl.ImageContent;
import org.eclipse.birt.report.engine.content.impl.LabelContent;
import org.eclipse.birt.report.engine.content.impl.PageContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.content.impl.RowContent;
import org.eclipse.birt.report.engine.content.impl.TableBandContent;
import org.eclipse.birt.report.engine.content.impl.TableContent;
import org.eclipse.birt.report.engine.content.impl.TextContent;
import org.eclipse.birt.report.engine.ir.DimensionType;

public class ReportContentReaderAndWriterTest
extends EngineCase {
    protected final int VERSION_1 = 1;
    protected ReportContent reportContent = new ReportContent();

    protected CellContent createCellContent() {
        CellContent content = (CellContent)this.reportContent.createCellContent();
        content.setName("cellTest");
        content.setWidth(new DimensionType(100.0, "100"));
        content.setHeight(new DimensionType("100"));
        ActionContent hyperlink = new ActionContent();
        hyperlink.setHyperlink("link", "target");
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("test", "1");
        hyperlink.setDrillThrough("bookmartTest", true, "reportTest", attr, attr, "target", "html", null);
        content.setHyperlinkAction((IHyperlinkAction)hyperlink);
        content.setRowSpan(10);
        content.setColSpan(11);
        content.setColumn(12);
        return content;
    }

    protected ContainerContent createContainerContent() {
        ContainerContent content = (ContainerContent)this.reportContent.createContainerContent();
        content.setName("ContainerContent");
        content.setHeight(new DimensionType(4.0, "400"));
        ActionContent hyperlink = new ActionContent();
        hyperlink.setHyperlink("link", "target");
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("test", "4");
        hyperlink.setDrillThrough("bookmartTest", true, "reportTest", attr, attr, "target", "html", null);
        content.setHyperlinkAction((IHyperlinkAction)hyperlink);
        return content;
    }

    protected DataContent createDataContent() {
        DataContent content = (DataContent)this.reportContent.createDataContent();
        content.setValue(null);
        content.setLabelText("setLabelText");
        content.setLabelKey("setLabelKey");
        content.getHelpKey();
        return content;
    }

    protected ForeignContent createForeignContent() {
        ForeignContent content = (ForeignContent)this.reportContent.createForeignContent();
        content.setRawType("rawType");
        content.setRawValue(null);
        return content;
    }

    protected ImageContent createImageContent() {
        ImageContent content = (ImageContent)this.reportContent.createImageContent();
        content.setAltText("altText");
        content.setAltTextKey("altTextKey");
        content.setImageSource(1);
        return content;
    }

    protected LabelContent createLabelContent() {
        LabelContent content = (LabelContent)this.reportContent.createLabelContent();
        content.setLabelText("labelText");
        content.setLabelKey("labelTextKey");
        return content;
    }

    protected PageContent createPageContent() {
        PageContent content = (PageContent)this.reportContent.createPageContent();
        content.setPageType("pageType");
        content.setPageHeight(new DimensionType(3.0, "pageHeight"));
        content.setPageNumber(100L);
        return content;
    }

    protected RowContent createRowContent() {
        RowContent content = (RowContent)this.reportContent.createRowContent();
        content.setRowID(100);
        return content;
    }

    protected TableBandContent createTableBandContent() {
        TableBandContent content = (TableBandContent)this.reportContent.createTableBandContent();
        content.setBandType(100);
        return content;
    }

    protected TableContent createTableContent() {
        TableContent content = (TableContent)this.reportContent.createTableContent();
        content.setCaption("captionTest");
        content.setCaptionKey("captionKeyTest");
        content.setHeaderRepeat(true);
        Column column1 = new Column((IReportContent)this.reportContent);
        column1.setWidth(new DimensionType(1.0, "100"));
        content.addColumn((IColumn)column1);
        Column column2 = new Column((IReportContent)this.reportContent);
        column2.setWidth(new DimensionType(2.0, "200"));
        content.addColumn((IColumn)column2);
        return content;
    }

    protected TextContent createTextContent() {
        TextContent content = (TextContent)this.reportContent.createTextContent();
        content.setName("TextTest");
        content.setHeight(new DimensionType(10.0, "100"));
        ActionContent hyperlink = new ActionContent();
        hyperlink.setHyperlink("link", "target");
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("test", "1");
        hyperlink.setDrillThrough("bookmartTest", true, "reportTest", attr, attr, "target", "html", null);
        content.setHyperlinkAction((IHyperlinkAction)hyperlink);
        return content;
    }

    protected void checkActionContent(ActionContent in, ActionContent out) {
        ReportContentReaderAndWriterTest.assertEquals((String)" Bookmark ", (String)in.getBookmark(), (String)out.getBookmark());
        ReportContentReaderAndWriterTest.assertEquals((String)" reportName ", (String)in.getReportName(), (String)out.getReportName());
        ReportContentReaderAndWriterTest.assertEquals((String)" getHyperlink ", (String)in.getHyperlink(), (String)out.getHyperlink());
        ReportContentReaderAndWriterTest.assertEquals((String)" target ", (String)in.getTargetWindow(), (String)out.getTargetWindow());
        ReportContentReaderAndWriterTest.assertEquals((String)" ParameterBindings ", (String)in.getParameterBindings().get("test").toString(), (String)out.getParameterBindings().get("test").toString());
    }

    protected void checkDimensionType(DimensionType in, DimensionType out) {
        ReportContentReaderAndWriterTest.assertEquals((String)" type ", (int)in.getValueType(), (int)out.getValueType());
        if (in.getValueType() == 1) {
            ReportContentReaderAndWriterTest.assertEquals((String)" unitType ", (String)in.getUnits(), (String)out.getUnits());
            ReportContentReaderAndWriterTest.assertEquals((String)" measure ", (double)in.getMeasure(), (double)out.getMeasure(), (double)0.0);
        } else {
            ReportContentReaderAndWriterTest.assertEquals((String)" choice ", (String)in.getChoice(), (String)out.getChoice());
        }
    }

    protected void checkCellContent(CellContent in, CellContent out) {
        ReportContentReaderAndWriterTest.assertEquals((String)" Name ", (String)in.getName(), (String)out.getName());
        this.checkDimensionType(in.getHeight(), out.getHeight());
        this.checkDimensionType(in.getWidth(), out.getWidth());
        ReportContentReaderAndWriterTest.assertEquals((String)" RowSpan ", (int)in.getRowSpan(), (int)out.getRowSpan());
        ReportContentReaderAndWriterTest.assertEquals((String)" ColSpan ", (int)in.getColSpan(), (int)out.getColSpan());
        ReportContentReaderAndWriterTest.assertEquals((String)" Column ", (int)in.getColumn(), (int)out.getColumn());
        this.checkActionContent((ActionContent)in.getHyperlinkAction(), (ActionContent)out.getHyperlinkAction());
    }

    protected void checkContainerContent(ContainerContent in, ContainerContent out) {
        ReportContentReaderAndWriterTest.assertEquals((String)" Name ", (String)in.getName(), (String)out.getName());
        this.checkDimensionType(in.getHeight(), out.getHeight());
        this.checkActionContent((ActionContent)in.getHyperlinkAction(), (ActionContent)out.getHyperlinkAction());
    }

    protected void checkDataContent(DataContent in, DataContent out) {
        ReportContentReaderAndWriterTest.assertEquals((String)" getLabelText ", (String)in.getLabelText(), (String)out.getLabelText());
        ReportContentReaderAndWriterTest.assertEquals((String)" getLabelKey ", (String)in.getLabelKey(), (String)out.getLabelKey());
        ReportContentReaderAndWriterTest.assertEquals((String)" getHelpText ", (String)in.getHelpText(), (String)out.getHelpText());
    }

    protected void checkForeignContent(ForeignContent in, ForeignContent out) {
        ReportContentReaderAndWriterTest.assertEquals((String)" RawType ", (String)in.getRawType(), (String)out.getRawType());
    }

    protected void checkImageContent(ImageContent in, ImageContent out) {
        ReportContentReaderAndWriterTest.assertEquals((String)" AltText ", (String)in.getAltText(), (String)out.getAltText());
        ReportContentReaderAndWriterTest.assertEquals((String)" AltTextKey ", (String)in.getAltTextKey(), (String)out.getAltTextKey());
        ReportContentReaderAndWriterTest.assertEquals((String)" SourceType ", (int)in.getImageSource(), (int)out.getImageSource());
    }

    protected void checkLabelContent(LabelContent in, LabelContent out) {
        ReportContentReaderAndWriterTest.assertEquals((String)" LabelText ", (String)in.getLabelText(), (String)out.getLabelText());
        ReportContentReaderAndWriterTest.assertEquals((String)" LabelTextKey ", (String)in.getLabelKey(), (String)out.getLabelKey());
    }

    protected void checkPageContent(PageContent in, PageContent out) {
        ReportContentReaderAndWriterTest.assertEquals((String)" PageType ", (String)in.getPageType(), (String)out.getPageType());
        this.checkDimensionType(in.getPageHeight(), out.getPageHeight());
        ReportContentReaderAndWriterTest.assertEquals((String)" PageNumber ", (long)in.getPageNumber(), (long)out.getPageNumber());
    }

    protected void checkRowContent(RowContent in, RowContent out) {
        ReportContentReaderAndWriterTest.assertEquals((String)" RowID ", (int)in.getRowID(), (int)out.getRowID());
    }

    protected void checkTableBandContent(TableBandContent in, TableBandContent out) {
        ReportContentReaderAndWriterTest.assertEquals((String)" Type ", (int)in.getBandType(), (int)out.getBandType());
    }

    protected void checkTableContent(TableContent in, TableContent out) {
        ReportContentReaderAndWriterTest.assertEquals((String)" Caption ", (String)in.getCaption(), (String)out.getCaption());
        ReportContentReaderAndWriterTest.assertEquals((String)" CaptionKey ", (String)in.getCaptionKey(), (String)out.getCaptionKey());
        if (in.getColumnCount() == out.getColumnCount()) {
            int i = 0;
            while (i < in.getColumnCount()) {
                Column inColumn = (Column)in.getColumn(i);
                Column outColumn = (Column)out.getColumn(i);
                this.checkDimensionType(inColumn.getWidth(), outColumn.getWidth());
                ++i;
            }
        } else {
            ReportContentReaderAndWriterTest.fail();
        }
    }

    protected void checkTextContent(TextContent in, TextContent out) {
        ReportContentReaderAndWriterTest.assertEquals((String)" Name ", (String)in.getName(), (String)out.getName());
        this.checkDimensionType(in.getHeight(), out.getHeight());
        this.checkActionContent((ActionContent)in.getHyperlinkAction(), (ActionContent)out.getHyperlinkAction());
    }

    public void testReadWriter() {
        try {
            CellContent src = this.createCellContent();
            byte[] buffer = this.doWrite((IContent)src);
            IContent tgt = (IContent)this.doRead(buffer);
            this.checkCellContent((CellContent)tgt, src);
            src = this.createContainerContent();
            buffer = this.doWrite((IContent)src);
            tgt = (IContent)this.doRead(buffer);
            this.checkContainerContent((ContainerContent)tgt, (ContainerContent)src);
            src = this.createDataContent();
            buffer = this.doWrite((IContent)src);
            tgt = (IContent)this.doRead(buffer);
            this.checkDataContent((DataContent)tgt, (DataContent)src);
            src = this.createForeignContent();
            buffer = this.doWrite((IContent)src);
            tgt = (IContent)this.doRead(buffer);
            this.checkForeignContent((ForeignContent)tgt, (ForeignContent)src);
            src = this.createImageContent();
            buffer = this.doWrite((IContent)src);
            tgt = (IContent)this.doRead(buffer);
            this.checkImageContent((ImageContent)tgt, (ImageContent)src);
            src = this.createLabelContent();
            buffer = this.doWrite((IContent)src);
            tgt = (IContent)this.doRead(buffer);
            this.checkLabelContent((LabelContent)tgt, (LabelContent)src);
            src = this.createPageContent();
            buffer = this.doWrite((IContent)src);
            tgt = (IContent)this.doRead(buffer);
            this.checkPageContent((PageContent)tgt, (PageContent)src);
            src = this.createRowContent();
            buffer = this.doWrite((IContent)src);
            tgt = (IContent)this.doRead(buffer);
            this.checkRowContent((RowContent)tgt, (RowContent)src);
            src = this.createTableBandContent();
            buffer = this.doWrite((IContent)src);
            tgt = (IContent)this.doRead(buffer);
            this.checkTableBandContent((TableBandContent)tgt, (TableBandContent)src);
            src = this.createTableContent();
            buffer = this.doWrite((IContent)src);
            tgt = (IContent)this.doRead(buffer);
            this.checkTableContent((TableContent)tgt, (TableContent)src);
            src = this.createTextContent();
            buffer = this.doWrite((IContent)src);
            tgt = (IContent)this.doRead(buffer);
            this.checkTextContent((TextContent)tgt, (TextContent)src);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ReportContentReaderAndWriterTest.fail();
        }
    }

    protected byte[] doWrite(IContent content) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream oo = new DataOutputStream(out);
        IOUtil.writeInt((OutputStream)oo, (int)content.getContentType());
        content.writeContent(oo);
        oo.flush();
        return out.toByteArray();
    }

    protected Object doRead(byte[] buffer) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(buffer);
        DataInputStream oi = new DataInputStream(in);
        Object object = new Object();
        int contentType = IOUtil.readInt((InputStream)oi);
        int version = 1;
        switch (contentType) {
            case 1: {
                CellContent cellContent = (CellContent)this.reportContent.createCellContent();
                cellContent.setVersion(1);
                cellContent.readContent(oi, null);
                object = cellContent;
                break;
            }
            case 2: {
                ContainerContent containerContent = (ContainerContent)this.reportContent.createContainerContent();
                containerContent.setVersion(version);
                containerContent.readContent(oi, null);
                object = containerContent;
                break;
            }
            case 3: {
                DataContent dataContent = (DataContent)this.reportContent.createDataContent();
                dataContent.setVersion(version);
                dataContent.readContent(oi, null);
                object = dataContent;
                break;
            }
            case 4: {
                ForeignContent foreignContent = (ForeignContent)this.reportContent.createForeignContent();
                foreignContent.setVersion(version);
                foreignContent.readContent(oi, null);
                object = foreignContent;
                break;
            }
            case 5: {
                ImageContent imageContent = (ImageContent)this.reportContent.createImageContent();
                imageContent.setVersion(version);
                imageContent.readContent(oi, null);
                object = imageContent;
                break;
            }
            case 6: {
                LabelContent labelContent = (LabelContent)this.reportContent.createLabelContent();
                labelContent.setVersion(version);
                labelContent.readContent(oi, null);
                object = labelContent;
                break;
            }
            case 7: {
                PageContent pageContent = (PageContent)this.reportContent.createPageContent();
                pageContent.setVersion(version);
                pageContent.readContent(oi, null);
                object = pageContent;
                break;
            }
            case 8: {
                RowContent rowContent = (RowContent)this.reportContent.createRowContent();
                rowContent.setVersion(version);
                rowContent.readContent(oi, null);
                object = rowContent;
                break;
            }
            case 9: {
                TableBandContent tableBandContent = (TableBandContent)this.reportContent.createTableBandContent();
                tableBandContent.setVersion(version);
                tableBandContent.readContent(oi, null);
                object = tableBandContent;
                break;
            }
            case 10: {
                TableContent tableContent = (TableContent)this.reportContent.createTableContent();
                tableContent.setVersion(version);
                tableContent.readContent(oi, null);
                object = tableContent;
                break;
            }
            case 11: {
                TextContent textContent = (TextContent)this.reportContent.createTextContent();
                textContent.setVersion(version);
                textContent.readContent(oi, null);
                object = textContent;
                break;
            }
            default: {
                throw new ClassNotFoundException("No class type: " + contentType);
            }
        }
        return object;
    }
}

