/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v2;

import java.util.ArrayList;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.internal.document.v2.PageHintReaderV2;
import org.eclipse.birt.report.engine.internal.document.v2.PageHintWriterV2;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.InstanceIndex;
import org.eclipse.birt.report.engine.presentation.PageHint;
import org.eclipse.birt.report.engine.presentation.PageSection;

public class PageHintTest
extends EngineCase {
    static final String REPORT_DOCUMENT_NAME = ".internal.test.rptdocument";
    static final String REPORT_DOCUMENT_V0 = "org/eclipse/birt/report/engine/internal/document/v2/pagehint_v0.rptdocument";

    public void setUp() {
        this.removeFile(REPORT_DOCUMENT_NAME);
    }

    public void tearDown() {
        this.removeFile(REPORT_DOCUMENT_NAME);
    }

    public void testReadWrite() throws Exception {
        this.doWrite();
        this.doReadV1();
    }

    public void testReadeV0() throws Exception {
        this.copyResource(REPORT_DOCUMENT_V0, REPORT_DOCUMENT_NAME);
        this.doReadV0();
    }

    protected void doWrite() throws Exception {
        FileArchiveWriter archive = new FileArchiveWriter(REPORT_DOCUMENT_NAME);
        PageHintWriterV2 hintWriter = new PageHintWriterV2((IDocArchiveWriter)archive);
        ArrayList hints = this.createPageHintV1();
        int i = 0;
        while (i < hints.size()) {
            hintWriter.writePageHint((IPageHint)((PageHint)hints.get(i)));
            ++i;
        }
        hintWriter.writeTotalPage((long)hints.size());
        hintWriter.close();
        archive.finish();
    }

    protected void doReadV1() throws Exception {
        FileArchiveReader archive = new FileArchiveReader(REPORT_DOCUMENT_NAME);
        PageHintReaderV2 reader = new PageHintReaderV2((IDocArchiveReader)archive);
        long pageNumber = reader.getTotalPage();
        ArrayList<IPageHint> hints = new ArrayList<IPageHint>();
        int i = 1;
        while ((long)i <= pageNumber) {
            hints.add(reader.getPageHint((long)i));
            ++i;
        }
        reader.close();
        archive.close();
        this.checkPageHintV1(hints);
    }

    protected ArrayList createPageHintV1() {
        ArrayList<PageHint> hints = new ArrayList<PageHint>();
        int i = 0;
        while (i < 2) {
            long pageNumber = i + 1;
            PageHint hint = new PageHint(pageNumber, pageNumber * 100L);
            PageSection section = new PageSection();
            section.starts = new InstanceIndex[]{new InstanceIndex(InstanceID.parse((String)"/3"), 100L)};
            section.ends = new InstanceIndex[]{new InstanceIndex(InstanceID.parse((String)"/4"), 100L)};
            hint.addSection(section);
            hints.add(hint);
            ++i;
        }
        return hints;
    }

    protected void checkPageHintV1(ArrayList hints) {
        PageHintTest.assertEquals((int)2, (int)hints.size());
        int i = 0;
        while (i < 2) {
            long pageNumber = i + 1;
            PageHint hint = (PageHint)hints.get(i);
            PageHintTest.assertEquals((long)pageNumber, (long)hint.getPageNumber());
            PageHintTest.assertEquals((long)(pageNumber * 100L), (long)hint.getOffset());
            PageHintTest.assertEquals((int)1, (int)hint.getSectionCount());
            PageSection section = hint.getSection(0);
            PageHintTest.assertEquals((String)"/3", (String)section.starts[0].getInstanceID().toString());
            PageHintTest.assertEquals((long)100L, (long)section.starts[0].getOffset());
            PageHintTest.assertEquals((String)"/4", (String)section.ends[0].getInstanceID().toString());
            PageHintTest.assertEquals((long)100L, (long)section.ends[0].getOffset());
            ++i;
        }
    }

    protected void doReadV0() throws Exception {
        FileArchiveReader archive = new FileArchiveReader(REPORT_DOCUMENT_NAME);
        PageHintReaderV2 reader = new PageHintReaderV2((IDocArchiveReader)archive);
        long pageNumber = reader.getTotalPage();
        PageHintTest.assertEquals((long)pageNumber, (long)2L);
        IPageHint hint = reader.getPageHint(1L);
        this.checkPageHintV0(hint, 1L, 0L, 0L, 500L);
        hint = reader.getPageHint(2L);
        this.checkPageHintV0(hint, 2L, 200L, 600L, 1000L);
        reader.close();
        archive.close();
    }

    protected void checkPageHintV0(IPageHint hint, long number, long offset, long start, long end) {
        PageHintTest.assertTrue((hint != null ? 1 : 0) != 0);
        PageHintTest.assertEquals((long)number, (long)hint.getPageNumber());
        PageHintTest.assertEquals((long)offset, (long)hint.getOffset());
        PageHintTest.assertEquals((int)1, (int)hint.getSectionCount());
        PageHintTest.assertEquals((long)start, (long)hint.getSectionStart(0));
        PageHintTest.assertEquals((long)end, (long)hint.getSectionEnd(0));
    }
}

