/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.parser.AbstractDesignTestCase;

public class TableItemDesignTest
extends AbstractDesignTestCase {
    public void setUp() throws Exception {
        this.loadDesign("table.xml");
    }

    public void testTable() {
        TableItemDesign table = (TableItemDesign)this.report.getContent(0);
        TableItemDesignTest.assertEquals((String)"Table Caption", (String)table.getCaption());
        TableItemDesignTest.assertEquals((int)6, (int)table.getColumnCount());
        ColumnDesign column = table.getColumn(0);
        TableItemDesignTest.assertEquals((String)"7cm", (String)column.getWidth().toString());
        TableBandDesign header = (TableBandDesign)table.getHeader();
        TableItemDesignTest.assertEquals((int)1, (int)header.getRowCount());
        RowDesign row = header.getRow(0);
        TableItemDesignTest.assertEquals((String)row.getBookmark().getScriptText(), (String)"row[\"COLUMN_32\"]");
        TableItemDesignTest.assertEquals((int)1, (int)row.getCellCount());
        CellDesign cell = row.getCell(0);
        TableItemDesignTest.assertEquals((int)6, (int)cell.getColSpan());
        TableItemDesignTest.assertEquals((int)1, (int)cell.getContentCount());
        TableItemDesignTest.assertEquals((int)2, (int)table.getGroupCount());
        GroupDesign group = table.getGroup(0);
        header = (TableBandDesign)group.getHeader();
        TableItemDesignTest.assertEquals((int)1, (int)header.getRowCount());
        row = header.getRow(0);
        TableItemDesignTest.assertEquals((int)6, (int)row.getCellCount());
        cell = row.getCell(0);
        TableItemDesignTest.assertEquals((String)"all", (String)cell.getDrop());
        cell = row.getCell(1);
        TableItemDesignTest.assertEquals((String)"detail", (String)cell.getDrop());
        TableBandDesign footer = (TableBandDesign)group.getFooter();
        TableItemDesignTest.assertEquals((int)1, (int)footer.getRowCount());
        TableBandDesign detail = (TableBandDesign)table.getDetail();
        TableItemDesignTest.assertEquals((int)1, (int)detail.getRowCount());
        TableItemDesignTest.assertEquals((int)1, (int)detail.getRowCount());
    }
}

