/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.FloatPropertyType;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefnFake;
import org.eclipse.birt.report.model.metadata.PropertyTypeTestCase;

public class FloatPropertyTypeTest
extends PropertyTypeTestCase {
    FloatPropertyType type = new FloatPropertyType();
    PropertyDefn propDefn = new PropertyDefnFake();

    @Override
    public void testGetTypeCode() {
        FloatPropertyTypeTest.assertEquals((int)14, (int)this.type.getTypeCode());
    }

    @Override
    public void testGetName() {
        FloatPropertyTypeTest.assertEquals((String)"float", (String)this.type.getName());
    }

    @Override
    public void testValidateValue() throws PropertyValueException {
        FloatPropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, null, this.propDefn, null));
        FloatPropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)""));
        FloatPropertyTypeTest.assertEquals((double)12.34, (double)((Double)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)new Double(12.34))), (double)2.0);
        FloatPropertyTypeTest.assertEquals((double)12.34, (double)((Double)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)new Float(12.34f))), (double)2.0);
        FloatPropertyTypeTest.assertEquals((double)12.34, (double)((Double)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)new BigDecimal(12.34))), (double)2.0);
        FloatPropertyTypeTest.assertEquals((int)12, (int)((Double)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)new Integer(12))).intValue());
        FloatPropertyTypeTest.assertEquals((int)1, (int)((Double)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)new Boolean(true))).intValue());
        FloatPropertyTypeTest.assertEquals((int)0, (int)((Double)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)new Boolean(false))).intValue());
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        FloatPropertyTypeTest.assertEquals((double)1234.123, (double)((Double)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"1,234.123")), (double)3.0);
        FloatPropertyTypeTest.assertEquals((double)1234.123, (double)((Double)this.type.validateValue((Module)this.design, null, this.propDefn, (Object)"1234.123")), (double)3.0);
    }

    @Override
    public void testValidateInputString() throws PropertyValueException {
        FloatPropertyTypeTest.assertEquals(null, (Object)this.type.validateInputString((Module)this.design, null, this.propDefn, null));
        FloatPropertyTypeTest.assertEquals(null, (Object)this.type.validateInputString((Module)this.design, null, this.propDefn, ""));
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        FloatPropertyTypeTest.assertEquals((double)1234.123, (double)((Double)this.type.validateInputString((Module)this.design, null, this.propDefn, "1,234.123")), (double)3.0);
        FloatPropertyTypeTest.assertEquals((double)1234.123, (double)((Double)this.type.validateInputString((Module)this.design, null, this.propDefn, "1234.123")), (double)3.0);
    }

    @Override
    public void testValidateXml() throws PropertyValueException {
        FloatPropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, null, this.propDefn, null));
        FloatPropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, null, this.propDefn, (Object)""));
        FloatPropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, null, this.propDefn, (Object)"  "));
        FloatPropertyTypeTest.assertEquals((double)12.34, (double)((Double)this.type.validateXml(null, null, null, (Object)"12.34")), (double)2.0);
        try {
            this.type.validateXml((Module)this.design, null, this.propDefn, (Object)"abc.abc");
            FloatPropertyTypeTest.fail();
        }
        catch (PropertyValueException propertyValueException) {
            // empty catch block
        }
    }

    @Override
    public void testToDouble() {
        FloatPropertyTypeTest.assertEquals((double)0.0, (double)this.type.toDouble((Module)this.design, null), (double)1.0);
        FloatPropertyTypeTest.assertEquals((double)0.0, (double)this.type.toDouble((Module)this.design, (Object)new Double(0.0)), (double)1.0);
    }

    @Override
    public void testToInteger() {
        FloatPropertyTypeTest.assertEquals((int)0, (int)this.type.toInteger((Module)this.design, null));
        FloatPropertyTypeTest.assertEquals((int)0, (int)this.type.toInteger((Module)this.design, (Object)new Double(0.0)));
    }

    @Override
    public void testToXml() {
        ULocale preULocale = ULocale.getDefault();
        ULocale.setDefault((ULocale)ULocale.GERMAN);
        FloatPropertyTypeTest.assertEquals(null, (String)this.type.toXml((Module)this.design, this.propDefn, null));
        FloatPropertyTypeTest.assertEquals((String)"123.456", (String)this.type.toXml((Module)this.design, this.propDefn, (Object)new Double(123.456)));
        FloatPropertyTypeTest.assertEquals((String)"123456.789", (String)this.type.toXml((Module)this.design, this.propDefn, (Object)new Double("123456.789")));
        ULocale.setDefault((ULocale)ULocale.ENGLISH);
        FloatPropertyTypeTest.assertEquals(null, (String)this.type.toXml((Module)this.design, this.propDefn, null));
        FloatPropertyTypeTest.assertEquals((String)"123.456", (String)this.type.toXml((Module)this.design, this.propDefn, (Object)new Double(123.456)));
        FloatPropertyTypeTest.assertEquals((String)"123456.789", (String)this.type.toXml((Module)this.design, this.propDefn, (Object)new Double("123456.789")));
        ULocale.setDefault((ULocale)preULocale);
    }

    @Override
    public void testToString() {
        FloatPropertyTypeTest.assertEquals(null, (String)this.type.toString((Module)this.design, this.propDefn, null));
        FloatPropertyTypeTest.assertEquals((String)"123.456", (String)this.type.toString((Module)this.design, this.propDefn, (Object)new Double(123.456)));
        FloatPropertyTypeTest.assertEquals((String)"3.0", (String)this.type.toString((Module)this.design, this.propDefn, (Object)new Double(3.0)));
        FloatPropertyTypeTest.assertEquals((String)"1234567890123456800000000.0", (String)this.type.toString((Module)this.design, this.propDefn, (Object)new Double(1.2345678901234568E24)));
    }

    @Override
    public void testToDisplayString() {
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        FloatPropertyTypeTest.assertEquals(null, (String)this.type.toString((Module)this.design, this.propDefn, null));
        FloatPropertyTypeTest.assertEquals((String)"123456.789", (String)this.type.toString((Module)this.design, this.propDefn, (Object)new Double(123456.789)));
    }

    @Override
    public void testToNumber() {
        FloatPropertyTypeTest.assertEquals((double)0.0, (double)this.type.toNumber((Module)this.design, null).doubleValue(), (double)1.0);
        FloatPropertyTypeTest.assertEquals((double)0.0, (double)this.type.toNumber((Module)this.design, (Object)new Double(0.0)).doubleValue(), (double)1.0);
    }

    @Override
    public void testToBoolean() {
    }
}

