/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.ColumnBindingUtil;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ColumnBindingUtilTest
extends BaseTestCase {
    public void testAddColumnBinding() throws Exception {
        this.createDesign();
        TableHandle table = this.designHandle.getElementFactory().newTableItem(null);
        this.designHandle.getBody().add((DesignElementHandle)table);
        PropertyHandle propHandle = table.getPropertyHandle("boundDataColumns");
        ComputedColumn column = StructureFactory.createComputedColumn();
        column.setName("column");
        column.setDisplayName("Column Name");
        column.setDataType("date-time");
        column.setExpression("test expression");
        column.setAggregateOn("testAggregate");
        column.setFilterExpression("test filter expression");
        ComputedColumnHandle boundColumn = ColumnBindingUtil.addColumnBinding((ReportItemHandle)table, (ComputedColumn)column);
        ColumnBindingUtilTest.assertEquals((int)1, (int)propHandle.getItems().size());
        ColumnBindingUtilTest.assertNotNull((Object)boundColumn);
        ColumnBindingUtilTest.assertEquals((Object)column, (Object)boundColumn.getStructure());
        ComputedColumn copiedColumn = (ComputedColumn)column.copy();
        copiedColumn.setName("new column");
        ComputedColumnHandle newBoundColumn = ColumnBindingUtil.addColumnBinding((ReportItemHandle)table, (ComputedColumn)copiedColumn);
        ColumnBindingUtilTest.assertEquals((int)1, (int)propHandle.getItems().size());
        ColumnBindingUtilTest.assertEquals((Object)boundColumn.getContext(), (Object)newBoundColumn.getContext());
        ColumnBindingUtilTest.assertEquals((String)"column", (String)newBoundColumn.getName());
        copiedColumn = (ComputedColumn)column.copy();
        copiedColumn.setDataType("string");
        ColumnBindingUtilTest.assertEquals((String)"column_1", (String)ColumnBindingUtil.addColumnBinding((ReportItemHandle)table, (ComputedColumn)copiedColumn).getName());
        ColumnBindingUtilTest.assertEquals((int)2, (int)propHandle.getItems().size());
        copiedColumn = (ComputedColumn)column.copy();
        copiedColumn.setFilterExpression("new filter expression");
        ColumnBindingUtilTest.assertEquals((String)"column_2", (String)ColumnBindingUtil.addColumnBinding((ReportItemHandle)table, (ComputedColumn)copiedColumn).getName());
        ColumnBindingUtilTest.assertEquals((int)3, (int)propHandle.getItems().size());
        try {
            ColumnBindingUtil.addColumnBinding((ReportItemHandle)table, (ComputedColumn)StructureFactory.createComputedColumn());
            ColumnBindingUtilTest.fail();
        }
        catch (SemanticException e) {
            ColumnBindingUtilTest.assertTrue((boolean)(e instanceof PropertyValueException));
            ColumnBindingUtilTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)e.getErrorCode());
        }
    }
}

