/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import junit.framework.TestCase;
import org.eclipse.birt.report.model.api.util.CubeUtil;

public class CubeUtilTest
extends TestCase {
    public void testSplitLevelName() {
        String levelName = null;
        String[] results = CubeUtil.splitLevelName(levelName);
        CubeUtilTest.assertEquals((int)2, (int)results.length);
        CubeUtilTest.assertNull((Object)results[0]);
        CubeUtilTest.assertNull((Object)results[1]);
        levelName = " ";
        results = CubeUtil.splitLevelName((String)levelName);
        CubeUtilTest.assertEquals((int)2, (int)results.length);
        CubeUtilTest.assertNull((Object)results[0]);
        CubeUtilTest.assertEquals((String)levelName, (String)results[1]);
        levelName = "testLevel";
        results = CubeUtil.splitLevelName((String)levelName);
        CubeUtilTest.assertEquals((int)2, (int)results.length);
        CubeUtilTest.assertNull((Object)results[0]);
        CubeUtilTest.assertEquals((String)levelName, (String)results[1]);
        levelName = "/testLevel";
        results = CubeUtil.splitLevelName((String)levelName);
        CubeUtilTest.assertEquals((int)2, (int)results.length);
        CubeUtilTest.assertEquals((String)"", (String)results[0]);
        CubeUtilTest.assertEquals((String)levelName.substring(1), (String)results[1]);
        levelName = "testDimension/testLevel";
        results = CubeUtil.splitLevelName((String)levelName);
        CubeUtilTest.assertEquals((int)2, (int)results.length);
        CubeUtilTest.assertEquals((String)"testDimension", (String)results[0]);
        CubeUtilTest.assertEquals((String)"testLevel", (String)results[1]);
        levelName = "test/testDimension/testLevel";
        results = CubeUtil.splitLevelName((String)levelName);
        CubeUtilTest.assertEquals((int)2, (int)results.length);
        CubeUtilTest.assertEquals((String)"test/testDimension", (String)results[0]);
        CubeUtilTest.assertEquals((String)"testLevel", (String)results[1]);
    }

    public void testGetFullLevelName() {
        String dimensionName = null;
        String levelName = null;
        CubeUtilTest.assertEquals(levelName, (String)CubeUtil.getFullLevelName(dimensionName, levelName));
        dimensionName = " ";
        levelName = "levelName";
        CubeUtilTest.assertEquals((String)levelName, (String)CubeUtil.getFullLevelName((String)dimensionName, (String)levelName));
        levelName = null;
        dimensionName = "dimensionName";
        CubeUtilTest.assertNull((Object)CubeUtil.getFullLevelName((String)dimensionName, (String)levelName));
        levelName = " ";
        CubeUtilTest.assertNull((Object)CubeUtil.getFullLevelName((String)dimensionName, (String)levelName));
        levelName = "levelName";
        CubeUtilTest.assertEquals((String)"dimensionName/levelName", (String)CubeUtil.getFullLevelName((String)dimensionName, (String)levelName));
    }
}

