/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class ColumnHandleTest
extends BaseTestCase {
    static final String INPUT = "ColumnHandleTest.xml";

    public ColumnHandleTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ColumnHandleTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(INPUT, INPUT);
    }

    public void testGetColumnProperty() throws Exception {
        this.openDesign(INPUT);
        TableHandle table = (TableHandle)this.designHandle.findElement("My Table");
        ColumnHandleTest.assertNotNull((String)"should not be null", (Object)table);
        ColumnHandle column = (ColumnHandle)table.getColumns().get(0);
        column.setRepeatCount(2);
        ColumnHandleTest.assertEquals((int)2, (int)column.getRepeatCount());
        DimensionHandle dh = column.getWidth();
        ColumnHandleTest.assertEquals((double)100.0, (double)dh.getMeasure(), (double)0.0);
        ColumnHandleTest.assertEquals((String)"pt", (String)dh.getUnits());
        ColumnHandleTest.assertFalse((boolean)column.suppressDuplicates());
        column.setSuppressDuplicates(true);
        ColumnHandleTest.assertTrue((boolean)column.suppressDuplicates());
        this.designHandle.getCommandStack().undo();
        ColumnHandleTest.assertFalse((boolean)column.suppressDuplicates());
        this.designHandle.getCommandStack().redo();
        ColumnHandleTest.assertTrue((boolean)column.suppressDuplicates());
        ElementFactory factory = new ElementFactory(this.designHandle.getModule());
        GridHandle grid = factory.newGridItem("mygrid", 3, 3);
        ColumnHandle gridcolumn = (ColumnHandle)grid.getColumns().get(0);
        ColumnHandleTest.assertFalse((boolean)gridcolumn.suppressDuplicates());
    }
}

