/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.ILinkLabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class LinkSection
extends PDESection {
    private ILinkLabelProvider labelProvider;
    private IStructuredContentProvider contentProvider;
    private Composite linkContainer;
    private Composite container;
    private Button moreButton;
    private String morePageId;
    private int linkNumberLimit = 20;
    private final LinkHandler linkHandler;

    public LinkSection(PDEFormPage page, Composite parent, int style) {
        super(page, parent, style);
        FormToolkit toolkit = page.getManagedForm().getToolkit();
        this.linkHandler = new LinkHandler();
        this.createClient(this.getSection(), toolkit);
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        this.container = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.container.setLayout((Layout)layout);
        section.setClient((Control)this.container);
        this.linkContainer = toolkit.createComposite(this.container);
        this.linkContainer.setLayoutData((Object)new GridData(1808));
        GridLayout linkLayout = new GridLayout();
        linkLayout.marginWidth = 0;
        linkLayout.marginHeight = 0;
        linkLayout.verticalSpacing = 0;
        this.linkContainer.setLayout((Layout)linkLayout);
    }

    private void createMoreButton() {
        this.moreButton = this.getManagedForm().getToolkit().createButton(this.container, "More...", 8);
        this.moreButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> BusyIndicator.showWhile((Display)this.getSection().getDisplay(), () -> {
            IFormPage iFormPage = this.getPage().getEditor().setActivePage(this.morePageId);
        })));
        this.moreButton.setLayoutData((Object)new GridData(2));
    }

    public void add(Object[] links) {
        Object[] objectArray = links;
        int n = links.length;
        int n2 = 0;
        while (n2 < n) {
            Object link = objectArray[n2];
            this.createLink(link);
            ++n2;
        }
        this.updateMoreState(this.linkContainer.getChildren().length > this.linkNumberLimit);
        this.reflow();
    }

    public void remove(Object[] links) {
        Object[] objectArray = links;
        int n = links.length;
        int n2 = 0;
        while (n2 < n) {
            Object link = objectArray[n2];
            this.disposeLink(link);
            ++n2;
        }
        this.updateMoreState(this.linkContainer.getChildren().length > this.linkNumberLimit);
        this.reflow();
    }

    private void disposeLink(Object obj) {
        Hyperlink link = this.find(obj);
        if (link != null) {
            link.dispose();
        }
    }

    private Hyperlink find(Object object) {
        Control[] children;
        Control[] controlArray = children = this.linkContainer.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child.getData().equals(object)) {
                return (Hyperlink)child;
            }
            ++n2;
        }
        return null;
    }

    public void update(Object[] links) {
        Object[] objectArray = links;
        int n = links.length;
        int n2 = 0;
        while (n2 < n) {
            Object link = objectArray[n2];
            this.update(link);
            ++n2;
        }
        this.reflow();
    }

    private void update(Object object) {
        Hyperlink link = this.find(object);
        if (link != null) {
            this.update(link, object);
        }
    }

    private void update(Hyperlink hyperlink, Object object) {
        String text = this.labelProvider != null ? this.labelProvider.getText(object) : object.toString();
        Image image = this.labelProvider != null ? this.labelProvider.getImage(object) : null;
        String tooltip = this.labelProvider != null ? this.labelProvider.getToolTipText(object) : text;
        hyperlink.setText(text);
        hyperlink.setToolTipText(tooltip);
        if (hyperlink instanceof ImageHyperlink) {
            ((ImageHyperlink)hyperlink).setImage(image);
        }
        this.reflow();
    }

    public void refresh() {
        Control[] children;
        Control[] controlArray = children = this.linkContainer.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.createLinks();
        this.reflow();
    }

    private void reflow() {
        this.linkContainer.layout();
        this.container.layout();
        this.getManagedForm().reflow(true);
    }

    private void createLinks() {
        if (this.contentProvider == null) {
            return;
        }
        Object[] objects = this.contentProvider.getElements(this.getManagedForm().getInput());
        int i = 0;
        while (i < objects.length) {
            if (i == this.linkNumberLimit) break;
            this.createLink(objects[i]);
            ++i;
        }
        if (objects.length > this.linkNumberLimit) {
            this.getManagedForm().getToolkit().createLabel(this.linkContainer, "...", 0);
        }
        this.updateMoreState(objects.length > this.linkNumberLimit);
    }

    private void updateMoreState(boolean needMore) {
        if (needMore && this.moreButton == null) {
            this.createMoreButton();
        } else if (!needMore && this.moreButton != null) {
            this.moreButton.dispose();
            this.moreButton = null;
        }
    }

    private void createLink(Object object) {
        ImageHyperlink hyperlink;
        Image image;
        Image image2 = image = this.labelProvider != null ? this.labelProvider.getImage(object) : null;
        if (image != null) {
            hyperlink = this.getManagedForm().getToolkit().createImageHyperlink(this.linkContainer, 0);
            hyperlink.setImage(image);
        } else {
            hyperlink = this.getManagedForm().getToolkit().createHyperlink(this.linkContainer, null, 0);
        }
        this.update((Hyperlink)hyperlink, object);
        hyperlink.setData(object);
        hyperlink.addHyperlinkListener((IHyperlinkListener)this.linkHandler);
    }

    private void doEnter(Hyperlink link) {
        String statusText = this.labelProvider != null ? this.labelProvider.getStatusText(link.getData()) : link.getText();
        this.getPage().getEditorSite().getActionBars().getStatusLineManager().setMessage(statusText);
    }

    private void doExit(Hyperlink link) {
        this.getPage().getEditorSite().getActionBars().getStatusLineManager().setMessage(null);
    }

    protected void doLinkActivated(Hyperlink link) {
        Object object = link.getData();
        this.getPage().getEditor().setActivePage(this.morePageId, object);
    }

    public void setMorePageId(String id) {
        this.morePageId = id;
    }

    public void setLinkNumberLimit(int limit) {
        this.linkNumberLimit = limit;
    }

    public void setContentProvider(IStructuredContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public void setLabelProvider(ILinkLabelProvider provider) {
        this.labelProvider = provider;
    }

    class LinkHandler
    implements IHyperlinkListener {
        LinkHandler() {
        }

        public void linkActivated(HyperlinkEvent e) {
            LinkSection.this.doLinkActivated((Hyperlink)e.widget);
        }

        public void linkEntered(HyperlinkEvent e) {
            LinkSection.this.doEnter((Hyperlink)e.widget);
        }

        public void linkExited(HyperlinkEvent e) {
            LinkSection.this.doExit((Hyperlink)e.widget);
        }
    }
}

