/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.series;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.type.BubbleSeries;
import org.eclipse.birt.chart.model.type.impl.BubbleSeriesImpl;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.model.util.DefaultValueProvider;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartCheckbox;
import org.eclipse.birt.chart.ui.swt.ChartCombo;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class BubbleSeriesAttributeComposite
extends Composite
implements SelectionListener,
Listener {
    private transient FillChooserComposite fccShadow = null;
    private transient Group grpLine = null;
    private transient LineAttributesComposite liacLine = null;
    private transient Group grpAccLine = null;
    private transient LineAttributesComposite liacAccLine = null;
    private transient Label lblOrientation = null;
    private transient ChartCombo cmbOrientation;
    private transient Series series = null;
    private BubbleSeries defSeries = DefaultValueProvider.defBubbleSeries();
    private transient Label lblShadow = null;
    ChartWizardContext context;
    private ChartCheckbox btnPalette;
    private ChartCheckbox btnCurve;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/swt.series");

    public BubbleSeriesAttributeComposite(Composite parent, int style, ChartWizardContext context, Series series) {
        super(parent, style);
        if (!(series instanceof BubbleSeriesImpl)) {
            try {
                throw new ChartException("org.eclipse.birt.chart.ui.extension", 30, "BubbleSeriesAttributeComposite.Exception.IllegalArgument", new Object[]{series.getClass().getName()}, Messages.getResourceBundle());
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
                e.printStackTrace();
            }
        }
        this.series = series;
        this.context = context;
        this.init();
        this.placeComponents();
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatBubbleChartYSeries_ID");
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout(3, true);
        glContent.marginHeight = 2;
        glContent.marginWidth = 2;
        this.setLayout((Layout)glContent);
        if (this.supportAccelerationLine()) {
            this.grpAccLine = new Group((Composite)this, 0);
            GridData gdGRPAccLine = new GridData(768);
            GridLayout glGRPAccline = new GridLayout(2, false);
            glGRPAccline.verticalSpacing = 0;
            this.grpAccLine.setLayout((Layout)glGRPAccline);
            this.grpAccLine.setLayoutData((Object)gdGRPAccLine);
            this.grpAccLine.setText(Messages.getString("BubbleSeriesAttributeComposite.Lbl.AccLine"));
            this.liacAccLine = new LineAttributesComposite((Composite)this.grpAccLine, 0, this.context, ((BubbleSeries)this.series).getAccLineAttributes(), true, true, true, true, true, this.defSeries.getAccLineAttributes());
            GridData gdLIACAccLine = new GridData(1808);
            gdLIACAccLine.horizontalSpan = 2;
            this.liacAccLine.setLayoutData(gdLIACAccLine);
            this.liacAccLine.addListener(this);
            Composite cmpOrientation = new Composite((Composite)this.grpAccLine, 0);
            GridLayout gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            gl.marginBottom = 0;
            gl.verticalSpacing = 0;
            cmpOrientation.setLayout((Layout)gl);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            cmpOrientation.setLayoutData((Object)gd);
            this.lblOrientation = new Label(cmpOrientation, 0);
            this.lblOrientation.setText(Messages.getString("BubbleSeriesAttributeComposite.Lbl.Orientation"));
            this.cmbOrientation = this.context.getUIFactory().createChartCombo(cmpOrientation, 12, (EObject)this.series, "accOrientation", this.defSeries.getAccOrientation().getName());
            GridData gdCMBOrientation = new GridData(768);
            this.cmbOrientation.setLayoutData((Object)gdCMBOrientation);
            this.cmbOrientation.addSelectionListener((SelectionListener)this);
        }
        this.grpLine = new Group((Composite)this, 0);
        GridData gdGRPLine = new GridData(768);
        gdGRPLine.horizontalSpan = 2;
        this.grpLine.setLayoutData((Object)gdGRPLine);
        GridLayout glLine = new GridLayout(2, false);
        glLine.horizontalSpacing = 0;
        this.grpLine.setLayout((Layout)glLine);
        this.grpLine.setText(Messages.getString("BubbleSeriesAttributeComposite.Lbl.Line"));
        Composite cmpLine = new Composite((Composite)this.grpLine, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        cmpLine.setLayout((Layout)gl);
        cmpLine.setLayoutData((Object)new GridData(1808));
        this.liacLine = new LineAttributesComposite(cmpLine, 0, this.context, ((BubbleSeries)this.series).getLineAttributes(), true, true, true, true, true, this.defSeries.getLineAttributes());
        GridData gdLIACLine = new GridData(768);
        gdLIACLine.horizontalSpan = 2;
        this.liacLine.setLayoutData(gdLIACLine);
        this.liacLine.addListener(this);
        if (this.supportLineShadow()) {
            Composite cmpShadow = new Composite(cmpLine, 0);
            GridLayout gl2 = new GridLayout(2, false);
            gl2.marginHeight = 0;
            gl2.marginBottom = 0;
            gl2.verticalSpacing = 0;
            cmpShadow.setLayout((Layout)gl2);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            cmpShadow.setLayoutData((Object)gd);
            this.lblShadow = new Label(cmpShadow, 0);
            this.lblShadow.setText(Messages.getString("BubbleSeriesAttributeComposite.Lbl.ShadowColor"));
            int iFillOption = 156;
            this.fccShadow = new FillChooserComposite(cmpShadow, 12, iFillOption, this.context, (Fill)((BubbleSeries)this.series).getShadowColor());
            GridData gdFCCShadow = new GridData(768);
            this.fccShadow.setLayoutData(gdFCCShadow);
            this.fccShadow.addListener(this);
        }
        Composite cmp = new Composite((Composite)this.grpLine, 0);
        cmp.setLayout((Layout)new GridLayout(1, false));
        this.btnPalette = this.context.getUIFactory().createChartCheckbox(cmp, 0, this.defSeries.isPaletteLineColor());
        this.btnPalette.setText(Messages.getString("BubbleSeriesAttributeComposite.Lbl.LinePalette"));
        this.btnPalette.setSelectionState(((BubbleSeries)this.series).isSetPaletteLineColor() ? (((BubbleSeries)this.series).isPaletteLineColor() ? 1 : 2) : 0);
        this.btnPalette.addSelectionListener((SelectionListener)this);
        if (this.supportShowLineAsCurve()) {
            this.btnCurve = this.context.getUIFactory().createChartCheckbox(cmp, 0, this.defSeries.isCurve());
            this.btnCurve.setText(Messages.getString("BubbleSeriesAttributeComposite.Lbl.ShowLinesAsCurves"));
            this.btnCurve.setSelectionState(((BubbleSeries)this.series).isSetCurve() ? (((BubbleSeries)this.series).isCurve() ? 1 : 2) : 0);
            this.btnCurve.addSelectionListener((SelectionListener)this);
        }
        this.enableLineSettings(!this.context.getUIFactory().isSetInvisible((EObject)((BubbleSeries)this.series).getLineAttributes()));
        this.enableAccLineSettings(!this.context.getUIFactory().isSetInvisible((EObject)((BubbleSeries)this.series).getAccLineAttributes()));
        this.populateLists();
    }

    protected boolean supportLineShadow() {
        return true;
    }

    protected boolean supportShowLineAsCurve() {
        return true;
    }

    protected boolean supportAccelerationLine() {
        return true;
    }

    private void populateLists() {
        if (this.cmbOrientation != null) {
            NameSet ns = LiteralHelper.orientationSet;
            this.cmbOrientation.setItems(ns.getDisplayNames());
            this.cmbOrientation.setItemData(ns.getNames());
            this.cmbOrientation.setSelection(((BubbleSeries)this.series).getAccOrientation().getName());
        }
    }

    public Point getPreferredSize() {
        return new Point(400, 200);
    }

    public void widgetSelected(SelectionEvent e) {
        String selectedOrientation;
        if (e.getSource().equals(this.btnCurve)) {
            ChartElementUtil.setEObjectAttribute((EObject)this.series, (String)"curve", (Object)(this.btnCurve.getSelectionState() == 1 ? 1 : 0), (this.btnCurve.getSelectionState() == 0 ? 1 : 0) != 0);
        } else if (e.getSource().equals(this.btnPalette)) {
            ChartElementUtil.setEObjectAttribute((EObject)this.series, (String)"paletteLineColor", (Object)(this.btnPalette.getSelectionState() == 1 ? 1 : 0), (this.btnPalette.getSelectionState() == 0 ? 1 : 0) != 0);
        } else if (e.getSource().equals(this.cmbOrientation) && (selectedOrientation = this.cmbOrientation.getSelectedItemData()) != null) {
            ChartElementUtil.setEObjectAttribute((EObject)this.series, (String)"accOrientation", (Object)Orientation.getByName((String)selectedOrientation), (boolean)false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void handleEvent(Event event) {
        boolean isUnset;
        boolean bl = isUnset = event.detail == ChartUIExtensionUtil.PROPERTY_UNSET;
        if (event.widget.equals((Object)this.liacLine)) {
            if (event.type == 4) {
                ChartElementUtil.setEObjectAttribute((EObject)((BubbleSeries)this.series).getLineAttributes(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                this.enableLineSettings(!this.context.getUIFactory().isSetInvisible((EObject)((BubbleSeries)this.series).getLineAttributes()));
            } else if (event.type == 1) {
                ChartElementUtil.setEObjectAttribute((EObject)((BubbleSeries)this.series).getLineAttributes(), (String)"style", (Object)event.data, (boolean)isUnset);
            } else if (event.type == 2) {
                ChartElementUtil.setEObjectAttribute((EObject)((BubbleSeries)this.series).getLineAttributes(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
            } else if (event.type == 3) {
                ((BubbleSeries)this.series).getLineAttributes().setColor((ColorDefinition)event.data);
            }
        } else if (event.widget.equals((Object)this.liacAccLine)) {
            if (event.type == 4) {
                ChartElementUtil.setEObjectAttribute((EObject)((BubbleSeries)this.series).getAccLineAttributes(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                this.enableAccLineSettings(!this.context.getUIFactory().isSetInvisible((EObject)((BubbleSeries)this.series).getAccLineAttributes()));
            } else if (event.type == 1) {
                ChartElementUtil.setEObjectAttribute((EObject)((BubbleSeries)this.series).getAccLineAttributes(), (String)"style", (Object)event.data, (boolean)isUnset);
            } else if (event.type == 2) {
                ChartElementUtil.setEObjectAttribute((EObject)((BubbleSeries)this.series).getAccLineAttributes(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
            } else if (event.type == 3) {
                ((BubbleSeries)this.series).getAccLineAttributes().setColor((ColorDefinition)event.data);
            }
        } else if (event.widget.equals((Object)this.fccShadow)) {
            ((BubbleSeries)this.series).setShadowColor((ColorDefinition)event.data);
        }
    }

    private void enableLineSettings(boolean isEnabled) {
        if (this.lblShadow != null) {
            this.lblShadow.setEnabled(isEnabled);
        }
        if (this.fccShadow != null) {
            this.fccShadow.setEnabled(isEnabled);
        }
        if (this.btnPalette != null) {
            this.btnPalette.setEnabled(isEnabled);
        }
        if (this.btnCurve != null) {
            this.btnCurve.setEnabled(isEnabled);
        }
    }

    private void enableAccLineSettings(boolean isEnabled) {
        if (this.cmbOrientation != null) {
            this.cmbOrientation.setEnabled(isEnabled);
        }
        if (this.lblOrientation != null) {
            this.lblOrientation.setEnabled(isEnabled);
        }
    }
}

