/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.IAbsoluteFontSizeValueProvider;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.command.LibraryChangeEvent;
import org.eclipse.birt.report.model.api.command.ResourceChangeEvent;
import org.eclipse.birt.report.model.api.core.IResourceChangeListener;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.DefaultAbsoluteFontSizeValueProvider;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.parser.DesignReader;
import org.eclipse.birt.report.model.parser.GenericModuleReader;
import org.eclipse.birt.report.model.parser.LibraryReader;
import org.eclipse.birt.report.model.util.LibraryUtil;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.ResourceLocatorImpl;
import org.eclipse.birt.report.model.util.URIUtilImpl;

public class DesignSessionImpl {
    private static final Logger LOG = Logger.getLogger(DesignSessionImpl.class.getName());
    public static final String TOC_DEFAULT_VALUE = "templates/TOCDefaultValue.xml";
    private List<DesignElement> defaultTOCStyleList = null;
    protected String resourceFolder = null;
    protected IResourceLocator resourceLocator = new ResourceLocatorImpl();
    static String resourcePath = null;
    protected IAbsoluteFontSizeValueProvider fontSizeProvider = DefaultAbsoluteFontSizeValueProvider.getInstance();
    protected List<Module> modules = new ArrayList<Module>();
    protected ULocale locale;
    private String units = "in";
    private int colorFormat = 3;
    private HashMap<String, Object> defaultValues = new HashMap();
    private List<IResourceChangeListener> resourceChangeListeners = null;
    private Boolean isTOCStyleInitialized = Boolean.FALSE;

    public DesignSessionImpl(ULocale theLocale) {
        this.locale = theLocale;
        if (this.locale == null) {
            this.locale = ULocale.getDefault();
        }
        this.activate();
    }

    public final void activate() {
        ThreadResources.setLocale(this.locale);
    }

    public final void suspend() {
        ThreadResources.setLocale(null);
    }

    public final ReportDesign openDesign(String fileName) throws DesignFileException {
        return this.openDesign(fileName, (ModuleOption)null);
    }

    public final ReportDesign openDesign(String fileName, ModuleOption options) throws DesignFileException {
        if (fileName == null) {
            throw new IllegalArgumentException("The file name must not be null");
        }
        this.initializeOptions(options);
        ReportDesign design = DesignReader.getInstance().read(this, fileName, options);
        this.modules.add(design);
        return design;
    }

    protected void initializeOptions(ModuleOption options) {
        if (options == null) {
            return;
        }
        if (this.resourceLocator == null) {
            this.resourceLocator = options.getResourceLocator();
        }
        if (this.resourceFolder == null) {
            this.resourceFolder = options.getResourceFolder();
        }
    }

    public final ReportDesign openDesign(String fileName, InputStream is) throws DesignFileException {
        return this.openDesign(fileName, is, null);
    }

    public final ReportDesign openDesign(String fileName, InputStream is, ModuleOption options) throws DesignFileException {
        if (is == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        this.initializeOptions(options);
        ReportDesign design = DesignReader.getInstance().read(this, fileName, is, options);
        this.modules.add(design);
        return design;
    }

    public final ReportDesign openDesign(URL systemId, InputStream is) throws DesignFileException {
        return this.openDesign(systemId, is, null);
    }

    public final ReportDesign openDesign(URL systemId, InputStream is, ModuleOption options) throws DesignFileException {
        if (is == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        ReportDesign design = DesignReader.getInstance().read(this, systemId, is, options);
        this.modules.add(design);
        return design;
    }

    public final Module openModule(String fileName, InputStream is) throws DesignFileException {
        return this.openModule(fileName, is, null);
    }

    public Module openModule(String fileName, InputStream is, ModuleOption options) throws DesignFileException {
        if (is == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        this.initializeOptions(options);
        Module module = GenericModuleReader.getInstance().read(this, fileName, is, options);
        this.modules.add(module);
        return module;
    }

    public final Module openModule(String fileName) throws DesignFileException {
        return this.openModule(fileName, (ModuleOption)null);
    }

    public Module openModule(String fileName, ModuleOption options) throws DesignFileException {
        if (fileName == null) {
            throw new IllegalArgumentException("The file name must not be null");
        }
        this.initializeOptions(options);
        Module module = GenericModuleReader.getInstance().read(this, fileName, options);
        this.modules.add(module);
        return module;
    }

    public final Library openLibrary(String fileName) throws DesignFileException {
        return this.openLibrary(fileName, (ModuleOption)null);
    }

    public final Library openLibrary(String fileName, ModuleOption options) throws DesignFileException {
        if (fileName == null) {
            throw new IllegalArgumentException("The file name must not be null");
        }
        this.initializeOptions(options);
        Library library = LibraryReader.getInstance().read(this, fileName, options);
        this.modules.add(library);
        return library;
    }

    public final Library openLibrary(String fileName, InputStream is) throws DesignFileException {
        return this.openLibrary(fileName, is, null);
    }

    public final Library openLibrary(String fileName, InputStream is, ModuleOption options) throws DesignFileException {
        if (is == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        this.initializeOptions(options);
        Library design = LibraryReader.getInstance().read(this, fileName, is, options);
        this.modules.add(design);
        return design;
    }

    public final Library openLibrary(URL systemId, InputStream is) throws DesignFileException {
        return this.openLibrary(systemId, is, null);
    }

    public final Library openLibrary(URL systemId, InputStream is, ModuleOption options) throws DesignFileException {
        if (is == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        this.initializeOptions(options);
        Library library = LibraryReader.getInstance().read(this, systemId, is, options);
        this.modules.add(library);
        return library;
    }

    public final ReportDesign createDesign(String fileName, ModuleOption options) {
        URL systemId;
        ReportDesign design = new ReportDesign(this);
        design.setID(design.getNextID());
        design.addElementID(design);
        design.setFileName(fileName);
        if (!StringUtil.isBlank(fileName) && (systemId = URIUtilImpl.getDirectory(fileName)) != null) {
            design.setSystemId(systemId);
        }
        if (!this.isBlankCreation(options)) {
            DesignSessionImpl.addExtensionDefaultStyles(design, false);
        }
        if (this.toLatestVersion(options)) {
            design.getVersionManager().setVersion("3.2.26");
        }
        design.setValid(true);
        this.modules.add(design);
        return design;
    }

    private boolean isBlankCreation(ModuleOption options) {
        if (options == null) {
            return false;
        }
        Boolean isSimpleCreation = (Boolean)options.getProperty("blankCreation");
        return isSimpleCreation != null && isSimpleCreation != false;
    }

    private boolean toLatestVersion(ModuleOption options) {
        if (options == null) {
            return false;
        }
        return options.toLatestVersion();
    }

    public final Library createLibraryFromTemplate(String templateName) throws DesignFileException {
        Library library = this.openLibrary(templateName);
        library.setFileName(null);
        this.handleDefaultTheme(library);
        return library;
    }

    public final ReportDesign createDesignFromTemplate(String templateName) throws DesignFileException {
        ReportDesign design = this.openDesign(templateName);
        design.setFileName(null);
        DesignSessionImpl.addExtensionDefaultStyles(design, false);
        return design;
    }

    public final ReportDesign createDesignFromTemplate(String templateName, InputStream is) throws DesignFileException {
        ReportDesign design = this.openDesign(templateName, is);
        design.setFileName(null);
        DesignSessionImpl.addExtensionDefaultStyles(design, false);
        return design;
    }

    public final ReportDesign createDesignFromTemplate(String templateName, InputStream is, ModuleOption options) throws DesignFileException {
        ReportDesign design = this.openDesign(templateName, is, options);
        design.setFileName(null);
        DesignSessionImpl.addExtensionDefaultStyles(design, false);
        return design;
    }

    private static List<Style> findToAddExtensionDefaultStyle(ReportDesign design) {
        ArrayList<Style> retList = new ArrayList<Style>();
        List<Style> defaultStyles = MetaDataDictionary.getInstance().getExtensionFactoryStyles();
        int i = 0;
        while (i < defaultStyles.size()) {
            Style style = defaultStyles.get(i);
            assert (style.getName() != null);
            if (design.findStyle(style.getName()) == null) {
                retList.add(style);
            }
            ++i;
        }
        return retList;
    }

    public static void addExtensionDefaultStyles(ReportDesign design, boolean checkName) {
        List<Style> tmpStyles = DesignSessionImpl.findToAddExtensionDefaultStyle(design);
        int i = 0;
        while (i < tmpStyles.size()) {
            block5: {
                Style style = tmpStyles.get(i);
                Style tmpStyle = null;
                try {
                    tmpStyle = (Style)style.clone();
                }
                catch (CloneNotSupportedException e) {
                    assert (false);
                    break block5;
                }
                if (!checkName || design.findStyle(tmpStyle.getName()) == null) {
                    design.add(tmpStyle, 0);
                    tmpStyle.setID(design.getNextID());
                    design.addElementID(tmpStyle);
                    design.getNameHelper().getNameSpace("style").insert(tmpStyle);
                }
            }
            ++i;
        }
    }

    public final Library createLibrary() {
        Library library = new Library(this);
        library.setID(library.getNextID());
        library.addElementID(library);
        this.handleDefaultTheme(library);
        library.setValid(true);
        this.modules.add(library);
        return library;
    }

    private void handleDefaultTheme(Library library) {
        String themeName = library.getThemeName();
        if (themeName == null) {
            String defaultThemeName = ModelMessages.getMessage("Theme.defaultThemeName");
            Theme theme = library.findNativeTheme(defaultThemeName);
            if (theme != null) {
                return;
            }
            theme = new Theme(defaultThemeName);
            library.setProperty("theme", (Object)new ElementRefValue(null, theme));
            LibraryUtil.insertCompatibleThemeToLibrary(library, theme);
            theme.setID(library.getNextID());
            library.addElementID(theme);
        }
    }

    public final Iterator<ReportDesign> getDesignIterator() {
        ArrayList<ReportDesign> designs = new ArrayList<ReportDesign>(this.modules.size());
        for (Module module : this.modules) {
            if (!(module instanceof ReportDesign)) continue;
            designs.add((ReportDesign)module);
        }
        return designs.iterator();
    }

    public final Iterator<Library> getLibraryIterator() {
        ArrayList<Library> libraries = new ArrayList<Library>(this.modules.size());
        for (Module module : this.modules) {
            if (!(module instanceof Library)) continue;
            libraries.add((Library)module);
        }
        return libraries.iterator();
    }

    public Iterator<Module> getModuleIterator() {
        ArrayList<Module> roots = new ArrayList<Module>(this.modules);
        return roots.iterator();
    }

    public void drop(Module module) {
        this.modules.remove(module);
    }

    public final String getUnits() {
        return this.units;
    }

    public final void setUnits(String newUnits) throws PropertyValueException {
        if (!("cm".equalsIgnoreCase(newUnits) || "in".equalsIgnoreCase(newUnits) || "mm".equalsIgnoreCase(newUnits) || "pc".equalsIgnoreCase(newUnits) || "pt".equalsIgnoreCase(newUnits))) {
            throw new PropertyValueException((Object)newUnits, "Error.PropertyValueException.INVALID_VALUE", 5);
        }
        this.units = newUnits;
    }

    public final void setColorFormat(int format) throws PropertyValueException {
        if (format != 3 && format != 4 && format != 1 && format != 0 && format != 2) {
            throw new PropertyValueException(format, "Error.PropertyValueException.INVALID_VALUE", 5);
        }
        this.colorFormat = format;
    }

    public final int getColorFormat() {
        return this.colorFormat;
    }

    public final void setDefaultValue(String propName, Object value) throws PropertyValueException {
        assert (!StringUtil.isBlank(propName));
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        IElementPropertyDefn propDefn = dd.getStyle().getProperty(propName);
        assert (propDefn != null);
        if (value == null) {
            this.defaultValues.remove(propName);
        } else {
            Object actualValue = ((ElementPropertyDefn)propDefn).validateValue(null, null, value);
            this.defaultValues.put(propName, actualValue);
        }
    }

    public final Object getDefaultValue(String propName) {
        assert (!StringUtil.isBlank(propName));
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        IElementPropertyDefn propDefn = dd.getStyle().getProperty(propName);
        assert (propDefn != null);
        return this.defaultValues.get(propName);
    }

    public final void setResourceLocator(IResourceLocator algorithm) {
        assert (algorithm != null);
        this.resourceLocator = algorithm;
    }

    public final IResourceLocator getResourceLocator() {
        assert (this.resourceLocator != null);
        return this.resourceLocator;
    }

    public final IAbsoluteFontSizeValueProvider getPredefinedFontSizeProvider() {
        return this.fontSizeProvider;
    }

    public final void setPredefinedFontSizeProvider(IAbsoluteFontSizeValueProvider fontSizeProvider) {
        this.fontSizeProvider = fontSizeProvider;
    }

    public final ULocale getLocale() {
        return this.locale;
    }

    public final void fireLibChange(LibraryChangeEvent ev) {
        URL url = ModelUtil.getURLPresentation(ev.getChangedResourcePath());
        if (url == null) {
            return;
        }
        String path = url.toExternalForm();
        Iterator<Module> iter = this.getModuleIterator();
        while (iter.hasNext()) {
            Module module = iter.next();
            if (!module.getLocation().equalsIgnoreCase(path) && module.getLibraryByLocation(path, Integer.MAX_VALUE) == null) continue;
            LibraryChangeEvent event = new LibraryChangeEvent(ev.getChangedResourcePath());
            event.setTarget(module);
            event.setDeliveryPath(ev.getDeliveryPath());
            module.broadcastResourceChangeEvent(event);
        }
        this.broadcastResourceChangeEvent(ev);
    }

    public final void addResourceChangeListener(IResourceChangeListener listener) {
        if (this.resourceChangeListeners == null) {
            this.resourceChangeListeners = new ArrayList<IResourceChangeListener>();
        }
        if (!this.resourceChangeListeners.contains(listener)) {
            this.resourceChangeListeners.add(listener);
        }
    }

    public final boolean removeResourceChangeListener(IResourceChangeListener listener) {
        if (this.resourceChangeListeners == null) {
            return false;
        }
        return this.resourceChangeListeners.remove(listener);
    }

    public final void broadcastResourceChangeEvent(ResourceChangeEvent event) {
        if (this.resourceChangeListeners == null || this.resourceChangeListeners.isEmpty()) {
            return;
        }
        ArrayList<IResourceChangeListener> temp = new ArrayList<IResourceChangeListener>(this.resourceChangeListeners);
        for (IResourceChangeListener listener : temp) {
            listener.resourceChanged(null, event);
        }
    }

    public final void setResourceFolder(String resourceFolder) {
        this.resourceFolder = resourceFolder;
    }

    public final String getResourceFolder() {
        if (this.resourceFolder == null) {
            return resourcePath;
        }
        return this.resourceFolder;
    }

    public static String getResourcePath() {
        return resourcePath;
    }

    public static void setResourcePath(String resourcePath) {
        DesignSessionImpl.resourcePath = resourcePath;
    }

    private void initDefaultTOCStyle() {
        this.defaultTOCStyleList = new ArrayList<DesignElement>();
        URL url = new ResourceLocatorImpl().findResource(null, TOC_DEFAULT_VALUE, 0, null);
        if (url == null) {
            return;
        }
        ReportDesign tocDesign = null;
        try {
            DesignSessionImpl session = new DesignSessionImpl(this.locale);
            tocDesign = session.openDesign(url, url.openStream());
            tocDesign.setReadOnly();
        }
        catch (IOException | DesignFileException e) {
            LOG.log(Level.SEVERE, "Could not init default TOC style", (Throwable)e);
            return;
        }
        ContainerSlot styles = tocDesign.getSlot(0);
        int i = 0;
        while (i < styles.getCount()) {
            this.defaultTOCStyleList.add(styles.getContent(i));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<DesignElement> getDefaultTOCStyleValue() {
        if (this.isTOCStyleInitialized.booleanValue()) {
            return Collections.unmodifiableList(this.defaultTOCStyleList);
        }
        Class<DesignSessionImpl> clazz = DesignSessionImpl.class;
        synchronized (DesignSessionImpl.class) {
            if (!this.isTOCStyleInitialized.booleanValue()) {
                this.initDefaultTOCStyle();
                this.isTOCStyleInitialized = Boolean.TRUE;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Collections.unmodifiableList(this.defaultTOCStyleList);
        }
    }

    public final Module getOpenedModule(String location) {
        if (location == null) {
            return null;
        }
        Iterator<Module> iter = this.getModuleIterator();
        while (iter.hasNext()) {
            Module tmpModule = iter.next();
            if (!location.equalsIgnoreCase(tmpModule.getLocation())) continue;
            return tmpModule;
        }
        return null;
    }
}

